/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.transfer.dto;

import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.ge.pp.transfer.dto.ProprieteDeclaPPKey;
import ch.ge.afc.ael.bo.depotdeclaration.pp.dto.DossierDeclaPP;
import ch.ge.afc.ael.bo.depotdeclaration.pp.dto.ProprieteDeclaPP;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DossierMetaData
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(DossierMetaData.class);
    private final String idDossier;
    private final String numeroContribuable;
    private final int refContribuable;
    private final int refConjoint;
    private final int periode;
    private boolean released;

    private DossierMetaData(String idDossier, String numeroContribuable, int refContribuable, int refConjoint, int periode) {
        assert (idDossier != null && numeroContribuable != null);
        this.idDossier = idDossier;
        this.numeroContribuable = numeroContribuable;
        this.refContribuable = refContribuable;
        this.refConjoint = refConjoint;
        this.periode = periode;
    }

    @Nonnull
    public String getIdDossier() {
        return this.idDossier;
    }

    public int getRefContribuable() {
        return this.refContribuable;
    }

    @Nonnull
    public String getNumeroContribuable() {
        return this.numeroContribuable;
    }

    public int getPeriode() {
        return this.periode;
    }

    public DossierDeclaPP newDossierDeclaPP() {
        DossierDeclaPP dossier = new DossierDeclaPP();
        dossier.setKeyNumber(this.idDossier);
        ArrayList<ProprieteDeclaPP> properties = new ArrayList<ProprieteDeclaPP>(8);
        properties.add(new ProprieteDeclaPP(ProprieteDeclaPPKey.NUMERO_CONTRIBUABLE.key(), this.numeroContribuable));
        String refContribuableStr = String.valueOf(this.refContribuable);
        properties.add(new ProprieteDeclaPP(ProprieteDeclaPPKey.NUMERO_REFERENCE.key(), refContribuableStr));
        dossier.setNumRef1(refContribuableStr);
        String refConjointStr = String.valueOf(this.refConjoint);
        properties.add(new ProprieteDeclaPP(ProprieteDeclaPPKey.NUMERO_REFERENCE_CONJOINT.key(), refConjointStr));
        dossier.setNumRef2(refConjointStr);
        int periode = ApplicationConfig.getInstance().getJahr();
        properties.add(new ProprieteDeclaPP(ProprieteDeclaPPKey.ANNEE_PERIODE.key(), String.valueOf(periode)));
        dossier.setPeriodeFiscale(periode);
        dossier.setListePropriete(properties);
        return dossier;
    }

    public static DossierMetaData loadIdentificationFromDossier(String numeroReference, String cxafc, DossierDeclaPP dossier) {
        if (numeroReference == null) {
            throw new NullPointerException("Reference number cannot be null");
        }
        if (cxafc == null) {
            throw new NullPointerException("Security token cxafc cannot be null");
        }
        if (dossier == null) {
            throw new NullPointerException("File cannot be null");
        }
        String idDossier = dossier.getKeyNumber();
        if (idDossier == null) {
            throw new IllegalArgumentException("Field idDossier (keyNumber) from dossier is null");
        }
        List properties = dossier.getListePropriete();
        if (properties == null) {
            throw new IllegalArgumentException("Dossier has null property list");
        }
        HashMap<String, String> propertiesMap = new HashMap<String, String>(properties.size());
        for (ProprieteDeclaPP property : properties) {
            String key = property.getCle();
            String previousValue = propertiesMap.put(key, property.getValeur());
            if (previousValue == null) continue;
            LOG.warn("Ignoring duplicated property {} with value {}", (Object)key, (Object)previousValue);
        }
        String numeroContribuable = DossierMetaData.getProperty(propertiesMap, ProprieteDeclaPPKey.NUMERO_CONTRIBUABLE);
        int refContribuable = DossierMetaData.getIntegerProperty(propertiesMap, ProprieteDeclaPPKey.NUMERO_REFERENCE);
        int refConjoint = DossierMetaData.getIntegerProperty(propertiesMap, ProprieteDeclaPPKey.NUMERO_REFERENCE_CONJOINT, false);
        int periode = DossierMetaData.getIntegerProperty(propertiesMap, ProprieteDeclaPPKey.ANNEE_PERIODE);
        return new DossierMetaData(idDossier, numeroContribuable, refContribuable, refConjoint, periode);
    }

    private static String getProperty(Map<String, String> properties, ProprieteDeclaPPKey property) {
        return DossierMetaData.getProperty(properties, property, true);
    }

    private static String getProperty(Map<String, String> properties, ProprieteDeclaPPKey property, boolean required) {
        assert (properties != null && property != null);
        String value = properties.get(property.key());
        if (required && value == null) {
            throw new IllegalArgumentException("Missing required property: " + String.valueOf((Object)property));
        }
        return value;
    }

    private static int getIntegerProperty(Map<String, String> properties, ProprieteDeclaPPKey property) {
        return DossierMetaData.getIntegerProperty(properties, property, true);
    }

    private static int getIntegerProperty(Map<String, String> properties, ProprieteDeclaPPKey property, boolean required) {
        int value;
        assert (properties != null && property != null);
        String valueStr = DossierMetaData.getProperty(properties, property, required);
        if (valueStr == null) {
            assert (!required);
            return 0;
        }
        try {
            value = Integer.parseInt(valueStr);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Cannot parse number property '" + String.valueOf((Object)property) + "' as an integer: " + valueStr, e);
        }
        return value;
    }

    public final String toString() {
        return new ToStringBuilder((Object)this).append("refContribuable", this.refContribuable).append("refConjoint", this.refConjoint).append("idDossier", (Object)this.idDossier).append("numeroContribuable", (Object)this.numeroContribuable).append("periode", this.periode).build();
    }

    public boolean isReleased() {
        return this.released;
    }

    public void setReleased(boolean released) {
        this.released = released;
    }
}

