/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.prefill;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PreFillXML {
    private static final String DVBERN_TEMPLATE = "<?xml version='1.0' encoding='UTF-8'?><doc xmlns=\"http://www.dvbern.ch/taxme/GeTax/pp/barcode\"><fh id=\"PG1\"></fh></doc>";
    private static final Logger LOG = LoggerFactory.getLogger(PreFillXML.class);
    private static final String TRANSFORM_XSLT = "vorabfuellung.xslt";
    public static boolean SAVE_XML = false;

    protected PreFillXML() {
    }

    @Nullable
    public static byte[] transform(@Nonnull Map<String, String> preFillParams, @Nonnull InputStream xmlAFCStream) {
        Objects.requireNonNull(preFillParams);
        Objects.requireNonNull(xmlAFCStream);
        try {
            LOG.debug("Generic transform with params");
            ByteArrayInputStream xmlDVBStream = new ByteArrayInputStream(DVBERN_TEMPLATE.getBytes(StandardCharsets.UTF_8));
            if (SAVE_XML) {
                PreFillXML.saveXML(xmlAFCStream, "xmlAFC.xml");
                PreFillXML.saveXML(xmlDVBStream, "xmlDVB.xml");
            }
            return PreFillXML.internTransform(xmlDVBStream, xmlAFCStream, preFillParams);
        }
        catch (TransformerException e) {
            LOG.error("Fehler bei der Transformation(Vorabfuellung)", (Throwable)e);
            return null;
        }
    }

    private static void saveXML(@NotNull InputStream xmlStream, String targetFilename) {
        String tmpDir = System.getProperty("java.io.tmpdir");
        String fileDir = tmpDir != null ? tmpDir : "";
        File targetFile = new File(fileDir + File.separator + targetFilename);
        try {
            if (xmlStream.available() == 0) {
                return;
            }
            Files.copy(xmlStream, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            xmlStream.reset();
        }
        catch (IOException e) {
            LOG.error("Error presisting xml", (Throwable)e);
        }
        IOUtils.closeQuietly((InputStream)xmlStream);
    }

    @Nullable
    public static byte[] transform(@Nonnull InputStream xmlDVBStream, @Nonnull InputStream xmlAFCStream) {
        try {
            return PreFillXML.internTransform(xmlDVBStream, xmlAFCStream, Collections.emptyMap());
        }
        catch (TransformerException e) {
            LOG.debug("Fehler bei der Transformation(Vorabfuellung)", (Throwable)e);
            return null;
        }
    }

    private static byte[] internTransform(@Nonnull InputStream xmlDVBStream, @Nonnull InputStream xmlAFCStream, @Nullable Map<String, String> preFillParams) throws TransformerException {
        Objects.requireNonNull(xmlDVBStream);
        Objects.requireNonNull(xmlAFCStream);
        if (SAVE_XML) {
            PreFillXML.saveXML(xmlAFCStream, "xmlAFC.xml");
            PreFillXML.saveXML(xmlDVBStream, "xmlDVB.xml");
        }
        StreamSource xmlSource = new StreamSource(xmlDVBStream);
        StreamSource xsltSource = new StreamSource(PreFillXML.getFile(TRANSFORM_XSLT));
        StreamResult xmlResult = new StreamResult(new ByteArrayOutputStream());
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer(xsltSource);
        transformer.setURIResolver(new StringUriResolver("afcDocument", xmlAFCStream));
        for (Map.Entry<String, String> stringStringEntry : preFillParams.entrySet()) {
            transformer.setParameter(stringStringEntry.getKey(), stringStringEntry.getValue());
        }
        transformer.setErrorListener(new MyErrorListener());
        transformer.transform(xmlSource, xmlResult);
        return ((ByteArrayOutputStream)xmlResult.getOutputStream()).toByteArray();
    }

    private static InputStream getFile(String filename) {
        InputStream xsltTransformStream = PreFillXML.class.getResourceAsStream(filename);
        Objects.requireNonNull(xsltTransformStream);
        return xsltTransformStream;
    }

    static final class StringUriResolver
    implements URIResolver {
        Map<String, Source> documents = new HashMap<String, Source>();

        private StringUriResolver(String href, InputStream document) {
            this.documents.put(href, new StreamSource(document));
        }

        @Override
        public Source resolve(String href, String base) throws TransformerException {
            return this.documents.get(href);
        }
    }

    static final class MyErrorListener
    implements ErrorListener {
        MyErrorListener() {
        }

        @Override
        public void warning(TransformerException exception) throws TransformerException {
            LOG.info(exception.getMessage());
        }

        @Override
        public void error(TransformerException exception) throws TransformerException {
            LOG.info(exception.getMessage());
        }

        @Override
        public void fatalError(TransformerException exception) throws TransformerException {
            LOG.info(exception.getMessage());
        }
    }
}

