/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.justificatifs;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public enum UserDocumentCategory {
    RELEVE_FISCAL("documents.category.releveFiscal", "DOCUMENT_ANNEXE_F", true),
    TITRES("documents.category.titres", "DOCUMENT_ANNEXE_F", false),
    INDEPENDANT("documents.category.independant", "DOCUMENT_ANNEXE_B", false),
    IMMOBILIER("documents.category.immobilier", "DOCUMENT_ANNEXE_D", false),
    AUTRES("documents.category.autres", "DOCUMENT_ANNEXE_V", false);

    @Nonnull
    private final String key;
    @Nonnull
    private final String uploadKey;
    private final boolean canHaveBarcode;

    private UserDocumentCategory(String key, String uploadKey, boolean canHaveBarcode) {
        Objects.requireNonNull(key, "Key cannot be null.");
        Objects.requireNonNull(uploadKey, "Upload key cannot be null.");
        this.key = key;
        this.uploadKey = uploadKey;
        this.canHaveBarcode = canHaveBarcode;
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    @Nonnull
    public String getUploadKey() {
        return this.uploadKey;
    }

    public boolean isCanHaveBarcode() {
        return this.canHaveBarcode;
    }

    @Nonnull
    public static List<Object> onlyThoseWithBarcode(boolean hasBarcode) {
        ArrayList<Object> subSet = new ArrayList<Object>();
        if (hasBarcode) {
            subSet.add((Object)RELEVE_FISCAL);
        } else {
            subSet.add((Object)RELEVE_FISCAL);
            subSet.add((Object)TITRES);
            subSet.add((Object)INDEPENDANT);
            subSet.add((Object)IMMOBILIER);
            subSet.add((Object)AUTRES);
        }
        return subSet;
    }

    @Nonnull
    public static List<Object> withBarcode(boolean hasBarcode) {
        ArrayList<Object> subSet = new ArrayList<Object>();
        if (hasBarcode) {
            subSet.add((Object)RELEVE_FISCAL);
        } else {
            subSet.add((Object)TITRES);
            subSet.add((Object)INDEPENDANT);
            subSet.add((Object)IMMOBILIER);
            subSet.add((Object)AUTRES);
        }
        return subSet;
    }
}

