/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.justificatifs;

import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.modelitems.Table;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.ge.pp.justificatifs.Category;
import ch.dvbern.tax.ge.pp.justificatifs.CategoryTreeEntry;
import ch.dvbern.tax.ge.pp.justificatifs.Justificatif;
import ch.dvbern.tax.ge.pp.justificatifs.ResolvedDocument;
import ch.dvbern.tax.ge.pp.utils.SharedUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ResolvedCategory {
    private static final char KEY_SEP = '.';
    private static final Pattern KEY_SEP_PTN = Pattern.compile(Pattern.quote(String.valueOf('.')));
    public static final int ROOT_LEVEL = 0;
    @Nonnull
    private final String label;
    @Nonnull
    private final Category category;
    private final int level;
    @Nonnull
    private final Set<ResolvedDocument> docs;

    private ResolvedCategory(@Nonnull String label, @Nonnull Category category, int level, Set<ResolvedDocument> docs) {
        assert (label != null && category != null && docs != null);
        assert (level >= 0);
        this.label = label;
        this.category = category;
        this.level = level;
        this.docs = Collections.unmodifiableSet(docs);
    }

    public static List<ResolvedCategory> resolveAll(@Nonnull Map<String, ModelItemDTO> dataModel, @Nonnull Map<String, LogicModelItem> logicModel) {
        if (dataModel == null) {
            throw new NullPointerException("Data model cannot be null.");
        }
        if (logicModel == null) {
            throw new NullPointerException("Logic model cannot be null.");
        }
        Set<CategoryTreeEntry> categoryTree = CategoryTreeEntry.getCategoryTree();
        return ResolvedCategory.resolveChildren(dataModel, logicModel, 0, categoryTree);
    }

    @Nonnull
    private static List<ResolvedCategory> resolveChildren(@Nonnull Map<String, ModelItemDTO> dataModel, @Nonnull Map<String, LogicModelItem> logicModel, int level, @Nonnull Set<CategoryTreeEntry> categoryTree) {
        ArrayList<ResolvedCategory> categories = new ArrayList<ResolvedCategory>();
        for (CategoryTreeEntry entry : categoryTree) {
            Category category = entry.getCategory();
            String[] categoryAddOnLmks = category.getAddOnsLmk();
            Set<Justificatif> justificatifs = entry.getJustificatifs();
            ResolvedCategory resolvedCategory = null;
            if (categoryAddOnLmks.length > 0) {
                categories.addAll(ResolvedCategory.buildDynamicCategories(dataModel, logicModel, category, level, justificatifs, categoryAddOnLmks));
            } else {
                resolvedCategory = ResolvedCategory.buildSimpleCategory(dataModel, logicModel, category, level, justificatifs);
            }
            List<ResolvedCategory> childCategories = ResolvedCategory.resolveChildren(dataModel, logicModel, level + 1, entry.getChildren());
            if (!childCategories.isEmpty() || resolvedCategory != null && !resolvedCategory.getDocs().isEmpty()) {
                categories.add(resolvedCategory);
            }
            categories.addAll(childCategories);
        }
        return categories;
    }

    @Nonnull
    private static ResolvedCategory buildSimpleCategory(@Nonnull Map<String, ModelItemDTO> dataModel, @Nonnull Map<String, LogicModelItem> logicModel, @Nonnull Category category, int level, @Nonnull Set<Justificatif> justificatifs) throws LocalizationHelper.LocalizationHelperException {
        LinkedHashSet<ResolvedDocument> docs = new LinkedHashSet<ResolvedDocument>();
        for (Justificatif justificatif : justificatifs) {
            List<String> stateDmks = ResolvedCategory.getAllDmksFromLmk(dataModel, logicModel, justificatif.getStateLmk());
            ResolvedCategory.buildDocs(dataModel, justificatif, stateDmks, docs);
        }
        return new ResolvedCategory(SharedUtils.translate(category.getKey(), new Object[0]), category, level, docs);
    }

    @Nonnull
    private static List<ResolvedCategory> buildDynamicCategories(@Nonnull Map<String, ModelItemDTO> dataModel, @Nonnull Map<String, LogicModelItem> logicModel, @Nonnull Category category, int level, @Nonnull Set<Justificatif> justificatifs, @Nonnull String[] categoryAddOnLmks) throws LocalizationHelper.LocalizationHelperException {
        assert (logicModel != null && dataModel != null && category != null && justificatifs != null && categoryAddOnLmks != null);
        assert (categoryAddOnLmks.length > 0);
        ArrayList<ResolvedCategory> categories = new ArrayList<ResolvedCategory>();
        String categoryMainAddOnLmk = categoryAddOnLmks[0];
        for (String categoryMainAddOnDmk : ResolvedCategory.getAllDmksFromLmk(dataModel, logicModel, categoryMainAddOnLmk)) {
            LinkedHashSet<ResolvedDocument> docs = new LinkedHashSet<ResolvedDocument>();
            Object[] categoryAddOns = new Object[categoryAddOnLmks.length];
            categoryAddOns[0] = ResolvedCategory.getAddOnValue(dataModel, categoryMainAddOnDmk);
            for (int i = 1; i < categoryAddOnLmks.length; ++i) {
                String categoryAddOnLmk = categoryAddOnLmks[i];
                categoryAddOns[i] = ResolvedCategory.getAddOnValue(dataModel, categoryAddOnLmk, categoryMainAddOnDmk);
            }
            for (Justificatif justificatif : justificatifs) {
                String baseLmk = ResolvedCategory.commonBaseLmk(categoryMainAddOnLmk, justificatif.getStateLmk());
                List<String> stateDmks = ResolvedCategory.getAllDmksFromLmk(dataModel, logicModel, new StringBuilder(EngineUtil.mergeModelKey((String)baseLmk, (String)categoryMainAddOnDmk)), new StringBuilder(baseLmk), justificatif.getStateLmk().substring(baseLmk.length()));
                ResolvedCategory.buildDocs(dataModel, justificatif, stateDmks, docs);
            }
            if (docs.isEmpty()) continue;
            categories.add(new ResolvedCategory(SharedUtils.translate(category.getKey(), categoryAddOns), category, level, docs));
        }
        return categories;
    }

    @Nonnull
    private static String commonBaseLmk(@Nonnull String lmkA, @Nonnull String lmkB) {
        assert (lmkA != null && lmkB != null);
        int lastSep = 0;
        int minLength = Math.min(lmkA.length(), lmkB.length());
        for (int i = 0; i < minLength; ++i) {
            char c = lmkA.charAt(i);
            if (c != lmkB.charAt(i)) {
                return lmkA.substring(0, lastSep);
            }
            if (c != '.') continue;
            lastSep = i;
        }
        return lmkA.substring(0, minLength);
    }

    private static void buildDocs(@Nonnull Map<String, ModelItemDTO> dataModel, @Nonnull Justificatif justificatif, @Nonnull List<String> stateDmks, @Nonnull Collection<? super ResolvedDocument> docs) throws LocalizationHelper.LocalizationHelperException {
        for (String stateDmk : stateDmks) {
            ResolvedDocument doc;
            ModelItemDTO stateItem = dataModel.get(stateDmk);
            if (stateItem == null || stateItem.getState() == 12 || stateItem.getState() == 11 || (doc = ResolvedCategory.buildDoc(dataModel, justificatif, stateDmk)) == null) continue;
            docs.add(doc);
        }
    }

    @Nullable
    private static ResolvedDocument buildDoc(@Nonnull Map<String, ModelItemDTO> dataModel, @Nonnull Justificatif justificatif, @Nonnull String stateDmk) throws LocalizationHelper.LocalizationHelperException {
        assert (dataModel != null && justificatif != null && stateDmk != null);
        String[] addOnLmks = justificatif.getAddOnLmks();
        Object[] addOns = new Object[addOnLmks.length];
        for (int i = 0; i < addOnLmks.length; ++i) {
            addOns[i] = ResolvedCategory.getAddOnValue(dataModel, addOnLmks[i], stateDmk);
        }
        String labelKey = null;
        if (justificatif.isGetLabelFromModel()) {
            Object labelObj;
            ModelItemDTO labelItem = dataModel.get(EngineUtil.mergeModelKey((String)justificatif.getLabel(), (String)stateDmk));
            if (labelItem != null && (labelObj = labelItem.getValue()) != null) {
                labelKey = labelObj.toString();
            }
        } else {
            labelKey = justificatif.getLabel();
        }
        return labelKey == null ? null : new ResolvedDocument(justificatif, SharedUtils.translate(labelKey, addOns));
    }

    @Nonnull
    private static Object getAddOnValue(@Nonnull Map<String, ModelItemDTO> dataModel, @Nonnull String lmk, @Nonnull String contextDmk) {
        assert (dataModel != null && lmk != null && contextDmk != null);
        return ResolvedCategory.getAddOnValue(dataModel, EngineUtil.mergeModelKey((String)lmk, (String)contextDmk));
    }

    @Nonnull
    private static Object getAddOnValue(@Nonnull Map<String, ModelItemDTO> dataModel, @Nonnull String dmk) {
        Object value;
        assert (dataModel != null && dmk != null);
        ModelItemDTO item = dataModel.get(dmk);
        Object object = value = item != null ? item.getValue() : "";
        if (value == null) {
            value = "";
        }
        return value;
    }

    @Nonnull
    private static List<String> getAllDmksFromLmk(@Nonnull Map<String, ModelItemDTO> dataModel, @Nonnull Map<String, LogicModelItem> logicModel, @Nonnull String lmk) {
        return ResolvedCategory.getAllDmksFromLmk(dataModel, logicModel, new StringBuilder(), new StringBuilder(), lmk);
    }

    @Nonnull
    private static List<String> getAllDmksFromLmk(@Nonnull Map<String, ModelItemDTO> dataModel, @Nonnull Map<String, LogicModelItem> logicModel, @Nonnull StringBuilder dmkBuilder, @Nonnull StringBuilder lmkBuilder, String lmk) {
        assert (dataModel != null && logicModel != null && lmk != null);
        Scanner lmkScanner = new Scanner(lmk);
        lmkScanner.useDelimiter(KEY_SEP_PTN);
        int startPos = lmkBuilder.length();
        while (lmkScanner.hasNext()) {
            String lmkToken = lmkScanner.next();
            ResolvedCategory.addToken(lmkBuilder, lmkToken);
            LogicModelItem lmi = logicModel.get(lmkBuilder.toString());
            if (lmi == null) {
                lmkScanner.close();
                throw new IllegalArgumentException("Cannot retrieve intermediate node " + lmkToken + " in LMK " + String.valueOf(lmkBuilder));
            }
            ResolvedCategory.addToken(dmkBuilder, lmkToken);
            if (!(lmi instanceof Table)) continue;
            lmkScanner.close();
            String tableDmk = dmkBuilder.toString();
            ModelItemDTO tableItem = dataModel.get(tableDmk);
            if (tableItem == null) {
                return Collections.emptyList();
            }
            Object indexesObj = tableItem.getValue();
            if (indexesObj == null) {
                return Collections.emptyList();
            }
            if (!(indexesObj instanceof Set)) {
                assert (false);
                return Collections.emptyList();
            }
            ArrayList indexes = new ArrayList((Set)indexesObj);
            Collections.sort(indexes);
            ArrayList<String> result = new ArrayList<String>();
            int dmkMark = dmkBuilder.length();
            int lmkMark = lmkBuilder.length();
            String remainingLmk = lmk.substring(lmkBuilder.length() - startPos);
            for (String index : indexes) {
                ResolvedCategory.addToken(dmkBuilder, index);
                result.addAll(ResolvedCategory.getAllDmksFromLmk(dataModel, logicModel, dmkBuilder, lmkBuilder, remainingLmk));
                dmkBuilder.setLength(dmkMark);
                lmkBuilder.setLength(lmkMark);
            }
            return result;
        }
        return Collections.singletonList(dmkBuilder.toString());
    }

    private static void addToken(@Nonnull StringBuilder sb, @Nonnull String token) {
        assert (sb != null && token != null);
        if (sb.length() > 0) {
            sb.append('.');
        }
        sb.append(token);
    }

    @Nonnull
    public String getLabel() {
        return this.label;
    }

    @Nonnull
    public Category getCategory() {
        return this.category;
    }

    public int getLevel() {
        return this.level;
    }

    @Nonnull
    public Set<ResolvedDocument> getDocs() {
        return this.docs;
    }
}

