/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.ictax;

import ch.dvbern.tax.ge.pp.ictax.Sign;
import java.math.BigDecimal;
import javax.annotation.Nullable;
import org.joda.time.LocalDate;

public class Payment {
    private final BigDecimal valueCHF;
    private final boolean withHoldingTax;
    private final Sign sign;
    private final LocalDate paymentDate;

    Payment(ch.admin.estv.xmlns.ictax._1_2_0.kursliste.Payment payment) {
        this.valueCHF = payment.getValueCHF();
        this.withHoldingTax = payment.isWithHoldingTax();
        this.sign = Sign.parse(payment.getSign());
        this.paymentDate = payment.getPaymentDate();
    }

    @Nullable
    public BigDecimal getValueCHF() {
        return this.valueCHF;
    }

    public boolean isWithHoldingTax() {
        return this.withHoldingTax;
    }

    @Nullable
    public Sign getSign() {
        return this.sign;
    }

    @Nullable
    public LocalDate getPaymentDate() {
        return this.paymentDate;
    }
}

