/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.ictax;

import ch.admin.estv.xmlns.ictax._1_2_0.kursliste.Instrument;
import ch.dvbern.tax.ge.pp.ictax.DvbTaxInstrument;
import ch.dvbern.tax.ge.pp.ictax.DvbTaxInstrumentType;
import ch.dvbern.tax.ge.pp.ictax.PaymentShare;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

public class InstrumentShare
extends DvbTaxInstrument {
    private final List<PaymentShare> payments;

    InstrumentShare(ch.admin.estv.xmlns.ictax._1_2_0.kursliste.InstrumentShare share) {
        super(DvbTaxInstrumentType.SHARE, (Instrument)share, share.getTaxValue(), share.getNominalAmount(), share.getInstitutionIdentifier(), share.getInstitutionIdentifierAppendix(), share.getCountry(), share.getCurrency(), share.getLegend());
        assert (share != null);
        List payments = share.getPayment();
        ArrayList<PaymentShare> tmp = new ArrayList<PaymentShare>(payments.size());
        for (ch.admin.estv.xmlns.ictax._1_2_0.kursliste.PaymentShare payment : payments) {
            if (payment.isDeleted()) continue;
            tmp.add(new PaymentShare(payment));
        }
        Collections.sort(tmp, new Comparator<PaymentShare>(){

            @Override
            public int compare(PaymentShare p1, PaymentShare p2) {
                LocalDate exDate1 = p1.getExDate();
                LocalDate exDate2 = p2.getExDate();
                if (exDate1 == null) {
                    if (exDate2 == null) {
                        return 0;
                    }
                    return 1;
                }
                if (exDate2 == null) {
                    return -1;
                }
                return exDate1.compareTo((ReadablePartial)exDate2);
            }
        });
        this.payments = Collections.unmodifiableList(tmp);
    }

    @Nonnull
    public List<PaymentShare> getPayments() {
        return this.payments;
    }
}

