/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.ictax;

import ch.admin.estv.xmlns.ictax._1_2_0.kursliste.Instrument;
import ch.admin.estv.xmlns.ictax._1_2_0.kursliste.ObjectFactory;
import ch.dvbern.tax.ge.pp.ictax.DvbTaxInstrument;
import ch.dvbern.tax.ge.pp.ictax.DvbTaxInstrumentType;
import ch.dvbern.tax.ge.pp.utils.InternalFailureException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ICTAXUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ICTAXUtils.class);
    private static final String CTX_PATH = ObjectFactory.class.getPackage().getName();
    private static final Pattern ISIN_PTN = Pattern.compile("(\\p{Alpha}{2}\\p{Alnum}{9})(\\p{Digit})");
    private static final Pattern VALOR_NUMBER_PTN = Pattern.compile("[1-9][0-9]*");
    private static final ThreadLocal<Unmarshaller> UNMARSHALLER = new ThreadLocal<Unmarshaller>(){

        @Override
        protected Unmarshaller initialValue() {
            try {
                return ICTAXUtils.createICTAXJAXBContext().createUnmarshaller();
            }
            catch (JAXBException e) {
                throw new InternalFailureException("Failed to create unmarshaller.", e);
            }
        }
    };
    private static final ThreadLocal<Marshaller> MARSHALLER = new ThreadLocal<Marshaller>(){

        @Override
        protected Marshaller initialValue() {
            try {
                return ICTAXUtils.createICTAXJAXBContext().createMarshaller();
            }
            catch (JAXBException e) {
                throw new InternalFailureException("Failed to create unmarshaller.", e);
            }
        }
    };

    private ICTAXUtils() {
    }

    public static boolean isValorNumber(@Nonnull String number) {
        if (number == null) {
            throw new NullPointerException("Number cannot be null.");
        }
        return VALOR_NUMBER_PTN.matcher(number).matches();
    }

    public static boolean isISIN(@Nonnull String number) {
        if (number == null) {
            throw new NullPointerException("Number cannot be null.");
        }
        Matcher m = ISIN_PTN.matcher(number.toUpperCase());
        if (!m.matches()) {
            return false;
        }
        String payload = m.group(1);
        int checkDigit = Integer.parseInt(m.group(2));
        int pos = 1;
        int sum = 0;
        for (int i = payload.length() - 1; i >= 0; --i) {
            int n = Character.digit(payload.charAt(i), 36);
            int toAddRight = n % 10 * (pos % 2 == 0 ? 1 : 2);
            sum += toAddRight / 10 + toAddRight % 10;
            ++pos;
            if (n < 10) continue;
            int toAddLeft = n / 10 * (pos % 2 == 0 ? 1 : 2);
            sum += toAddLeft / 10 + toAddLeft % 10;
            ++pos;
        }
        int modulus = sum % 10;
        int actualCheckDigit = modulus == 0 ? 0 : 10 - modulus;
        return actualCheckDigit == checkDigit;
    }

    @Nonnull
    public static JAXBContext createICTAXJAXBContext() throws JAXBException {
        return JAXBContext.newInstance((String)CTX_PATH);
    }

    @Nullable
    public static DvbTaxInstrument unmarshall(@Nonnull String xmlFragment, @Nonnull DvbTaxInstrumentType type) {
        if (xmlFragment == null) {
            throw new NullPointerException("XML fragment cannot be null.");
        }
        if (type == null) {
            throw new NullPointerException("Instrument type cannot be null.");
        }
        try {
            return type.build((Instrument)((JAXBElement)UNMARSHALLER.get().unmarshal((Reader)new StringReader(xmlFragment))).getValue());
        }
        catch (JAXBException e) {
            LOG.error("Error unmarsahlling ICTax XML fragment", (Throwable)e);
        }
        catch (ClassCastException e) {
            assert (false) : "Invalid XML fragment: " + e.getMessage();
            LOG.error("Error unmarsahlling ICTax XML fragment", (Throwable)e);
        }
        return null;
    }

    public static <I extends Instrument> Instrument unmarshallFragment(XMLStreamReader reader, Class<I> cls) throws JAXBException {
        if (reader == null) {
            throw new NullPointerException("XML reader cannot be null.");
        }
        if (cls == null) {
            throw new NullPointerException("Target class cannot be null.");
        }
        return (Instrument)UNMARSHALLER.get().unmarshal(reader, cls).getValue();
    }

    public static void marshall(DvbTaxInstrument instrument, Writer writer) throws JAXBException {
        if (instrument == null) {
            throw new NullPointerException("Instrument cannot be null.");
        }
        if (writer == null) {
            throw new NullPointerException("Writer instance cannot be null.");
        }
        MARSHALLER.get().marshal((Object)new JAXBElement(instrument.getType().getqName(), Instrument.class, (Object)instrument.getIctaxInstrument()), writer);
    }
}

