/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.engine.validators;

import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Map;
import javax.annotation.Nonnull;

public class VerifyCommuneCadastrale
implements Validator {
    public static final int NPA_GENEVE_BEGIN = 6600;
    public static final int NPA_GENEVE_CITY = 6621;
    public static final int NPA_GENEVE_END = 6645;
    private final Reference communeCadastrale;
    private final Reference communeTaxation;
    private final String message;

    public VerifyCommuneCadastrale(Reference communeCadastrale, Reference communeTaxation, String message) {
        this.communeCadastrale = communeCadastrale;
        this.communeTaxation = communeTaxation;
        this.message = message;
    }

    public void initializeReferences(@Nonnull Map logicModel, @Nonnull LogicModelItem logicModelItem) throws InvalidModelException {
        this.communeCadastrale.registerListenerOnReference(logicModel, logicModelItem, false);
        this.communeTaxation.registerListenerOnReference(logicModel, logicModelItem, false);
    }

    @Nonnull
    public ModelItemDTO validate(@Nonnull LogicModelItem.ProtectedMap dataModel, @Nonnull String dataModelKey, @Nonnull ModelItemDTO modelItemDTO) {
        Long cadastrale = null;
        ModelItemDTO miDTO1 = null;
        if (this.communeCadastrale != null) {
            miDTO1 = dataModel.get((Object)EngineUtil.mergeModelKey((String)this.communeCadastrale.getName(), (String)dataModelKey));
        }
        if (miDTO1 != null && miDTO1.getValue() != null) {
            cadastrale = ((Number)miDTO1.getValue()).longValue();
        }
        Long taxation = null;
        ModelItemDTO miDTO2 = null;
        if (this.communeTaxation != null) {
            miDTO2 = dataModel.get((Object)EngineUtil.mergeModelKey((String)this.communeTaxation.getName(), (String)dataModelKey));
        }
        if (miDTO2 != null && miDTO2.getValue() != null) {
            taxation = ((Number)miDTO2.getValue()).longValue();
        }
        modelItemDTO = this.controlCommuneCadastrale(cadastrale, taxation) ? modelItemDTO.clone(1) : modelItemDTO.clone(4, this.message, null, 4);
        return modelItemDTO;
    }

    private boolean controlCommuneCadastrale(Long communeCadastraleNpa, Long communeTaxationNpa) throws IllegalArgumentException {
        if (communeCadastraleNpa == null || communeTaxationNpa == null) {
            return true;
        }
        if (communeTaxationNpa > 6600L && communeTaxationNpa < 6621L && communeCadastraleNpa == communeTaxationNpa - 6600L) {
            return true;
        }
        if (communeTaxationNpa == 6621L && (communeCadastraleNpa == 21L || communeCadastraleNpa == 22L || communeCadastraleNpa == 23L || communeCadastraleNpa == 24L)) {
            return true;
        }
        return communeTaxationNpa > 6621L && communeTaxationNpa <= 6645L && communeCadastraleNpa == communeTaxationNpa - 6600L + 3L;
    }
}

