/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.engine.printer;

import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.ExpertItemPrinter;
import ch.dvbern.tax.common.transfer.dto.CustomPrinterDTO;
import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.failure.FormRendererException;
import ch.dvbern.tax.ge.pp.engine.printer.immeubles.ImmeublesCommerciauxKeys;
import ch.dvbern.tax.ge.pp.engine.printer.immeubles.ImmeublesHLMKeys;
import ch.dvbern.tax.ge.pp.engine.printer.immeubles.ImmeublesKeys;
import ch.dvbern.tax.ge.pp.engine.printer.immeubles.ImmeublesLocatifsKeys;
import ch.dvbern.tax.ge.pp.engine.printer.immeubles.ImmeublesOccupesKeys;
import ch.dvbern.tax.ge.pp.engine.printer.immeubles.ImmeublesPPEKeys;
import ch.dvbern.tax.ge.pp.engine.printer.utils.PDFTableHelper;
import ch.dvbern.tax.ge.pp.utils.DataModelUtil;
import ch.dvbern.tax.ge.pp.utils.InternalFailureException;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class ImmeublesPrinter
extends ExpertItemPrinter<CustomPrinterDTO> {
    private static final String LABEL_KEY = "label.print.immeubles";
    private static final String KEY_TABLE_IMMEUBLES_RECAPITUALTION = "Immeubles.Recapitulation";
    private static final String LABEL_SUB_KEY_ERROR = "error";
    private DataModelUtil dmUtil = null;
    private DataResource dataResource;
    private final List<PdfPTable> travauxTables = new ArrayList<PdfPTable>();

    protected void initalize(CustomPrinterDTO item) {
        this.dmUtil = new DataModelUtil(item.getDataModel());
        this.dataResource = item.getDataResource();
    }

    private String getMessage(String subLabelKey, Object ... replacementArguments) {
        assert (subLabelKey != null);
        return this.getMessage(LABEL_KEY, subLabelKey, replacementArguments);
    }

    private String getMessage(String labelKey, String subLabelKey, Object ... replacementArguments) {
        assert (labelKey != null);
        String key = labelKey + "." + subLabelKey;
        try {
            return this.getGlobalConverterContext().getLocalizationHelper().translate(labelKey + "." + subLabelKey, replacementArguments);
        }
        catch (LocalizationHelper.LocalizationHelperException e) {
            throw new InternalFailureException("Failed to translate message: " + key, e);
        }
    }

    protected void printInternal(float xOffset, float yOffset) throws FormRendererException {
        this.printTable(new ImmeublesOccupesKeys());
        this.printTable(new ImmeublesLocatifsKeys());
        this.printTable(new ImmeublesCommerciauxKeys());
        this.printTable(new ImmeublesPPEKeys());
        this.printTable(new ImmeublesHLMKeys());
        this.printTableTotal();
        this.printTableObservation();
        this.printTablesTravaux();
    }

    private void printTablesTravaux() throws FormRendererException {
        try {
            if (this.notEmpty(this.travauxTables)) {
                this.getDocumentContext().getDocument().newPage();
                this.getDocumentContext().getDocument().add((Element)new Paragraph(this.getMessage("travaux.header", new Object[0]), PDFTableHelper.FONT_TITLE_BOLD));
                for (PdfPTable table : this.travauxTables) {
                    this.getDocumentContext().getDocument().add((Element)table);
                }
            }
        }
        catch (DocumentException e) {
            throw new FormRendererException(this.getMessage(LABEL_SUB_KEY_ERROR, new Object[0]), (Throwable)e);
        }
    }

    private void createTravauxTable(ImmeublesKeys keys, String basekeyImmeuble, int countCodeImmeuble) {
        boolean printThis = this.dmUtil.getBoolean(basekeyImmeuble + "." + keys.getKeyStateFraisTravaux());
        if (printThis) {
            String basekeyTravaux = basekeyImmeuble + ".FraisSupplementaires.FraisTravauxEffectifs";
            Set<Object> collTravaux = this.dmUtil.getTableRowIndexes(basekeyTravaux);
            PdfPTable table = PDFTableHelper.getPdfPTable(Cols.TABLE_TRAVAUX.getWidths(), 2, true);
            Object parcelle = this.dmUtil.getString(basekeyImmeuble + "." + keys.getKeyParcelle());
            parcelle = StringUtils.isBlank((CharSequence)parcelle) ? "" : "-" + (String)parcelle;
            String situation = this.dmUtil.getString(basekeyImmeuble + "." + keys.getKeySituation());
            long codeLieu = this.dmUtil.getLong(basekeyImmeuble + "." + keys.getKeyCodeLieu());
            String title = codeLieu + (String)parcelle + ": " + situation + " (" + this.getMessage(keys.getTableTitleSubKey(), new Object[0]) + ")";
            this.addTravauxTitle(table, keys.getCode() + "-" + countCodeImmeuble, title);
            this.addTravauxColumnsHeader(table);
            int countCodeTravaux = 1;
            for (Object keyIndexTravaux : collTravaux) {
                this.addTravauxRow(table, basekeyTravaux + "." + keyIndexTravaux.toString(), countCodeTravaux);
                ++countCodeTravaux;
            }
            this.addFraisEffectifs(table, basekeyImmeuble + ".FraisEffectifs");
            this.addTravauxTotalRow(table, basekeyImmeuble + ".Recapitulation");
            this.travauxTables.add(table);
            PdfPTable travauxAdditionalRows = PDFTableHelper.getPdfPTable(Cols.TRAVAUX_ADDITIONAL.getWidths(), 0, true);
            this.addTravauxAdditionalRows(travauxAdditionalRows, basekeyImmeuble);
            this.travauxTables.add(travauxAdditionalRows);
        }
    }

    private void addTravauxTitle(PdfPTable table, String code, String title) {
        PDFTableHelper.addPdfCellTextBottomBorder(table, code, 2, false, true);
        PDFTableHelper.addPdfCellEmpty(table);
        PDFTableHelper.addPdfCellTitle1(table, title, 0, 5, 3);
        PdfPTable headersTypeFrais = PDFTableHelper.getPdfPTable(Cols.TRAVAUX_HEADERS.getWidths(), 1, false);
        PDFTableHelper.addPdfCellTitle1(headersTypeFrais, this.getMessage("travaux.colheader.repartition", new Object[0]), 1, 5, 4);
        PDFTableHelper.addPdfCellTitle3(headersTypeFrais, this.getMessage("travaux.colheader.eco", new Object[0]), 1, 5);
        PDFTableHelper.addPdfCellTitle3(headersTypeFrais, this.getMessage("travaux.colheader.ent", new Object[0]), 1, 5);
        PDFTableHelper.addPdfCellTitle3(headersTypeFrais, this.getMessage("travaux.colheader.fapa", new Object[0]), 1, 5);
        PDFTableHelper.addPdfCellTitle3(headersTypeFrais, this.getMessage("travaux.colheader.aut", new Object[0]), 1, 5);
        PdfPCell cell = new PdfPCell();
        cell.setColspan(4);
        cell.setPadding(0.0f);
        cell.setBorder(0);
        cell.addElement((Element)headersTypeFrais);
        table.addCell(cell);
        PDFTableHelper.addPdfCellEmpty(table);
    }

    private void addTravauxColumnsHeader(PdfPTable table) {
        PDFTableHelper.addPdfCellEmpty(table, table.getNumberOfColumns() - 8);
        PDFTableHelper.addPdfCellColumnHeader(table, this.getMessage("travaux.colheader.date", ApplicationConfig.getInstance().getJahr()), 1, 5);
        PDFTableHelper.addPdfCellColumnHeader(table, this.getMessage("travaux.colheader.entreprise", new Object[0]), 1, 5);
        PDFTableHelper.addPdfCellColumnHeader(table, this.getMessage("travaux.colheader.nature", new Object[0]), 1, 5);
        PDFTableHelper.addPdfCellColumnHeader(table, this.getMessage("travaux.colheader.eco.detail", new Object[0]), 1, 5);
        PDFTableHelper.addPdfCellColumnHeader(table, this.getMessage("travaux.colheader.ent.detail", new Object[0]), 1, 5);
        PDFTableHelper.addPdfCellColumnHeader(table, this.getMessage("travaux.colheader.fapa.detail", new Object[0]), 1, 5);
        PDFTableHelper.addPdfCellColumnHeader(table, this.getMessage("travaux.colheader.aut.detail", new Object[0]), 1, 5);
        PDFTableHelper.addPdfCellColumnHeader(table, this.getMessage("travaux.colheader.total", new Object[0]), 1, 5);
    }

    private void addTravauxRow(PdfPTable table, String basekey, int code) {
        PDFTableHelper.addPdfCellEmpty(table);
        PDFTableHelper.addPdfCellTextBottomBorder(table, code, false, true);
        PDFTableHelper.addPdfCellEmpty(table);
        PDFTableHelper.addPdfCellDate(this.dmUtil, table, basekey, "Date");
        PDFTableHelper.addPdfCellText(this.dmUtil, table, basekey, "Entreprise");
        PDFTableHelper.addPdfCellText(this.dmUtil, table, basekey, "TravauxDescription");
        PDFTableHelper.addPdfCellNumber(this.dmUtil, table, basekey, "MontantEco");
        PDFTableHelper.addPdfCellNumber(this.dmUtil, table, basekey, "MontantEnt");
        PDFTableHelper.addPdfCellNumber(this.dmUtil, table, basekey, "MontantFapa");
        PDFTableHelper.addPdfCellNumber(this.dmUtil, table, basekey, "MontantAut");
        PDFTableHelper.addPdfTotalCellNumber(this.dmUtil, table, basekey, "MontantTotal", true);
    }

    private void addFraisEffectifs(PdfPTable table, String basekey) {
        int colspan = table.getNumberOfColumns() - 5;
        this.addLineFraisEffectifs("travaux.totalrow.impotImmoCompl", "ImpotImmobilierComplementaire", table, basekey, colspan);
        this.addLineFraisEffectifs("travaux.totalrow.assuranceBatiment", "AssuranceBatiment", table, basekey, colspan);
        this.addLineFraisEffectifs("travaux.totalrow.chargesPPE", "ChargesPPEHorsChauffage", table, basekey, colspan);
        this.addLineFraisEffectifs("travaux.totalrow.VersementAuFondsDeRenovation", "VersementAuFondsDeRenovation", table, basekey, colspan);
        this.addLineFraisEffectifs("travaux.totalrow.TaxeEpurationDesEaux", "TaxeEpurationDesEaux", table, basekey, colspan);
        this.addLineFraisEffectifs("travaux.totalrow.FraisDeJardinier", "FraisDeJardinier", table, basekey, colspan);
        if (basekey.contains("ImmeublesLoues")) {
            this.addLineFraisEffectifs("travaux.totalrow.ChargeDecompteDeGerance", "ChargeDecompteDeGerance", table, basekey, colspan);
            this.addLineFraisEffectifs("travaux.totalrow.FraisDecompteDeChauffage", "FraisDecompteDeChauffage", table, basekey, colspan);
        }
    }

    private void addLineFraisEffectifs(String subKeyTitle, String subkeyValue, PdfPTable table, String basekey, int colspan) {
        PDFTableHelper.addPdfCellTextNoBorder(table, this.getMessage(subKeyTitle, new Object[0]), 2, colspan, false);
        PDFTableHelper.addPdfBlankCell(table);
        PDFTableHelper.addPdfCellNumber(this.dmUtil, table, basekey, subkeyValue);
        PDFTableHelper.addPdfBlankCell(table);
        PDFTableHelper.addPdfBlankCell(table);
        PDFTableHelper.addPdfBlankCell(table);
    }

    private void addTravauxTotalRow(PdfPTable table, String basekey) {
        int colspan = table.getNumberOfColumns() - 5;
        PDFTableHelper.addPdfCellTextNoBorder(table, this.getMessage("travaux.totalrow.total", new Object[0]), 2, colspan, false);
        PDFTableHelper.addPdfTotalCellNumber(this.dmUtil, table, basekey, "FraisTravauxEffectifsEco", true);
        PDFTableHelper.addPdfTotalCellNumber(this.dmUtil, table, basekey, "FraisTravauxEffectifsEnt", true);
        PDFTableHelper.addPdfTotalCellNumber(this.dmUtil, table, basekey, "FraisTravauxEffectifsFapa", true);
        PDFTableHelper.addPdfTotalCellNumber(this.dmUtil, table, basekey, "FraisTravauxEffectifsAut", true);
        PDFTableHelper.addPdfTotalCellNumber(this.dmUtil, table, basekey, "FraisTravauxEffectifsTotal", true);
    }

    private void addTravauxAdditionalRows(PdfPTable table, String basekey) {
        PDFTableHelper.addPdfCellTextNoBorder(table, this.getMessage("travaux.totalrow.deductibles", new Object[0]), 2, 1, false);
        PDFTableHelper.addPdfTotalCellNumber(this.dmUtil, table, basekey + ".Recapitulation", "FraisTravauxDeductibles", false);
        PDFTableHelper.addPdfCellTextNoBorder(table, this.getMessage("travaux.totalrow.deductibles.plus", new Object[0]), 1, 1, false);
        PDFTableHelper.addPdfCellTextNoBorder(table, this.getMessage("travaux.totalrow.deductibles.non", new Object[0]), 1, 1, false);
        PDFTableHelper.addPdfBlankCell(table);
        Object value = this.dmUtil.getValue(basekey + ".FraisEffectifs.FraisReportes");
        if (value != null && value instanceof Long && (Long)value != 0L) {
            String vorjahr = String.valueOf(ApplicationConfig.getInstance().getVorjahr());
            PDFTableHelper.addPdfCellTextNoBorder(table, this.getMessage("travaux.totalrow.fraisReportes", vorjahr), 2, 1, true);
            PDFTableHelper.addPdfTotalCellNumber(this.dmUtil, table, basekey + ".FraisEffectifs", "FraisReportes", true);
            PDFTableHelper.addPdfCellEmpty(table, table.getNumberOfColumns() - 2);
        }
        PDFTableHelper.addPdfCellTextNoBorder(table, this.getMessage("travaux.totalrow.deductibles.icc.ifd", new Object[0]), 2, 1, true);
        PDFTableHelper.addPdfTotalCellNumber(this.dmUtil, table, basekey + ".Recapitulation", "FraisTravauxDeductiblesPrint", true);
        PDFTableHelper.addPdfCellEmpty(table, table.getNumberOfColumns() - 2);
    }

    private void printTableTotal() throws FormRendererException {
        try {
            PdfPTable table = PDFTableHelper.getPdfPTable(Cols.IMMEUBLE_TOTAUX.getWidths(), 0, false);
            String labelKey = "total.deduction";
            String code = null;
            String keyFortuneICC = "TotalFortuneImmeublesCommerciauxPpeEtHlmICCImmExploitation";
            String keyRevenuIFD = "TotalRevenuImmeublesCommerciauxPpeEtHlmIFDImmExploitation";
            String keyChargesFraisIFD = "TotalRevenuFraisEntretienImmeublesCommerciauxPpeEtHlmIFDImmExploitation";
            String keyRevenuICC = "TotalRevenuImmeublesCommerciauxPpeEtHlmICCImmExploitation";
            String keyChargesFraisICC = "TotalRevenuFraisEntretienImmeublesCommerciauxPpeEtHlmICCImmExploitation";
            this.addTotalRow(table, code, labelKey, KEY_TABLE_IMMEUBLES_RECAPITUALTION, keyFortuneICC, keyRevenuIFD, keyChargesFraisIFD, keyRevenuICC, keyChargesFraisICC);
            labelKey = "total.revenu.fortune";
            code = "15.00";
            keyFortuneICC = "SommeTotalFortuneTousLesImmeublesICCImposable";
            keyRevenuIFD = "SommeTotalRevenuTousLesImmeublesIFDImposable";
            keyChargesFraisIFD = null;
            keyRevenuICC = "SommeTotalRevenuTousLesImmeublesICCImposable";
            keyChargesFraisICC = null;
            this.addTotalRow(table, code, labelKey, KEY_TABLE_IMMEUBLES_RECAPITUALTION, keyFortuneICC, keyRevenuIFD, keyChargesFraisIFD, keyRevenuICC, keyChargesFraisICC);
            labelKey = "total.charges.fras.entretien";
            code = "58.00";
            keyFortuneICC = null;
            keyRevenuIFD = null;
            keyChargesFraisIFD = "SommeTotalRevenuFraisEntretienTousLesImmeublesIFDImposable";
            keyRevenuICC = null;
            keyChargesFraisICC = "SommeTotalRevenuFraisEntretienTousLesImmeublesICCImposable";
            this.addTotalRow(table, code, labelKey, KEY_TABLE_IMMEUBLES_RECAPITUALTION, keyFortuneICC, keyRevenuIFD, keyChargesFraisIFD, keyRevenuICC, keyChargesFraisICC);
            PDFTableHelper.addPdfCellEmpty(table, table.getNumberOfColumns());
            this.getDocumentContext().getDocument().add((Element)table);
        }
        catch (DocumentException e) {
            throw new FormRendererException(this.getMessage(LABEL_SUB_KEY_ERROR, new Object[0]), (Throwable)e);
        }
    }

    private void printTableObservation() throws FormRendererException {
        boolean printThis = this.dmUtil.getBoolean("Immeubles.Recapitulation.ObservationsOuiNon");
        if (printThis) {
            try {
                PdfPTable table = PDFTableHelper.getPdfPTable(Cols.ONE_CELL_ROW.getWidths(), 1, true);
                PDFTableHelper.addPdfCellTitle1(table, this.getMessage("observations", new Object[0]), 0, 5, table.getNumberOfColumns());
                PDFTableHelper.addPdfCellObservation(this.dmUtil, table, KEY_TABLE_IMMEUBLES_RECAPITUALTION, "ObservationsA", table.getNumberOfColumns());
                PDFTableHelper.addPdfCellObservation(this.dmUtil, table, KEY_TABLE_IMMEUBLES_RECAPITUALTION, "ObservationsB", table.getNumberOfColumns());
                PDFTableHelper.addPdfCellObservation(this.dmUtil, table, KEY_TABLE_IMMEUBLES_RECAPITUALTION, "ObservationsC", table.getNumberOfColumns());
                this.getDocumentContext().getDocument().add((Element)table);
            }
            catch (DocumentException e) {
                throw new FormRendererException(this.getMessage(LABEL_SUB_KEY_ERROR, new Object[0]), (Throwable)e);
            }
        }
    }

    private void addTotalRow(PdfPTable table, String code, String labelKey, String keyTableName, String keyFortuneICC, String keyRevenuIFD, String keyChargesFraisIFD, String keyRevenuICC, String keyChargesFraisICC) {
        if (code != null) {
            PDFTableHelper.addPdfCellTextBottomBorder(table, code, true, false);
        } else {
            PDFTableHelper.addPdfCellTextBottomBorder(table, "", true, false);
        }
        PDFTableHelper.addPdfCellEmpty(table);
        PDFTableHelper.addPdfCellTextBottomBorder(table, this.getMessage(labelKey, new Object[0]), true, false);
        if (keyFortuneICC != null) {
            PDFTableHelper.addPdfTotalCellNumber(this.dmUtil, table, keyTableName, keyFortuneICC, true);
        } else {
            PDFTableHelper.addPdfBlankCell(table);
        }
        if (keyRevenuIFD != null) {
            PDFTableHelper.addPdfTotalCellNumber(this.dmUtil, table, keyTableName, keyRevenuIFD, true);
        } else {
            PDFTableHelper.addPdfBlankCell(table);
        }
        if (keyChargesFraisIFD != null) {
            PDFTableHelper.addPdfTotalCellNumber(this.dmUtil, table, keyTableName, keyChargesFraisIFD, true);
        } else {
            PDFTableHelper.addPdfBlankCell(table);
        }
        if (keyRevenuICC != null) {
            PDFTableHelper.addPdfTotalCellNumber(this.dmUtil, table, keyTableName, keyRevenuICC, true);
        } else {
            PDFTableHelper.addPdfBlankCell(table);
        }
        if (keyChargesFraisICC != null) {
            PDFTableHelper.addPdfTotalCellNumber(this.dmUtil, table, keyTableName, keyChargesFraisICC, true);
        } else {
            PDFTableHelper.addPdfBlankCell(table);
        }
    }

    private void printTable(ImmeublesKeys keys) throws FormRendererException {
        try {
            Set<Object> coll = this.dmUtil.getTableRowIndexes(keys.getTableName());
            if (this.notEmpty(coll)) {
                boolean isLoueOrOccupesOrCommerciaux = keys.getTableName().contains("ImmeublesLoues") || keys.getTableName().contains("ImmeublesOccupes") || keys.getTableName().contains("ImmeublesCommerciaux");
                PdfPTable table = PDFTableHelper.getPdfPTable(isLoueOrOccupesOrCommerciaux ? Cols.TABLE_IMMEUBLES_OCCUPE_LOUE.getWidths() : Cols.TABLE_IMMEUBLES.getWidths(), 2, true);
                this.addTitle(keys, table, isLoueOrOccupesOrCommerciaux);
                this.addColumnsHeader(keys, table, isLoueOrOccupesOrCommerciaux);
                this.addImmeubles(keys, table);
                this.addAdditionalRows(keys, table);
                this.getDocumentContext().getDocument().add((Element)table);
            }
        }
        catch (DocumentException e) {
            throw new FormRendererException(this.getMessage(LABEL_SUB_KEY_ERROR, new Object[0]), (Throwable)e);
        }
    }

    private void addImmeubles(ImmeublesKeys keys, PdfPTable table) {
        int countCode = 1;
        Set<Object> coll = this.dmUtil.getTableRowIndexes(keys.getTableName());
        if (this.notEmpty(coll)) {
            for (Object object : coll) {
                String keyIndex = object.toString();
                String basekey = keys.getTableName() + "." + keyIndex;
                this.addFirstRow(table, basekey, countCode, keys);
                this.addSecondRow(table, basekey, keys);
                this.addThirdRow(table, basekey, keys);
                this.createTravauxTable(keys, basekey, countCode);
                ++countCode;
            }
        }
    }

    private void addColumnsHeader(ImmeublesKeys keys, PdfPTable table, boolean isLoueOrOccupesOrCommerciaux) {
        PDFTableHelper.addPdfCellEmpty(table, 2);
        PDFTableHelper.addPdfCellColumnHeader(table, this.getMessage("titre.headerrow.2.exploitation", new Object[0]), 1, 4);
        PDFTableHelper.addPdfCellColumnHeader(table, this.getMessage("titre.headerrow.2.possessionAnneePrecedente", new Object[0]), 1, 4);
        if (isLoueOrOccupesOrCommerciaux) {
            PDFTableHelper.addPdfCellColumnHeader(table, this.getMessage("titre.headerrow.2.residence.principale", new Object[0]), 1, 4);
        }
        PDFTableHelper.addPdfCellColumnHeader(table, this.getMessage("titre.headerrow.2.code.lieu", new Object[0]), 1, 4);
        PDFTableHelper.addPdfCellColumnHeader(table, this.getMessage("titre.headerrow.2.commune.parcelle", new Object[0]), 1, 4);
        PDFTableHelper.addPdfCellColumnHeader(table, this.getMessage(keys.getHeaderColumnSituation(), new Object[0]), 1, 5);
        PDFTableHelper.addPdfCellColumnHeader(table, this.getMessage(keys.getHeaderDate(), new Object[0]), 1, 5);
        PDFTableHelper.addPdfCellColumnHeader(table, this.getMessage("titre.headerrow.2.part.contrib", new Object[0]), 1, 4);
        PDFTableHelper.addPdfCellColumnHeader(table, this.getMessage("titre.headerrow.2.part.conjoint", new Object[0]), 1, 4);
        if (keys.getHeaderCapital() != null) {
            PDFTableHelper.addPdfCellColumnHeader(table, this.getMessage(keys.getHeaderCapital(), new Object[0]), 1, 4);
        } else {
            PDFTableHelper.addPdfBlankCell(table);
        }
        if (keys.getHeaderAbattementTaux() != null) {
            PDFTableHelper.addPdfCellColumnHeader(table, this.getMessage(keys.getHeaderAbattementTaux(), new Object[0]), 1, 4);
        } else {
            PDFTableHelper.addPdfBlankCell(table);
        }
        PDFTableHelper.addPdfCellColumnHeader(table, this.getMessage(keys.getHeaderFortuneICC(), new Object[0]), 1, 4);
        PDFTableHelper.addPdfCellColumnHeader(table, this.getMessage(keys.getHeaderRevenuIFD(), new Object[0]), 1, 4);
        PDFTableHelper.addPdfCellColumnHeader(table, this.getMessage("titre.headerrow.2.charges.frais.entretien", new Object[0]), 1, 4);
        PDFTableHelper.addPdfCellColumnHeader(table, this.getMessage(keys.getHeaderRevenuICC(), new Object[0]), 1, 4);
        PDFTableHelper.addPdfCellColumnHeader(table, this.getMessage("titre.headerrow.2.charges.frais.entretien", new Object[0]), 1, 4);
    }

    private void addTitle(ImmeublesKeys keys, PdfPTable table, boolean isLoueOrOccupesOrCommerciaux) {
        PDFTableHelper.addPdfCellTitle1(table, this.getMessage(keys.getTableTitleSubKey(), new Object[0]), 0, 5, isLoueOrOccupesOrCommerciaux ? 13 : 12);
        PdfPTable tableTitle = PDFTableHelper.getPdfPTable(Cols.IMMEUBLE_HEADERS.getWidths(), 1, false);
        PDFTableHelper.addPdfCellTitle2(tableTitle, this.getMessage("titre.headerrow.2.icc", new Object[0]), 1, 5);
        PDFTableHelper.addPdfCellTitle2(tableTitle, this.getMessage("titre.headerrow.2.ifd", new Object[0]), 1, 5);
        PDFTableHelper.addPdfCellTitle2(tableTitle, this.getMessage("titre.headerrow.2.icc", new Object[0]), 1, 5);
        PDFTableHelper.addPdfCellTitle3(tableTitle, "2. " + this.getMessage("titre.headerrow.2.fortune", new Object[0]), 1, 5);
        PDFTableHelper.addPdfCellTitle3(tableTitle, "3. " + this.getMessage("titre.headerrow.2.revenu", new Object[0]), 1, 5);
        PDFTableHelper.addPdfCellTitle3(tableTitle, "1. " + this.getMessage("titre.headerrow.2.revenu", new Object[0]), 1, 5);
        PdfPCell cell = new PdfPCell();
        cell.setColspan(5);
        cell.setPadding(0.0f);
        cell.setBorder(0);
        cell.addElement((Element)tableTitle);
        table.addCell(cell);
    }

    private void addFirstRow(PdfPTable table, String basekey, int countCode, ImmeublesKeys keys) {
        PDFTableHelper.addPdfCellTextBottomBorder(table, keys.getCode() + "-" + countCode, false, true);
        PDFTableHelper.addPdfCellEmpty(table);
        PDFTableHelper.addPdfCellBoolean(this.dmUtil, table, basekey, keys.getKeyExploitation());
        PDFTableHelper.addPdfCellBoolean(this.dmUtil, table, basekey, keys.getKeyPossessionAnneePrecedente(), "O", "N");
        if (keys.getTableName().contains("ImmeublesLoues")) {
            PDFTableHelper.addPdfCellText(this.dmUtil, table, basekey, keys.getKeyResidencePrincipaleLoues());
        } else if (keys.getTableName().contains("ImmeublesOccupes") || keys.getTableName().contains("ImmeublesCommerciaux")) {
            PDFTableHelper.addPdfCellText(this.dmUtil, table, basekey, keys.getKeyResidencePrincipale());
        }
        PDFTableHelper.addPdfCellText(this.dmUtil, table, basekey, keys.getKeyCodeLieu());
        PDFTableHelper.addPdfCellText(this.dmUtil, table, basekey, keys.getKeyParcelle());
        PDFTableHelper.addPdfCellText(this.dmUtil, table, basekey, keys.getKeySituation());
        if (keys.getKeyYear() != null) {
            PDFTableHelper.addPdfCellText(this.dmUtil, table, basekey, keys.getKeyYear());
        } else {
            PDFTableHelper.addPdfCellDate(this.dmUtil, table, basekey, keys.getKeyDate());
        }
        PDFTableHelper.addPdfCellText(this.dmUtil, table, basekey, keys.getKeyPartContribuable());
        PDFTableHelper.addPdfCellText(this.dmUtil, table, basekey, keys.getKeyPartConjoint());
        if (keys.getKeyCapital() != null) {
            PDFTableHelper.addPdfCellNumber(this.dmUtil, table, basekey, keys.getKeyCapital());
        } else {
            PDFTableHelper.addPdfBlankCell(table);
        }
        if (keys.getKeyAbattementTaux() != null) {
            PDFTableHelper.addPdfCellText(this.dmUtil, table, basekey, keys.getKeyAbattementTaux());
        } else if (keys.getKeyTauxCapitalisation() != null && keys.getTableName().contains("HLM")) {
            PDFTableHelper.addPdfCellText(this.dmUtil, table, basekey, keys.getKeyTauxCapitalisation());
        } else if (keys.getKeyTauxCapitalisation() != null) {
            PDFTableHelper.addPdfCellText(this.dmUtil, table, basekey, keys.getKeyTauxCapitalisation(), this.dataResource, keys.getResourceKeyTauxCapitalisation());
        } else {
            PDFTableHelper.addPdfBlankCell(table);
        }
        PDFTableHelper.addPdfCellNumber(this.dmUtil, table, basekey, keys.getKeyFortuneICC());
        PDFTableHelper.addPdfCellNumber(this.dmUtil, table, basekey, keys.getKeyRevenuIFD());
        PDFTableHelper.addPdfCellNumber(this.dmUtil, table, basekey, keys.getKeyChargesFraisEntretienIFD());
        PDFTableHelper.addPdfCellNumber(this.dmUtil, table, basekey, keys.getKeyRevenuICC());
        PDFTableHelper.addPdfCellNumber(this.dmUtil, table, basekey, keys.getKeyChargesFraisEntretienICC());
    }

    private void addSecondRow(PdfPTable table, String basekey, ImmeublesKeys keys) {
        boolean printSecondRow;
        Boolean exoArt24 = this.dmUtil.getBooleanObject(basekey + "." + keys.getKeyExonerationArt24());
        Boolean exoArt78 = this.dmUtil.getBooleanObject(basekey + "." + keys.getKeyExonerationArt78());
        Long exoRevEtFor = this.dmUtil.getLongObject(basekey + "." + keys.getKeyExoRevenuEtFortune());
        Long exoIIC = this.dmUtil.getLongObject(basekey + "." + keys.getKeyExoPourcentageIIC());
        boolean hasExoneration = this.is(exoArt24) || this.is(exoArt78) || this.isValue(exoRevEtFor) || this.isValue(exoIIC);
        Long valeurComptable = this.dmUtil.getLongObject(basekey + "." + keys.getKeyValeurComptable());
        boolean bl = printSecondRow = this.isValue(valeurComptable) || keys.isPrintExoneration() && hasExoneration;
        if (printSecondRow) {
            PdfPTable tableSecondRow = PDFTableHelper.getPdfPTable(Cols.IMMEUBLE_EXONERATION.getWidths(), 0, false);
            PDFTableHelper.addPdfCellEmpty(tableSecondRow, 1);
            if (keys.isPrintExoneration()) {
                PDFTableHelper.addPdfCellText(tableSecondRow, this.getMessage("exoneration.article.24", new Object[0]));
                PDFTableHelper.addPdfCellBoolean(tableSecondRow, exoArt24);
                PDFTableHelper.addPdfCellText(tableSecondRow, this.getMessage("exoneration.article.78", new Object[0]));
                PDFTableHelper.addPdfCellBoolean(tableSecondRow, exoArt78);
                PDFTableHelper.addPdfCellText(tableSecondRow, this.getMessage("exoneration.revenu.et.fortune", new Object[0]));
                PDFTableHelper.addPdfCellPercent(tableSecondRow, exoRevEtFor);
                PDFTableHelper.addPdfCellText(tableSecondRow, this.getMessage("exoneration.iic", new Object[0]));
                PDFTableHelper.addPdfCellPercent(tableSecondRow, exoIIC);
            } else {
                PDFTableHelper.addPdfCellEmpty(tableSecondRow, 8);
            }
            PDFTableHelper.addPdfCellText(tableSecondRow, this.getMessage("valeur.comptable", new Object[0]));
            PDFTableHelper.addPdfCellNumber(tableSecondRow, valeurComptable);
            PDFTableHelper.addPdfCellEmpty(tableSecondRow, 1);
            PdfPCell cell = new PdfPCell();
            cell.setColspan(17);
            cell.setPadding(0.0f);
            cell.setBorder(0);
            cell.addElement((Element)tableSecondRow);
            table.addCell(cell);
        }
        PDFTableHelper.addPdfCellEmpty(table, table.getNumberOfColumns());
    }

    private void addThirdRow(PdfPTable table, String basekey, ImmeublesKeys keys) {
        boolean isOutsideOfCH;
        if (keys.getKeyIsOusideOfCH() != null && !keys.getKeyIsOusideOfCH().contains("null") && (isOutsideOfCH = this.dmUtil.getBooleanObject(basekey + "." + keys.getKeyIsOusideOfCH()).booleanValue())) {
            PdfPTable tableThirdRow = PDFTableHelper.getPdfPTable(Cols.IMMEUBLE_ETRANGER.getWidths(), 0, false, 130.0f);
            PDFTableHelper.addPdfCellEmpty(tableThirdRow, 1);
            PDFTableHelper.addPdfCellText(tableThirdRow, this.getMessage("etranger.date", new Object[0]));
            PDFTableHelper.addPdfCellDate(this.dmUtil, tableThirdRow, basekey, keys.getKeyEtrangerDate());
            PDFTableHelper.addPdfCellText(tableThirdRow, this.getMessage("etranger.devise", new Object[0]));
            PDFTableHelper.addPdfCellText(this.dmUtil, tableThirdRow, basekey, keys.getKeyEtrangerDevise());
            PDFTableHelper.addPdfCellText(tableThirdRow, this.getMessage("etranger.taux", new Object[0]));
            PDFTableHelper.addPdfCellText(this.dmUtil, tableThirdRow, basekey, keys.getKeyEtrangerTaux());
            PDFTableHelper.addPdfCellText(tableThirdRow, this.getMessage("etranger.montant", new Object[0]));
            PDFTableHelper.addPdfCellNumber(this.dmUtil, tableThirdRow, basekey, keys.getKeyEtrangerMontant());
            PDFTableHelper.addPdfCellEmpty(tableThirdRow, 1);
            PdfPCell cell = new PdfPCell();
            cell.setColspan(10);
            cell.setPadding(3.0f);
            cell.setBorder(0);
            cell.addElement((Element)tableThirdRow);
            table.addCell(cell);
            PDFTableHelper.addPdfCellEmpty(table, table.getNumberOfColumns());
        }
    }

    private boolean is(Boolean testMe) {
        return testMe != null && testMe != false;
    }

    private boolean isValue(Long testMe) {
        return testMe != null && testMe > 0L;
    }

    private boolean notEmpty(@Nullable Collection testMe) {
        return testMe != null && !testMe.isEmpty();
    }

    private void addAdditionalRows(ImmeublesKeys keys, PdfPTable table) {
        if (keys.getCodeSubvention() != null) {
            PDFTableHelper.addPdfCellEmpty(table, table.getNumberOfColumns());
        }
        if (keys.getKeyTotalReduction() != null) {
            PDFTableHelper.addPdfCellTextBottomBorder(table, "", false, true);
            PDFTableHelper.addPdfCellEmpty(table);
            PDFTableHelper.addPdfCellTextBottomBorder(table, this.getMessage("reduction.valeurLocativeSiTauxEffort", new Object[0]), table.getNumberOfColumns() - 4, false, true);
            PDFTableHelper.addPdfCellNumber(this.dmUtil, table, keys.getKeyTotalReduction());
            PDFTableHelper.addPdfCellTextBottomBorder(table, "", false, true);
        }
        if (keys.getCodeSubvention() != null) {
            PDFTableHelper.addPdfCellTextBottomBorder(table, keys.getCodeSubvention(), false, true);
            PDFTableHelper.addPdfCellEmpty(table);
            PDFTableHelper.addPdfCellTextBottomBorder(table, this.getMessage("subvention.epargne", new Object[0]), table.getNumberOfColumns() - 7, false, true);
            PDFTableHelper.addPdfCellEmpty(table);
            PDFTableHelper.addPdfCellNumber(this.dmUtil, table, keys.getKeyTotalSubventionRevenuIFD());
            PDFTableHelper.addPdfCellEmpty(table);
            PDFTableHelper.addPdfCellNumber(this.dmUtil, table, keys.getKeyTotalSubventionRevenuICC());
            PDFTableHelper.addPdfCellEmpty(table);
        }
    }

    private static enum Cols {
        TABLE_IMMEUBLES(DO.USE, DO.ADD, DO.USE, DO.USE, DO.USE, DO.USE, DO.USE, DO.USE, DO.USE, DO.USE, DO.USE, DO.USE, DO.USE, DO.USE, DO.USE, DO.USE, DO.USE, DO.USE),
        TABLE_IMMEUBLES_OCCUPE_LOUE(DO.USE, DO.ADD, DO.USE, DO.USE, DO.USE, DO.USE, DO.USE, DO.USE, DO.USE, DO.USE, DO.USE, DO.USE, DO.USE, DO.USE, DO.USE, DO.USE, DO.USE, DO.USE, DO.USE),
        TABLE_TRAVAUX(DO.USE, DO.USE, DO.USE, DO.USE, DO.ADD, DO.ADD, DO.USE, DO.ADD, DO.USE, DO.ADD, DO.ADD, DO.ADD, DO.ADD, DO.USE, DO.USE, DO.USE, DO.USE, DO.USE),
        IMMEUBLE_HEADERS(DO.IGNORE, DO.IGNORE, DO.IGNORE, DO.IGNORE, DO.IGNORE, DO.IGNORE, DO.IGNORE, DO.IGNORE, DO.IGNORE, DO.IGNORE, DO.IGNORE, DO.IGNORE, DO.IGNORE, DO.USE, DO.USE, DO.ADD, DO.USE, DO.ADD),
        IMMEUBLE_EXONERATION(DO.USE, DO.ADD, DO.ADD, DO.USE, DO.ADD, DO.ADD, DO.ADD, DO.USE, DO.USE, DO.USE, DO.USE, DO.USE, DO.USE, DO.USE, DO.USE, DO.ADD, DO.ADD, DO.USE, DO.USE, DO.ADD, DO.ADD, DO.ADD, DO.ADD, DO.ADD),
        IMMEUBLE_ETRANGER(DO.USE, DO.USE, DO.USE, DO.USE, DO.USE, DO.USE, DO.USE, DO.USE, DO.USE, DO.USE),
        IMMEUBLE_TOTAUX(DO.USE, DO.ADD, DO.USE, DO.USE, DO.ADD, DO.ADD, DO.ADD, DO.ADD, DO.ADD, DO.ADD, DO.ADD, DO.ADD, DO.ADD, DO.USE, DO.USE, DO.USE, DO.USE, DO.USE),
        TRAVAUX_ADDITIONAL(DO.USE, DO.ADD, DO.ADD, DO.ADD, DO.ADD, DO.ADD, DO.ADD, DO.ADD, DO.ADD, DO.ADD, DO.ADD, DO.ADD, DO.ADD, DO.USE, DO.ADD, DO.USE, DO.USE, DO.USE),
        TRAVAUX_HEADERS(DO.IGNORE, DO.IGNORE, DO.IGNORE, DO.IGNORE, DO.IGNORE, DO.IGNORE, DO.IGNORE, DO.IGNORE, DO.IGNORE, DO.IGNORE, DO.IGNORE, DO.IGNORE, DO.IGNORE, DO.USE, DO.USE, DO.USE, DO.USE, DO.IGNORE),
        ONE_CELL_ROW(DO.USE, DO.ADD, DO.ADD, DO.ADD, DO.ADD, DO.ADD, DO.ADD, DO.ADD, DO.ADD, DO.ADD, DO.ADD, DO.ADD, DO.ADD, DO.ADD, DO.ADD, DO.ADD, DO.ADD, DO.ADD);

        private static final List<Float> COL_WIDTHS;
        private static final List<Float> COL_WIDTHS_IMMEUBLES;
        private static final List<Float> COL_WIDTHS_EXO;
        private static final List<Float> COL_WIDTHS_ETRANGER;
        private final DO[] todos;

        private Cols(DO ... todos) {
            this.todos = todos;
        }

        public float[] getWidths() {
            if (IMMEUBLE_EXONERATION == this) {
                float[] widths = new float[COL_WIDTHS_EXO.size()];
                int length = 0;
                block16: for (int i = 0; i < COL_WIDTHS_EXO.size(); ++i) {
                    switch (this.todos[i]) {
                        case USE: {
                            widths[length] = COL_WIDTHS_EXO.get(i).floatValue();
                            ++length;
                            continue block16;
                        }
                        case ADD: {
                            int n = length - 1;
                            widths[n] = widths[n] + COL_WIDTHS_EXO.get(i).floatValue();
                            continue block16;
                        }
                    }
                }
                return Arrays.copyOf(widths, length);
            }
            if (IMMEUBLE_ETRANGER == this) {
                float[] widths = new float[COL_WIDTHS_ETRANGER.size()];
                int length = 0;
                block17: for (int i = 0; i < COL_WIDTHS_ETRANGER.size(); ++i) {
                    switch (this.todos[i]) {
                        case USE: {
                            widths[length] = COL_WIDTHS_ETRANGER.get(i).floatValue();
                            ++length;
                            continue block17;
                        }
                        case ADD: {
                            int n = length - 1;
                            widths[n] = widths[n] + COL_WIDTHS_ETRANGER.get(i).floatValue();
                            continue block17;
                        }
                    }
                }
                return Arrays.copyOf(widths, length);
            }
            if (TABLE_IMMEUBLES_OCCUPE_LOUE == this) {
                float[] widths = new float[COL_WIDTHS_IMMEUBLES.size()];
                int length = 0;
                block18: for (int i = 0; i < COL_WIDTHS_IMMEUBLES.size(); ++i) {
                    switch (this.todos[i]) {
                        case USE: {
                            widths[length] = COL_WIDTHS_IMMEUBLES.get(i).floatValue();
                            ++length;
                            continue block18;
                        }
                        case ADD: {
                            int n = length - 1;
                            widths[n] = widths[n] + COL_WIDTHS_IMMEUBLES.get(i).floatValue();
                            continue block18;
                        }
                    }
                }
                return Arrays.copyOf(widths, length);
            }
            float[] widths = new float[COL_WIDTHS.size()];
            int length = 0;
            block19: for (int i = 0; i < COL_WIDTHS.size(); ++i) {
                switch (this.todos[i]) {
                    case USE: {
                        widths[length] = COL_WIDTHS.get(i).floatValue();
                        ++length;
                        continue block19;
                    }
                    case ADD: {
                        int n = length - 1;
                        widths[n] = widths[n] + COL_WIDTHS.get(i).floatValue();
                        continue block19;
                    }
                }
            }
            return Arrays.copyOf(widths, length);
        }

        static {
            COL_WIDTHS = Arrays.asList(Float.valueOf(3.0f), Float.valueOf(1.51f), Float.valueOf(0.56f), Float.valueOf(1.75f), Float.valueOf(1.75f), Float.valueOf(3.01f), Float.valueOf(6.39f), Float.valueOf(19.55f), Float.valueOf(6.95f), Float.valueOf(4.02f), Float.valueOf(4.02f), Float.valueOf(7.33f), Float.valueOf(3.57f), Float.valueOf(7.53f), Float.valueOf(7.53f), Float.valueOf(6.77f), Float.valueOf(7.89f), Float.valueOf(6.77f));
            COL_WIDTHS_IMMEUBLES = Arrays.asList(Float.valueOf(3.0f), Float.valueOf(1.51f), Float.valueOf(0.56f), Float.valueOf(1.75f), Float.valueOf(1.75f), Float.valueOf(1.75f), Float.valueOf(3.01f), Float.valueOf(4.64f), Float.valueOf(19.55f), Float.valueOf(6.95f), Float.valueOf(4.02f), Float.valueOf(4.02f), Float.valueOf(7.33f), Float.valueOf(3.57f), Float.valueOf(7.53f), Float.valueOf(7.53f), Float.valueOf(6.77f), Float.valueOf(7.89f), Float.valueOf(6.77f));
            COL_WIDTHS_EXO = Arrays.asList(Float.valueOf(3.0f), Float.valueOf(1.51f), Float.valueOf(0.56f), Float.valueOf(1.75f), Float.valueOf(1.75f), Float.valueOf(3.01f), Float.valueOf(6.39f), Float.valueOf(2.0f), Float.valueOf(4.0f), Float.valueOf(2.0f), Float.valueOf(8.55f), Float.valueOf(3.0f), Float.valueOf(3.95f), Float.valueOf(3.0f), Float.valueOf(4.02f), Float.valueOf(4.02f), Float.valueOf(1.33f), Float.valueOf(6.0f), Float.valueOf(3.57f), Float.valueOf(7.53f), Float.valueOf(7.53f), Float.valueOf(6.77f), Float.valueOf(7.89f), Float.valueOf(6.77f));
            COL_WIDTHS_ETRANGER = Arrays.asList(Float.valueOf(9.0f), Float.valueOf(18.0f), Float.valueOf(11.0f), Float.valueOf(20.0f), Float.valueOf(6.0f), Float.valueOf(6.0f), Float.valueOf(12.0f), Float.valueOf(17.0f), Float.valueOf(12.0f), Float.valueOf(1.0f));
        }

        private static enum DO {
            USE,
            ADD,
            IGNORE;

        }
    }
}

