/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.engine.printer;

import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.TableAdditionPrinter;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.failure.FormRendererException;
import ch.dvbern.tax.ge.pp.engine.printer.utils.PDFTableHelper;
import ch.dvbern.tax.ge.pp.utils.InternalFailureException;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class GeTableAdditionPrinter
extends TableAdditionPrinter {
    @Nonnull
    private static final String EMPTY_LABEL = "label.empty";
    @Nonnull
    private static final String SUBTITLE_LABEL_KEY = "print.extrapage.suite.du.premier.tableau";
    @Nonnull
    private static final Color LIGHT_GRAY = new Color(207, 208, 210);
    @Nonnull
    private static final Color DARK_GRAY = new Color(171, 173, 176);
    @Nonnull
    private static final Map<String, ExtraPagesTableHead> STYLED_TABLES = new HashMap<String, ExtraPagesTableHead>();

    protected void printStandardTable(float xOffset, float yOffset) throws FormRendererException {
        String tableDmk = this.item.getDataModelKey();
        if (STYLED_TABLES.containsKey(tableDmk)) {
            this.printStyledTable(STYLED_TABLES.get(tableDmk));
        } else {
            super.printStandardTable(xOffset, yOffset);
        }
    }

    private void printStyledTable(@Nonnull ExtraPagesTableHead tableHead) throws FormRendererException {
        if (this.item.getPrintRows().size() >= this.rowNo) {
            try {
                ArrayList<ExpertDisplayInfoDTO.TableDTO.ColumnDTO> extraPagesCols = new ArrayList<ExpertDisplayInfoDTO.TableDTO.ColumnDTO>();
                for (ExpertDisplayInfoDTO.TableDTO.ColumnDTO col : this.item.getPrintColumns()) {
                    if (!this.isPrintable(col.getPrintMode())) continue;
                    extraPagesCols.add(col);
                }
                this.addTitles(tableHead);
                int colCount = extraPagesCols.size();
                PdfPTable table = PDFTableHelper.getPdfPTable(colCount, 1, 0.0f, 100.0f);
                this.addColHeaders(table, tableHead, extraPagesCols, colCount);
                this.addRows(table, extraPagesCols);
                this.getDocumentContext().getDocument().add((Element)table);
            }
            catch (LocalizationHelper.LocalizationHelperException | DocumentException e) {
                throw new FormRendererException("can't print additional table rows on extra page", e);
            }
        }
    }

    private boolean isPrintable(int printMode) {
        switch (printMode) {
            case 2: 
            case 4: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    private void addRows(@Nonnull PdfPTable table, @Nonnull List<ExpertDisplayInfoDTO.TableDTO.ColumnDTO> extraPagesCols) {
        List extraPagesPrintRows = this.item.getPrintRows().subList(this.rowNo, this.item.getPrintRows().size());
        for (ExpertDisplayInfoDTO.TableDTO.RowDTO row : extraPagesPrintRows) {
            int colNo = 0;
            for (ExpertDisplayInfoDTO.TableDTO.ColumnDTO col : extraPagesCols) {
                if (colNo >= row.getValues().size()) continue;
                this.addCell(table, row, col, colNo++);
            }
        }
    }

    private void addCell(@Nonnull PdfPTable table, @Nonnull ExpertDisplayInfoDTO.TableDTO.RowDTO row, @Nonnull ExpertDisplayInfoDTO.TableDTO.ColumnDTO col, int colNo) {
        ExpertDisplayInfoDTO.TableDTO.CellDTO cellDTO = (ExpertDisplayInfoDTO.TableDTO.CellDTO)row.getValues().get(colNo);
        String text = this.getText(col, cellDTO);
        Translation translation = new Translation(true, text, new Object[0]);
        StyledCell cell = new StyledCell(1, Style.BORDERED_CONTENT_CELL, GeTableAdditionPrinter.itextAlignment((int)col.getAlignment()), translation);
        this.addStyledCell(table, cell);
    }

    private void addColHeaders(@Nonnull PdfPTable table, @Nonnull ExtraPagesTableHead tableHead, @Nonnull List<ExpertDisplayInfoDTO.TableDTO.ColumnDTO> extraPagesCols, int colCount) throws DocumentException {
        float[] colWidths = new float[colCount];
        if (this.item.isHeaderVisible() || tableHead.matchingColCount(colCount)) {
            for (StyledCell cell : tableHead.getCells()) {
                this.addStyledCell(table, cell);
            }
        }
        int i = 0;
        for (ExpertDisplayInfoDTO.TableDTO.ColumnDTO col : extraPagesCols) {
            if (this.item.isHeaderVisible()) {
                Translation colTitle = new Translation(col.getTitle() == null ? EMPTY_LABEL : col.getTitle(), new Object[0]);
                StyledCell cell = new StyledCell(1, Style.LIGHT_GRAY_COL_HEADER, GeTableAdditionPrinter.itextAlignment((int)col.getAlignment()), colTitle);
                this.addStyledCell(table, cell);
            }
            colWidths[i++] = (float)col.getWidth() / (float)this.item.getWidth();
        }
        table.setWidths(colWidths);
    }

    private void addTitles(@Nonnull ExtraPagesTableHead tableHead) throws DocumentException {
        if (this.item.isHeaderVisible() && tableHead.isTitleVisible()) {
            float[] titleRowColWidths = new float[]{1.0f, 15.0f};
            PdfPTable titleRows = PDFTableHelper.getPdfPTable(titleRowColWidths, 0, true);
            Translation tableName = new Translation(this.item.getTitle(), new Object[0]);
            this.addStyledCell(titleRows, new StyledCell(1));
            this.addStyledCell(titleRows, new StyledCell(1, Style.MAIN_TITLE, 0, tableName));
            this.addStyledCell(titleRows, new StyledCell(1, Style.SUBTITLE, 0, new Translation(tableHead.getCodeKey(), new Object[0])));
            this.addStyledCell(titleRows, new StyledCell(1, Style.SUBTITLE, 0, new Translation(SUBTITLE_LABEL_KEY, this.getMessage(tableName.getText(), new Object[0]))));
            this.getDocumentContext().getDocument().add((Element)titleRows);
        }
    }

    @Nonnull
    private String getMessage(@Nonnull String labelKey, Object ... replacementArguments) {
        assert (labelKey != null);
        try {
            return this.getGlobalConverterContext().getLocalizationHelper().translate(labelKey, replacementArguments);
        }
        catch (LocalizationHelper.LocalizationHelperException e) {
            throw new InternalFailureException("Failed to translate message: " + labelKey);
        }
    }

    private void addStyledCell(@Nullable PdfPTable table, @Nonnull StyledCell cell) {
        if (table == null) {
            throw new NullPointerException("table must not be null");
        }
        Style style = cell.getStyle();
        Font font = new Font(1, (float)style.getFontSize(), style.isFontBold() ? 1 : 0, style.getFontColor());
        Translation translation = cell.getTranslation();
        String text = translation.getText();
        if (!translation.isTranslated()) {
            text = this.getMessage(text, translation.getReplacementArguments());
        }
        PdfPCell pdfCell = new PdfPCell((Phrase)new Paragraph(text, font));
        pdfCell.setPaddingTop((float)style.getPaddingTop());
        pdfCell.setPaddingRight(3.0f);
        pdfCell.setPaddingBottom((float)style.getPaddingBottom());
        pdfCell.setPaddingLeft(3.0f);
        pdfCell.setBorder(style.getBorderType());
        pdfCell.setBorderWidth(0.1f);
        pdfCell.setBorderColor(style.getBorderColor());
        pdfCell.setHorizontalAlignment(cell.getHorizontalAlignment());
        pdfCell.setVerticalAlignment(6);
        pdfCell.setBackgroundColor(style.getBackgroundColor());
        if (cell.getColspan() > 0) {
            pdfCell.setColspan(cell.getColspan());
        }
        table.addCell(pdfCell);
    }

    static {
        STYLED_TABLES.put("Revenu.RentesPensions.PensionsAlimentaires", new ExtraPagesTableHead("code.Revenu.RentesPensions.PensionsAlimentaires").defineCell(4).defineCell(1, Style.NORMAL_COL_HEADER, "print.extrapage.icc.et.ifd").defineCell(3, Style.DARK_GRAY_COL_HEADER, "print.extrapage.debiteur.pension").defineCell(1).defineCell(1, Style.BLACK_COL_HEADER, "print.extrapage.1et2revenu"));
        STYLED_TABLES.put("Revenu.RentesViageres.RentesViageres", new ExtraPagesTableHead("code.Revenu.RentesViageres.RentesViageres").defineCell(7).defineCell(1, Style.NORMAL_COL_HEADER, "print.extrapage.icc").defineCell(1, Style.NORMAL_COL_HEADER, "print.extrapage.icc.et.ifd").defineCell(4, Style.DARK_GRAY_COL_HEADER, "print.extrapage.debiteur.rente").defineCell(3).defineCell(1, Style.BLACK_COL_HEADER, "print.extrapage.3fortune").defineCell(1, Style.BLACK_COL_HEADER, "print.extrapage.1et2revenu"));
        STYLED_TABLES.put("Deductions.AssurancesVie.AssurancesVie", new ExtraPagesTableHead("code.Deductions.AssurancesVie.AssurancesVie").defineCell(5).defineCell(1, Style.NORMAL_COL_HEADER, "print.extrapage.icc").defineCell(1, Style.NORMAL_COL_HEADER, "print.extrapage.icc.et.ifd").defineCell(5).defineCell(1, Style.BLACK_COL_HEADER, "print.extrapage.3fortune").defineCell(1, Style.BLACK_COL_HEADER, "print.extrapage.1et2revenu"));
        STYLED_TABLES.put("Deductions.RentesViageres.RentesViageres", new ExtraPagesTableHead("code.Deductions.RentesViageres.RentesViageres").defineCell(7).defineCell(1, Style.NORMAL_COL_HEADER, "print.extrapage.icc.et.ifd").defineCell(4, Style.DARK_GRAY_COL_HEADER, "print.extrapage.beneficiaire").defineCell(3).defineCell(1, Style.BLACK_COL_HEADER, "print.extrapage.1et2revenu"));
        STYLED_TABLES.put("Deductions.Pensions.Pensions", new ExtraPagesTableHead("code.Deductions.Pensions.Pensions").defineCell(6).defineCell(1, Style.NORMAL_COL_HEADER, "print.extrapage.icc.et.ifd").defineCell(4, Style.DARK_GRAY_COL_HEADER, "print.extrapage.beneficiaire").defineCell(2).defineCell(1, Style.BLACK_COL_HEADER, "print.extrapage.1et2revenu"));
        STYLED_TABLES.put("Dettes.DettesChirographaires.DettesChirographaires", new ExtraPagesTableHead("code.Dettes.DettesChirographaires.DettesChirographaires").defineCell(7).defineCell(1, Style.NORMAL_COL_HEADER, "print.extrapage.icc.et.ifd").defineCell(1, Style.NORMAL_COL_HEADER, "print.extrapage.icc").defineCell(2, Style.DARK_GRAY_COL_HEADER, "print.extrapage.creancier").defineCell(2).defineCell(3, Style.DARK_GRAY_COL_HEADER, "print.extrapage.quotePart.pourcent").defineCell(1, Style.BLACK_COL_HEADER, "print.extrapage.1et2revenu").defineCell(1, Style.BLACK_COL_HEADER, "print.extrapage.3fortune"));
        STYLED_TABLES.put("Dettes.DettesHypothecaires.DettesHypothecaires", new ExtraPagesTableHead("code.Dettes.DettesHypothecaires.DettesHypothecaires").defineCell(6).defineCell(1, Style.NORMAL_COL_HEADER, "print.extrapage.icc.et.ifd").defineCell(1, Style.NORMAL_COL_HEADER, "print.extrapage.icc").defineCell(2, Style.DARK_GRAY_COL_HEADER, "print.extrapage.creancier").defineCell(1).defineCell(3, Style.DARK_GRAY_COL_HEADER, "print.extrapage.quotePart.pourcent").defineCell(1, Style.BLACK_COL_HEADER, "print.extrapage.1et2revenu").defineCell(1, Style.BLACK_COL_HEADER, "print.extrapage.3fortune"));
        STYLED_TABLES.put("Dettes.DettesEpargnes.DettesEpargnes", new ExtraPagesTableHead("code.Dettes.DettesEpargnes.DettesEpargnes").defineCell(6).defineCell(1, Style.NORMAL_COL_HEADER, "print.extrapage.icc.et.ifd").defineCell(1, Style.NORMAL_COL_HEADER, "print.extrapage.icc").defineCell(2, Style.DARK_GRAY_COL_HEADER, "print.extrapage.creancier").defineCell(1).defineCell(3, Style.DARK_GRAY_COL_HEADER, "print.extrapage.quotePart.pourcent").defineCell(1, Style.BLACK_COL_HEADER, "print.extrapage.1et2revenu").defineCell(1, Style.BLACK_COL_HEADER, "print.extrapage.3fortune"));
        STYLED_TABLES.put("Dettes.DettesHLM.DettesHLM", new ExtraPagesTableHead("code.Dettes.DettesHLM.DettesHLM").defineCell(6).defineCell(1, Style.NORMAL_COL_HEADER, "print.extrapage.icc.et.ifd").defineCell(1, Style.NORMAL_COL_HEADER, "print.extrapage.icc").defineCell(2, Style.DARK_GRAY_COL_HEADER, "print.extrapage.creancier").defineCell(1).defineCell(3, Style.DARK_GRAY_COL_HEADER, "print.extrapage.quotePart.pourcent").defineCell(1, Style.BLACK_COL_HEADER, "print.extrapage.1et2revenu").defineCell(1, Style.BLACK_COL_HEADER, "print.extrapage.3fortune"));
    }

    private static class ExtraPagesTableHead {
        private int colCount = 0;
        private final boolean titleVisible;
        @Nonnull
        private final String codeKey;
        @Nonnull
        private final List<StyledCell> cells = new ArrayList<StyledCell>();

        public ExtraPagesTableHead() {
            this.codeKey = GeTableAdditionPrinter.EMPTY_LABEL;
            this.titleVisible = false;
        }

        public ExtraPagesTableHead(@Nonnull String codeKey) {
            this.codeKey = codeKey;
            this.titleVisible = true;
        }

        @Nonnull
        public ExtraPagesTableHead defineCell(int colspan) {
            this.addCell(new StyledCell(colspan));
            return this;
        }

        @Nonnull
        public ExtraPagesTableHead defineCell(int colspan, @Nonnull Style style, @Nonnull String labelKey) {
            this.addCell(new StyledCell(colspan, style, labelKey));
            return this;
        }

        private void addCell(@Nonnull StyledCell cell) {
            this.cells.add(cell);
            this.colCount += cell.getColspan();
        }

        public boolean isTitleVisible() {
            return this.titleVisible;
        }

        @Nonnull
        public List<StyledCell> getCells() {
            return this.cells;
        }

        @Nonnull
        public String getCodeKey() {
            return this.codeKey;
        }

        public boolean matchingColCount(int tableColCount) {
            int modulo = this.colCount % tableColCount;
            if (modulo != 0) {
                throw new IllegalArgumentException("tableHead.colCount (" + this.colCount + ") must be equal or a multiple of table.colCount (" + tableColCount + ")");
            }
            return true;
        }
    }

    private static class Translation {
        private final boolean isTranslated;
        @Nonnull
        private final String text;
        @Nullable
        private final Object[] replacementArguments;

        public Translation(@Nonnull String text, Object ... replacementArguments) {
            assert (text != null) : "translation cannot be null";
            this.isTranslated = false;
            this.text = text;
            this.replacementArguments = replacementArguments;
        }

        public Translation(boolean isTranslated, @Nullable String text, Object ... replacementArguments) {
            if (StringUtils.isEmpty((CharSequence)text)) {
                this.isTranslated = false;
                this.text = GeTableAdditionPrinter.EMPTY_LABEL;
                this.replacementArguments = null;
            } else {
                this.isTranslated = isTranslated;
                this.text = text;
                this.replacementArguments = replacementArguments;
            }
        }

        public boolean isTranslated() {
            return this.isTranslated;
        }

        @Nonnull
        public String getText() {
            return this.text;
        }

        @Nullable
        public Object[] getReplacementArguments() {
            return this.replacementArguments;
        }
    }

    private static class StyledCell {
        private final int colspan;
        @Nonnull
        private final Style style;
        private final int horizontalAlignment;
        @Nonnull
        private final Translation translation;

        public StyledCell(int colspan) {
            this(colspan, Style.NORMAL_COL_HEADER, 0, new Translation(GeTableAdditionPrinter.EMPTY_LABEL, new Object[0]));
        }

        public StyledCell(int colspan, @Nonnull Style style, @Nonnull String labelKey) {
            this(colspan, style, 1, new Translation(labelKey, new Object[0]));
        }

        public StyledCell(int colspan, @Nonnull Style style, int horizontalAlignment, @Nonnull Translation translation) {
            assert (colspan > 0) : "colspan must be greater than zero";
            this.colspan = colspan;
            this.horizontalAlignment = horizontalAlignment;
            this.style = style;
            this.translation = translation;
        }

        public int getColspan() {
            return this.colspan;
        }

        @Nonnull
        public Style getStyle() {
            return this.style;
        }

        public int getHorizontalAlignment() {
            return this.horizontalAlignment;
        }

        @Nonnull
        public Translation getTranslation() {
            return this.translation;
        }
    }

    private static enum Style {
        MAIN_TITLE(12, true, Color.BLACK, null, Color.BLACK, 0, 3, 3),
        SUBTITLE(6, false, Color.BLACK, null, Color.BLACK, 0, 3, 3),
        BORDERED_CONTENT_CELL(6, false, Color.BLACK, null, Color.BLACK, 15, 5, 7),
        NORMAL_COL_HEADER(8, true, Color.BLACK, null, Color.BLACK, 0, 3, 3),
        BLACK_COL_HEADER(6, true, Color.WHITE, Color.BLACK, Color.WHITE, 15, 10, 3),
        DARK_GRAY_COL_HEADER(6, true, Color.BLACK, DARK_GRAY, Color.WHITE, 15, 3, 3),
        LIGHT_GRAY_COL_HEADER(6, true, Color.BLACK, LIGHT_GRAY, Color.WHITE, 12, 3, 3);

        private final int fontSize;
        private final boolean fontBold;
        @Nonnull
        private final Color fontColor;
        @Nullable
        private final Color backgroundColor;
        @Nonnull
        private final Color borderColor;
        private final int borderType;
        private final int paddingTop;
        private final int paddingBottom;

        private Style(@Nonnull int fontSize, @Nullable boolean fontBold, @Nonnull Color fontColor, Color backgroundColor, Color borderColor, int borderType, int paddingTop, int paddingBottom) {
            this.fontSize = fontSize;
            this.fontBold = fontBold;
            this.fontColor = fontColor;
            this.backgroundColor = backgroundColor;
            this.borderColor = borderColor;
            this.borderType = borderType;
            this.paddingTop = paddingTop;
            this.paddingBottom = paddingBottom;
        }

        public int getFontSize() {
            return this.fontSize;
        }

        public boolean isFontBold() {
            return this.fontBold;
        }

        @Nonnull
        public Color getFontColor() {
            return this.fontColor;
        }

        @Nullable
        public Color getBackgroundColor() {
            return this.backgroundColor;
        }

        @Nonnull
        public Color getBorderColor() {
            return this.borderColor;
        }

        public int getBorderType() {
            return this.borderType;
        }

        public int getPaddingTop() {
            return this.paddingTop;
        }

        public int getPaddingBottom() {
            return this.paddingBottom;
        }
    }
}

