/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.engine.modelitems.repartition.intercommunale;

import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.intercommunale.CentimesAdditionnelsPartPrivilegieeItem;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.intercommunale.results.RepartitionIntercommunaleResults;
import ch.dvbern.tax.ge.pp.engine.modelitems.PPLogicModelItem;
import ch.dvbern.tax.ge.pp.transfer.dto.CommuneDTO;
import ch.dvbern.tax.ge.pp.utils.CommuneOuCantonComparator;
import ch.dvbern.tax.ge.pp.utils.DataModelUtil;
import ch.dvbern.tax.ge.pp.utils.ResourceEnum;
import ch.dvbern.tax.ge.pp.utils.SharedUtils;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

public class RepartitionIntercommunaleRecapitulationItem
extends PPLogicModelItem {
    private static final String ROW_PREFIX = "label.recapitulation.repartition.montantImpot.";
    private static final Long COMMUNE_PAR_DEFAUT_PART_PRIV = 6621L;
    private final DataResource dataResource;
    private final Reference communes;
    private final Reference partPriviligiees;
    private final Reference revenusImposables;
    private final Reference fortunesImposables;
    private final Reference impotsCantonauxRevenus;
    private final Reference impotsCantonauxFortunes;
    private final Reference impotsCommunauxTaux;
    private final Reference impotsCommunauxMontants;

    public RepartitionIntercommunaleRecapitulationItem(String name, Reference sourceItems, Reference table, Reference communes, Reference partPriviligiees, Reference revenusImposables, Reference fortunesImposables, Reference impotsCantonauxRevenus, Reference impotsCantonauxFortunes, Reference impotsCommunauxTaux, Reference impotsCommunauxMontants, DataResource dataResource) {
        super(name, sourceItems, table);
        this.dataResource = dataResource;
        this.communes = communes;
        this.partPriviligiees = partPriviligiees;
        this.revenusImposables = revenusImposables;
        this.fortunesImposables = fortunesImposables;
        this.impotsCantonauxRevenus = impotsCantonauxRevenus;
        this.impotsCantonauxFortunes = impotsCantonauxFortunes;
        this.impotsCommunauxTaux = impotsCommunauxTaux;
        this.impotsCommunauxMontants = impotsCommunauxMontants;
    }

    private static double getPart(double totalPart, boolean hasNext, double totalImposableCommune, double montant) {
        double part = hasNext ? (totalImposableCommune != 0.0 && montant > 0.0 ? montant / totalImposableCommune : 0.0) : 1.0 - totalPart;
        return part;
    }

    @Override
    protected void additionalInitializeReferences(Map<String, LogicModelItem> logicModel) throws InvalidModelException {
        super.additionalInitializeReferences(logicModel);
        this.communes.initializeReference(logicModel, (LogicModelItem)this, true);
        this.partPriviligiees.initializeReference(logicModel, (LogicModelItem)this, true);
        this.revenusImposables.initializeReference(logicModel, (LogicModelItem)this, true);
        this.fortunesImposables.initializeReference(logicModel, (LogicModelItem)this, true);
        this.impotsCantonauxRevenus.initializeReference(logicModel, (LogicModelItem)this, true);
        this.impotsCantonauxFortunes.initializeReference(logicModel, (LogicModelItem)this, true);
        this.impotsCommunauxTaux.initializeReference(logicModel, (LogicModelItem)this, true);
        this.impotsCommunauxMontants.initializeReference(logicModel, (LogicModelItem)this, true);
    }

    public void dataChanged(LogicModelItem.ProtectedMap dataModel, String dataModelKey, ModelItemDTO oldValue, ModelItemDTO newValue, String changedEventsOnlyOutsideOfThisTable) {
        super.dataChanged(dataModel, dataModelKey, oldValue, newValue, changedEventsOnlyOutsideOfThisTable);
        RepartitionIntercommunaleResults results = new RepartitionIntercommunaleResults(dataModel, true);
        Map<Object, Long> fortuneColumns = results.getRecapitulationFortuneColumns();
        Map<Object, Long> revenuColumns = results.getRecapitulationRevenuColumns();
        long revenuTotalImposable = results.getRevenuTotalImposable();
        long fortuneTotalImposable = results.getFortuneTotalImposableGeneve();
        if (fortuneColumns == null || revenuColumns == null) {
            return;
        }
        DataModelUtil dataModelUtil = new DataModelUtil(dataModel);
        double impotDeBaseFortune = dataModelUtil.getDouble("Recapitulation.CalculImpot.ImpotDeBaseSurFortune");
        double impotDeBaseRevenu = dataModelUtil.getDouble("Recapitulation.CalculImpot.ImpotDeBaseSurRevenu");
        Map optionMap = this.dataResource.get(ResourceEnum.CENTIMES_ADDITIONNELS.code(), null, null);
        Map communesGeneve = this.dataResource.get(ResourceEnum.COMMUNES_PAR_CANTON.code(), (Object)"GE", null);
        Long communeTaxation = COMMUNE_PAR_DEFAUT_PART_PRIV;
        Long communeTaxationTmp = null;
        if (dataModel.get((Object)"Stammdaten.CommuneTaxationEffective") != null && dataModel.get((Object)"Stammdaten.CommuneTaxationEffective").getValue() != null && optionMap.containsKey(communeTaxationTmp = Long.valueOf(dataModel.get((Object)"Stammdaten.CommuneTaxationEffective").getValue().toString()))) {
            communeTaxation = communeTaxationTmp;
        }
        String nomCommuneTaxation = ((CommuneDTO)((Object)communesGeneve.get(communeTaxation.toString()))).getNom();
        CentimesAdditionnelsPartPrivilegieeItem partPrivilegieeItem = (CentimesAdditionnelsPartPrivilegieeItem)optionMap.get(communeTaxation);
        double centimesAdditionnels = partPrivilegieeItem.getCentimesAdditionnels();
        double partPrivilegiee = partPrivilegieeItem.getPartPrivilegiee();
        double partPrivilegieeFortune = partPrivilegiee * impotDeBaseFortune;
        double partPrivilegieeRevenu = partPrivilegiee * impotDeBaseRevenu;
        double partPrivilegieeImpotCommunal = centimesAdditionnels * (partPrivilegieeFortune + partPrivilegieeRevenu);
        if (!dataModelUtil.getBoolean("Stammdaten.Declaration.QuasiResident") && !dataModelUtil.getBoolean("Stammdaten.Declaration.PPHCsuisse")) {
            this.addRow(dataModel, 0, nomCommuneTaxation, partPrivilegieeItem.getPartPrivilegieeLabel(), partPrivilegieeItem.getCentimesAdditionnelsLabel(), 0L, 0L, partPrivilegieeRevenu, partPrivilegieeFortune, partPrivilegieeImpotCommunal);
        } else {
            partPrivilegieeRevenu = 0.0;
            partPrivilegieeFortune = 0.0;
            partPrivilegieeImpotCommunal = 0.0;
        }
        double total = this.buildAutresPartsEtTotaux(dataModel, communesGeneve, revenuColumns, fortuneColumns, impotDeBaseRevenu, impotDeBaseFortune, communeTaxation.toString(), partPrivilegieeRevenu, partPrivilegieeFortune, partPrivilegieeImpotCommunal, optionMap, revenuTotalImposable, fortuneTotalImposable);
        total = (double)((int)(total / 0.05)) * 0.05;
        this.setValue(dataModel, "Recapitulation.CalculImpot.ImpotsCommunaux", new ModelItemDTO((Object)total), "true");
    }

    private double buildAutresPartsEtTotaux(LogicModelItem.ProtectedMap dataModel, Map<String, CommuneDTO> communesGeneve, Map<Object, Long> revenuColumns, Map<Object, Long> fortuneColumns, double impotDeBaseRevenu, double impotDeBaseFortune, String communeTaxation, double partPrivilegieeRevenu, double partPrivilegieeFortune, double partPrivilegieeImpotCommunal, Map<Long, CentimesAdditionnelsPartPrivilegieeItem> optionMap, long revenuTotalImposable, long fortuneTotalImposable) {
        double revenuPourRepartition = impotDeBaseRevenu - partPrivilegieeRevenu;
        double fortunePourRepartition = impotDeBaseFortune - partPrivilegieeFortune;
        TreeSet<Object> communesDisponibles = new TreeSet<Object>(new CommuneOuCantonComparator(communeTaxation, null));
        communesDisponibles.addAll(fortuneColumns.keySet());
        communesDisponibles.addAll(revenuColumns.keySet());
        communesDisponibles.remove("EX");
        long revenuTotalImposableCommunes = 0L;
        long fortuneTotalImposableCommunes = 0L;
        for (String string : communesDisponibles) {
            revenuTotalImposableCommunes += revenuColumns.containsKey(string) ? revenuColumns.get(string) : 0L;
            fortuneTotalImposableCommunes += fortuneColumns.containsKey(string) ? fortuneColumns.get(string) : 0L;
        }
        Iterator itr = communesDisponibles.iterator();
        double d = partPrivilegieeRevenu;
        double impotCantonalFortuneTotal = partPrivilegieeFortune;
        double impotCommunalTotal = partPrivilegieeImpotCommunal;
        int rowIndex = 1;
        double totalPartRevenu = 0.0;
        double totalPartFortune = 0.0;
        while (itr.hasNext()) {
            String commune = (String)itr.next();
            CommuneDTO communeDTO = communesGeneve.get(commune);
            if (communeDTO == null) continue;
            String nomCommune = communeDTO.getNom();
            long revenuImposableCommune = revenuColumns.containsKey(commune) ? revenuColumns.get(commune) : 0L;
            long fortuneImposableCommune = fortuneColumns.containsKey(commune) ? fortuneColumns.get(commune) : 0L;
            CentimesAdditionnelsPartPrivilegieeItem centimesAdditionnelsItem = optionMap.get(Long.valueOf(commune));
            double centimesAdditionnels = centimesAdditionnelsItem.getCentimesAdditionnels();
            double partRevenu = RepartitionIntercommunaleRecapitulationItem.getPart(totalPartRevenu, itr.hasNext(), revenuTotalImposableCommunes, revenuImposableCommune);
            totalPartRevenu += partRevenu;
            double partFortune = RepartitionIntercommunaleRecapitulationItem.getPart(totalPartFortune, itr.hasNext(), fortuneTotalImposableCommunes, fortuneImposableCommune);
            totalPartFortune += partFortune;
            double impotCantonalRevenu = partRevenu * revenuPourRepartition;
            double impotCantonalFortune = partFortune * fortunePourRepartition;
            double impotCommunal = centimesAdditionnels * (impotCantonalRevenu + impotCantonalFortune);
            d += impotCantonalRevenu;
            impotCantonalFortuneTotal += impotCantonalFortune;
            impotCommunalTotal += impotCommunal;
            this.addRow(dataModel, rowIndex, nomCommune, "", centimesAdditionnelsItem.getCentimesAdditionnelsLabel(), revenuImposableCommune, fortuneImposableCommune, impotCantonalRevenu, impotCantonalFortune, impotCommunal);
            ++rowIndex;
        }
        this.addRowTotal(dataModel, rowIndex++, revenuTotalImposable, fortuneTotalImposable);
        this.addRowImpot(dataModel, rowIndex, d, impotCantonalFortuneTotal, impotCommunalTotal);
        return impotCommunalTotal;
    }

    private void addRow(LogicModelItem.ProtectedMap dataModel, int rowIndex, String communeTaxation, String partPrivilegieeLabel, String centimesAdditionnelsLabel, long revenuImposable, long fortuneImposable, double impotCantonalRevenu, double impotCantonalFortune, double impotCommunalMontant) {
        this.createTableCell(this.communes, dataModel, rowIndex, communeTaxation);
        this.createTableCell(this.partPriviligiees, dataModel, rowIndex, partPrivilegieeLabel);
        this.createTableCell(this.revenusImposables, dataModel, rowIndex, revenuImposable);
        this.createTableCell(this.fortunesImposables, dataModel, rowIndex, fortuneImposable);
        this.createTableCell(this.impotsCantonauxRevenus, dataModel, rowIndex, impotCantonalRevenu);
        this.createTableCell(this.impotsCantonauxFortunes, dataModel, rowIndex, impotCantonalFortune);
        this.createTableCell(this.impotsCommunauxTaux, dataModel, rowIndex, centimesAdditionnelsLabel);
        this.createTableCell(this.impotsCommunauxMontants, dataModel, rowIndex, impotCommunalMontant);
    }

    private void addRowTotal(LogicModelItem.ProtectedMap dataModel, int rowIndex, long revenuImposable, long fortuneImposable) {
        this.createTableCell(this.communes, dataModel, rowIndex, SharedUtils.translate("label.recapitulation.repartition.montantImpot.total", new Object[0]));
        this.createTableCell(this.partPriviligiees, dataModel, rowIndex, "");
        this.createTableCell(this.revenusImposables, dataModel, rowIndex, revenuImposable);
        this.createTableCell(this.fortunesImposables, dataModel, rowIndex, fortuneImposable);
        this.createTableCell(this.impotsCantonauxRevenus, dataModel, rowIndex, "");
        this.createTableCell(this.impotsCantonauxFortunes, dataModel, rowIndex, "");
        this.createTableCell(this.impotsCommunauxTaux, dataModel, rowIndex, "");
        this.createTableCell(this.impotsCommunauxMontants, dataModel, rowIndex, "");
    }

    private void addRowImpot(LogicModelItem.ProtectedMap dataModel, int rowIndex, double impotCantonalRevenu, double impotCantonalFortune, double impotCommunalMontant) {
        this.createTableCell(this.communes, dataModel, rowIndex, SharedUtils.translate("label.recapitulation.repartition.montantImpot.impot", new Object[0]));
        this.createTableCell(this.partPriviligiees, dataModel, rowIndex, "");
        this.createTableCell(this.revenusImposables, dataModel, rowIndex, "");
        this.createTableCell(this.fortunesImposables, dataModel, rowIndex, "");
        this.createTableCell(this.impotsCantonauxRevenus, dataModel, rowIndex, impotCantonalRevenu);
        this.createTableCell(this.impotsCantonauxFortunes, dataModel, rowIndex, impotCantonalFortune);
        this.createTableCell(this.impotsCommunauxTaux, dataModel, rowIndex, "");
        this.createTableCell(this.impotsCommunauxMontants, dataModel, rowIndex, impotCommunalMontant);
    }
}

