/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.engine.modelitems.repartition;

import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.calcitems.RelRef;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.RepartitionCalcul;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.table.RepartitionColumn;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.table.RepartitionTable;
import ch.dvbern.tax.ge.pp.engine.modelitems.PPLogicModelItem;
import ch.dvbern.tax.ge.pp.utils.RepartitionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RepartitionItem
extends PPLogicModelItem {
    private static final Logger LOG = LoggerFactory.getLogger(RepartitionItem.class);
    protected final Reference code;
    protected final Reference libelle;
    protected final Reference civilite;
    protected final Reference admis;
    protected final Map<String, Reference> columns = new HashMap<String, Reference>();
    public static final String KEY_COLUMN_PART = "Part";
    public static final String KEY_GE = "GE";
    public static final String KEY_EX = "EX";

    public RepartitionItem(String name, Reference sourceItems, Reference table, Reference code, Reference libelle, Reference civilite, Reference admis, DataResource dataResource, String listname, String listnameParam) {
        super(name, sourceItems, table);
        this.code = code;
        this.libelle = libelle;
        this.civilite = civilite;
        this.admis = admis;
        this.setDataResource(dataResource);
        Map<String, Object> repartitionItems = RepartitionUtil.getRepartitionItemsAsLogicModelNames(dataResource, listname, listnameParam, null);
        for (Map.Entry<String, Object> entry : repartitionItems.entrySet()) {
            Object nom = entry.getKey();
            Object value = entry.getValue();
            nom = table.getName() + "." + (String)nom;
            RelRef ref = new RelRef((String)nom);
            RelRef refPart = new RelRef((String)nom + KEY_COLUMN_PART);
            this.columns.put(String.valueOf(value), (Reference)ref);
            this.columns.put(String.valueOf(value) + KEY_COLUMN_PART, (Reference)refPart);
        }
    }

    @Override
    protected void additionalInitializeReferences(Map<String, LogicModelItem> logicModel) throws InvalidModelException {
        super.additionalInitializeReferences(logicModel);
        this.code.initializeReference(logicModel, (LogicModelItem)this, true);
        this.libelle.initializeReference(logicModel, (LogicModelItem)this, true);
        this.civilite.initializeReference(logicModel, (LogicModelItem)this, true);
        this.admis.initializeReference(logicModel, (LogicModelItem)this, true);
        Enumeration<String> strEnum = Collections.enumeration(this.columns.keySet());
        while (strEnum.hasMoreElements()) {
            this.columns.get(strEnum.nextElement()).initializeReference(logicModel, (LogicModelItem)this, true);
        }
    }

    public void dataChanged(LogicModelItem.ProtectedMap dataModel, String dataModelKey, ModelItemDTO oldValue, ModelItemDTO newValue, String changedEventsOnlyOutsideOfThisTable) {
        this.resetAndClearTable(dataModel);
        try {
            RepartitionCalcul repartition = this.getRepartitionCalcul(dataModel, this.getDataResource());
            RepartitionTable tableRepartition = repartition.compute();
            if (tableRepartition.getCountRows() >= 0) {
                for (int i = 0; i <= tableRepartition.getCountRows(); ++i) {
                    this.createTableCell(this.code, dataModel, i + 90000, tableRepartition.getColumnCode().get(i));
                    this.createTableCell(this.libelle, dataModel, i + 90000, tableRepartition.getColumnLibelle().get(i));
                    this.createTableCell(this.civilite, dataModel, i + 90000, tableRepartition.getColumnCivilite().get(i));
                    Object admisObj = tableRepartition.getColumnAdmis().get(i);
                    long admisVal = admisObj != null ? Long.valueOf((String)admisObj) : 0L;
                    this.createTableCell(this.admis, dataModel, i + 90000, admisVal);
                }
                this.initFirstRows(dataModel);
                this.fillCellsRepartition(dataModel, tableRepartition.getRepartition(), "");
                this.fillCellsRepartition(dataModel, tableRepartition.getRepartitionPart(), KEY_COLUMN_PART);
                repartition.getResults().saveInstance(this);
            }
        }
        catch (Exception e) {
            LOG.error("Exception encountered while computing repartitions", (Throwable)e);
        }
    }

    private void initFirstRows(LogicModelItem.ProtectedMap dataModel) {
        Enumeration<String> strEnum = Collections.enumeration(this.columns.keySet());
        while (strEnum.hasMoreElements()) {
            String key = strEnum.nextElement();
            if (key.contains(KEY_COLUMN_PART)) continue;
            this.createTableCell(this.columns.get(key), dataModel, 90000, "");
        }
    }

    protected abstract RepartitionCalcul getRepartitionCalcul(LogicModelItem.ProtectedMap var1, DataResource var2);

    private void fillCellsRepartition(LogicModelItem.ProtectedMap dataModel, Map<String, RepartitionColumn> repartition, String keyPart) {
        ArrayList<String> sortedKeys = new ArrayList<String>(repartition.keySet());
        Collections.sort(sortedKeys);
        for (String canton : sortedKeys) {
            RepartitionColumn column = repartition.get(canton);
            for (Integer element2 : column.getRows().keySet()) {
                int rowIndex = element2;
                if (!this.columns.containsKey(canton)) continue;
                this.createTableCell(this.columns.get(canton + keyPart), dataModel, rowIndex + 90000, column.getRows().get(element2));
            }
        }
    }
}

