/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.engine.modelitems;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.util.DataModelUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.ge.pp.engine.modelitems.TableAccumulator;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class RevisedTableSum
extends TableAccumulator<SumResult> {
    public RevisedTableSum(String name, String persistenceKeyTemplate, Reference itemRef, Reference stateRef) {
        super(name, persistenceKeyTemplate, itemRef, stateRef);
    }

    @Override
    @Nonnull
    protected SumResult newAccumulator() {
        return new SumResult();
    }

    @Override
    protected void processEntry(Map<String, ModelItemDTO> dataModel, String dataModelKey, SumResult accumulator) {
        BigDecimal toAdd;
        Number number = (Number)DataModelUtil.getValue(dataModel, Number.class, (String)dataModelKey);
        if (number == null) {
            return;
        }
        boolean asDouble = false;
        if (number instanceof BigDecimal) {
            asDouble = true;
            toAdd = (BigDecimal)number;
        } else if (number instanceof BigInteger) {
            toAdd = new BigDecimal((BigInteger)number);
        } else if (number instanceof Double) {
            asDouble = true;
            toAdd = BigDecimal.valueOf((Double)number);
        } else {
            toAdd = BigDecimal.valueOf(number.longValue());
        }
        accumulator.asDouble |= asDouble;
        accumulator.total = accumulator.total.add(toAdd);
    }

    @Override
    @Nonnull
    protected Object postProcess(SumResult accumulator) {
        return accumulator.asDouble ? accumulator.total.doubleValue() : (double)accumulator.total.longValue();
    }

    class SumResult {
        private BigDecimal total = BigDecimal.ZERO;
        private boolean asDouble = false;

        SumResult() {
        }
    }

    public static class XMLFactory
    implements ElementParser {
        @Nonnull
        public ClassObjectPair parse(@Nonnull Element element, @Nonnull ParserFactory factory) throws ElementParserException {
            ArrayList<Validator> validators = new ArrayList<Validator>();
            List elements = element.getChildren();
            for (Element subElement : elements) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair classObjectPair = parser.parse(subElement, factory);
                    Object ref = classObjectPair.getObject();
                    if (ref instanceof Validator) {
                        validators.add((Validator)ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            String stateLmk = element.getAttributeValue("state");
            Reference stateRef = stateLmk != null ? new Reference(stateLmk, true) : null;
            RevisedTableSum result = new RevisedTableSum(element.getAttributeValue("name"), element.getAttributeValue("pKey"), new Reference(element.getAttributeValue("ref"), true), stateRef);
            for (Object e : validators) {
                result.addValidator((Validator)e);
            }
            return new ClassObjectPair(RevisedTableSum.class, (Object)result);
        }
    }
}

