/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.engine.modelitems;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.modelitems.Table;
import ch.dvbern.tax.common.engine.modelitems.Value;
import ch.dvbern.tax.ge.pp.utils.RepartitionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class RepartitionTable
extends Table {
    public RepartitionTable(String name, List<LogicModelItem> children, String persistenceKeyTemplate, boolean readonly, boolean readonlyIfTransparent, String sharedTableNames, boolean barcode, DataResource dataResource) {
        super(name, children, persistenceKeyTemplate, readonly, readonlyIfTransparent, sharedTableNames, barcode);
    }

    public static class XMLFactory
    implements ElementParser {
        @Nonnull
        public ClassObjectPair parse(@Nonnull Element element, @Nonnull ParserFactory factory) throws ElementParserException {
            DataResource dataResource = null;
            List elements = element.getChildren();
            ArrayList<LogicModelItem> childItems = elements.size() > 0 ? new ArrayList<LogicModelItem>() : null;
            ArrayList<Validator> validators = new ArrayList<Validator>();
            for (Element subElement : elements) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof LogicModelItem) {
                        childItems.add((LogicModelItem)ref);
                        continue;
                    }
                    if (ref instanceof Validator) {
                        validators.add((Validator)ref);
                        continue;
                    }
                    if (ref instanceof DataResource) {
                        dataResource = (DataResource)ref;
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            if (dataResource == null) {
                throw new ElementParserException("dataResource must not be null for RepartitionTable ");
            }
            String listname = element.getAttributeValue("list-name");
            if (listname == null) {
                throw new ElementParserException("attribute list-name must not be null for RepartitionTable");
            }
            String listParam = element.getAttributeValue("list-name-param");
            ArrayList<Value> newChildren = new ArrayList<Value>();
            Map<String, Object> repartitionItems = RepartitionUtil.getRepartitionItemsAsLogicModelNames(dataResource, listname, listParam, null);
            for (String nom : repartitionItems.keySet()) {
                Value valueCommune = new Value(nom, null, null, true, "false", true, true, false);
                Value valueCommunePart = new Value(nom + "Part", null, null, true, "false", true, true, false);
                newChildren.add(valueCommune);
                newChildren.add(valueCommunePart);
            }
            childItems.addAll(newChildren);
            RepartitionTable result = new RepartitionTable(element.getAttributeValue("name"), childItems, element.getAttributeValue("pKey"), Boolean.valueOf(element.getAttributeValue("readonly")), Boolean.valueOf(element.getAttributeValue("readonly-if-transparent")), element.getAttributeValue("sharedTables"), Boolean.valueOf(element.getAttributeValue("barcode")), dataResource);
            for (Validator validator : validators) {
                result.addValidator(validator);
            }
            return new ClassObjectPair(RepartitionTable.class, (Object)result);
        }
    }
}

