/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.engine.expertdisplay.items;

import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.ModelChangeListener;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModel;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertFormDisplayModelItem;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.failure.InvalidModelItemKeyException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecalcOnLoadItem
extends ExpertFormDisplayModelItem {
    private static final Logger LOG = LoggerFactory.getLogger(RecalcOnLoadItem.class);
    private final String dmk;

    public RecalcOnLoadItem(String dmk) {
        super(null, 0, false);
        this.dmk = dmk;
    }

    public ExpertDisplayInfoDTO.ItemDTO getItemDTO(ExpertDisplayModel.RequestContext requestContext) throws InvalidModelItemKeyException {
        Object itemObj = requestContext.getLogicModelItems().get(this.dmk);
        if (itemObj == null) {
            LOG.error("Can't recalculate: no such dmk: {}", (Object)this.dmk);
        } else if (!(itemObj instanceof ModelChangeListener)) {
            LOG.error("Can't recalculate: not a valid instance of ModelChangeListener: {}", (Object)this.dmk);
        } else {
            ModelChangeListener item = (ModelChangeListener)itemObj;
            item.dataChanged((LogicModelItem.ProtectedMap)requestContext.getDataModel(), this.dmk, null, null, "false");
        }
        return null;
    }

    public boolean isEnabledForLanguage(Locale lang) {
        return true;
    }

    public boolean isEnabledForMode(int mode) {
        return true;
    }

    public List<? extends ExpertDisplayModelItem> getChildren() {
        return Collections.emptyList();
    }
}

