/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.engine.calcitems;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.DataModelUtil;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Set;

public class CFTitreTransactionPrintLabel
implements CalcItem {
    private static final ThreadLocal<SimpleDateFormat> DATE_FMT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat fmt = new SimpleDateFormat("dd.MM");
            fmt.setTimeZone(ApplicationConfig.TIMEZONE);
            return fmt;
        }
    };

    public void evaluate(LogicModelItem.ProtectedMap dataModel, FastStack stack, String dataModelKey) {
        String tableDMK = EngineUtil.mergeModelKey((String)"Titres.Divers.DiversTable.Titres.TransactionsTable", (String)dataModelKey);
        Set indexes = (Set)DataModelUtil.getValue((Map)dataModel, Set.class, (String)tableDMK);
        Object label = null;
        if (indexes != null && !indexes.isEmpty()) {
            for (String index : indexes) {
                String rowDMK = tableDMK + "." + index;
                Date mutationDate = (Date)DataModelUtil.getValue((Map)dataModel, Date.class, (String)EngineUtil.mergeModelKey((String)"Titres.Divers.DiversTable.Titres.TransactionsTable.Date", (String)rowDMK));
                Double mutationPart = (Double)DataModelUtil.getValue((Map)dataModel, Double.class, (String)EngineUtil.mergeModelKey((String)"Titres.Divers.DiversTable.Titres.TransactionsTable.MutationNombreDeParts", (String)rowDMK));
                if (mutationDate == null || mutationPart == null || mutationPart == 0.0) continue;
                if (label != null) {
                    label = "multiple";
                    break;
                }
                String prefix = mutationPart > 0.0 ? "A" : "V";
                label = prefix + " " + DATE_FMT.get().format(mutationDate);
            }
        }
        stack.push(label);
    }
}

