/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.engine.calcitems;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.engine.util.StackUtil;
import ch.dvbern.tax.ge.pp.transfer.dto.CommuneDTO;
import ch.dvbern.tax.ge.pp.utils.ResourceEnum;
import org.apache.commons.lang3.StringUtils;

public class CFPrintCommuneOrPaysWithCodes
implements CalcItem {
    private final DataResource dataResource;

    public CFPrintCommuneOrPaysWithCodes(DataResource dataResource) {
        this.dataResource = dataResource;
    }

    public void evaluate(LogicModelItem.ProtectedMap model, FastStack stack, String dataModelKey) {
        String result = null;
        int codeCommune = 0;
        Object codeCommuneObject = stack.pop();
        if (codeCommuneObject instanceof Number) {
            codeCommune = ((Number)codeCommuneObject).intValue();
        } else if (codeCommuneObject instanceof String) {
            codeCommune = Integer.parseInt((String)codeCommuneObject);
        }
        String codeCanton = StackUtil.getString((FastStack)stack);
        if (StringUtils.isBlank((CharSequence)codeCanton)) {
            return;
        }
        CommuneDTO communeDTO = (CommuneDTO)((Object)this.dataResource.get(ResourceEnum.COMMUNES_PAR_CANTON.code(), (Object)codeCanton, null).get(String.valueOf(codeCommune)));
        if (communeDTO != null) {
            result = communeDTO.getNom() + " " + communeDTO.getNpa();
            if (!codeCanton.equals("EX")) {
                result = codeCanton + "/" + result;
            }
        }
        stack.push(result);
    }
}

