/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.engine.calcitems;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.engine.util.StackUtil;
import ch.dvbern.tax.ge.pp.utils.GeConstants;
import ch.dvbern.tax.ge.pp.utils.SharedUtils;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Iterator;

public class CFMessage
implements CalcItem {
    public void evaluate(LogicModelItem.ProtectedMap dataModel, FastStack stack, String dataModelKey) {
        if (stack.isEmpty()) {
            throw new IllegalArgumentException("CFMessage needs at least 1 element on stack (the message key to resolve)");
        }
        String key = StackUtil.getString((FastStack)stack);
        Iterator itr = stack.iterator();
        Object[] args = new Object[stack.size()];
        int i = 0;
        while (itr.hasNext()) {
            Object next = itr.next();
            if (next instanceof Long) {
                DecimalFormatSymbols dfs = DecimalFormatSymbols.getInstance(GeConstants.DEFAULT_LOCALE);
                dfs.setGroupingSeparator('\'');
                DecimalFormat df = new DecimalFormat("#,###", dfs);
                String nextLong = df.format(next);
                args[i++] = nextLong;
                continue;
            }
            args[i++] = next;
        }
        String resolvedMessage = SharedUtils.translate(key, args);
        stack.push((Object)resolvedMessage);
    }
}

