/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.engine.calcitems;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.engine.util.StackUtil;
import ch.dvbern.tax.ge.pp.utils.SharedUtils;
import org.checkerframework.checker.nullness.qual.NonNull;

public class CFDetermineTypeBaremeICC
implements CalcItem {
    public void evaluate(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull LogicModelItem.ProtectedMap dataModel, @NonNull FastStack stack, @NonNull String dataModelKey) {
        boolean isMarried = StackUtil.getBoolean((FastStack)stack);
        String baremChild = this.getStringOrEmpty(StackUtil.getString((FastStack)stack));
        String baremOther = this.getStringOrEmpty(StackUtil.getString((FastStack)stack));
        if (isMarried || baremChild.equals("Splitting") || baremOther.equals("Splitting")) {
            stack.push((Object)"Splitting");
            return;
        }
        if (baremChild.equals("Splitting partiel") || baremOther.equals("Splitting partiel")) {
            stack.push((Object)"Splitting partiel");
            return;
        }
        stack.push((Object)"Sans splitting");
    }

    private String getStringOrEmpty(String string) {
        return string == null ? "" : string;
    }

    public static class DetermineTypeBaremeICCFromConcatenedString
    implements CalcItem {
        public void evaluate(LogicModelItem.ProtectedMap dataModel, @NonNull FastStack stack, @NonNull String dataModelKey) {
            String[] parts;
            boolean isMarried = StackUtil.getBoolean((FastStack)stack);
            String concatenedString = StackUtil.getString((FastStack)stack);
            if (concatenedString == null || concatenedString.isEmpty()) {
                stack.push((Object)"");
                return;
            }
            if (isMarried) {
                stack.push((Object)"Splitting");
                return;
            }
            for (String part : parts = concatenedString.split(", ")) {
                if (!part.equals("Splitting")) continue;
                stack.push((Object)"Splitting");
                return;
            }
            for (String part : parts) {
                if (!part.contains("Splitting partiel")) continue;
                stack.push((Object)"Splitting partiel");
                return;
            }
            stack.push((Object)"Sans splitting");
        }
    }

    public static class DisplayBaremAsChar
    implements CalcItem {
        public void evaluate(LogicModelItem.ProtectedMap dataModel, @NonNull FastStack stack, @NonNull String dataModelKey) {
            String barem = StackUtil.getString((FastStack)stack);
            if (barem == null || barem.isEmpty()) {
                stack.push((Object)"");
                return;
            }
            if (barem.equals("Splitting")) {
                stack.push((Object)"S");
            } else if (barem.equals("Splitting partiel")) {
                stack.push((Object)"P");
            } else {
                stack.push((Object)"C");
            }
        }
    }

    public static class DisplayBaremAsString
    implements CalcItem {
        public void evaluate(LogicModelItem.ProtectedMap dataModel, @NonNull FastStack stack, @NonNull String dataModelKey) {
            String barem = StackUtil.getString((FastStack)stack);
            if (barem == null || barem.isEmpty()) {
                stack.push((Object)"");
                return;
            }
            if (barem.equals("Splitting")) {
                stack.push((Object)SharedUtils.translate("label.stammdaten.enfants.recap.splitting", new Object[0]));
            } else if (barem.equals("Splitting partiel")) {
                stack.push((Object)SharedUtils.translate("label.stammdaten.enfants.recap.splitting.partiel", new Object[0]));
            } else {
                stack.push((Object)SharedUtils.translate("label.stammdaten.enfants.recap.no-split", new Object[0]));
            }
        }
    }
}

