/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.engine.calcitems;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.engine.util.StackUtil;
import ch.dvbern.tax.common.transfer.dto.OptionItemDTO;
import ch.dvbern.tax.ge.pp.utils.ResourceEnum;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Map;

public class CFDetermineImpotIfd
implements CalcItem {
    public static final BigDecimal TAUX_MAXIMUM = BigDecimal.valueOf(11.5);
    public static final BigDecimal IMPOT_MINIMUM_MARIE = BigDecimal.valueOf(33.0);
    public static final BigDecimal IMPOT_MINIMUM_CELIBATAIRE = BigDecimal.valueOf(25.41);
    public static final String IFD_MARIE_RESOURCE_NAME = ResourceEnum.IMPOT_IFD_MARIE.code();
    public static final String IFD_CELIBATAIRE_RESOURCE_NAME = ResourceEnum.IMPOT_IFD_CELIBATAIRE.code();
    private static final MathContext MC = new MathContext(20, RoundingMode.DOWN);
    private static final BigDecimal ROUNDING_UNIT = BigDecimal.valueOf(0.05);
    DataResource dataResource;

    public CFDetermineImpotIfd(DataResource dataResource) {
        this.dataResource = dataResource;
    }

    public void evaluate(LogicModelItem.ProtectedMap model, FastStack stack, String dataModelKey) {
        long montantImposable = StackUtil.getLong((FastStack)stack);
        long montantTaux = StackUtil.getLong((FastStack)stack);
        long type = StackUtil.getLong((FastStack)stack);
        BigDecimal result = this.computeMontantIfd(montantTaux, type);
        if (montantTaux != 0L && montantTaux != montantImposable) {
            BigDecimal tauxFinal = result.divide(BigDecimal.valueOf(montantTaux), MC);
            result = this.round(BigDecimal.valueOf(montantImposable).multiply(tauxFinal));
        }
        stack.push((Object)result);
    }

    final BigDecimal computeMontantIfd(long montantTaux, long type) {
        BigDecimal montantMinimum;
        String resourceName;
        assert (montantTaux % 100L == 0L) : "Income not multiple of 100";
        if (type == 2L) {
            resourceName = IFD_MARIE_RESOURCE_NAME;
            montantMinimum = IMPOT_MINIMUM_MARIE;
        } else {
            resourceName = IFD_CELIBATAIRE_RESOURCE_NAME;
            montantMinimum = IMPOT_MINIMUM_CELIBATAIRE;
        }
        Map optionMap = this.dataResource.get(resourceName, null, null);
        String[] tranches = optionMap.keySet().toArray(new String[optionMap.size()]);
        long montantMinimumImposable = Long.valueOf(tranches[0]);
        long montantMaximumImposable = Long.valueOf(tranches[tranches.length - 1]);
        if (montantTaux < montantMinimumImposable) {
            return BigDecimal.ZERO;
        }
        assert (montantTaux > 0L) : "Divide-by-zero preventive check";
        if (montantTaux >= montantMaximumImposable) {
            return this.computeRangee(TAUX_MAXIMUM, montantTaux / 100L);
        }
        boolean rangeeTerminale = false;
        BigDecimal result = montantMinimum;
        boolean premiereRangee = true;
        for (int i = 1; i < tranches.length && !rangeeTerminale; ++i) {
            long nombreDeTranche;
            String trancheSupKey = tranches[i];
            long trancheSup = Long.parseLong(trancheSupKey);
            long trancheInf = Long.parseLong(tranches[i - 1]);
            assert (trancheInf % 100L == 0L && trancheSup % 100L == 0L) : "Invalid data: ranges must be multiple of 100";
            assert (trancheSup > trancheInf) : "Invalid data: ranges must be increasing";
            long remains = montantTaux - trancheSup;
            BigDecimal taux = new BigDecimal((String)((OptionItemDTO)optionMap.get(trancheSupKey)).getText());
            if (remains < 0L) {
                nombreDeTranche = (montantTaux - trancheInf) / 100L;
                if (!premiereRangee) {
                    ++nombreDeTranche;
                }
                rangeeTerminale = true;
            } else {
                nombreDeTranche = (trancheSup - trancheInf) / 100L;
                if (premiereRangee) {
                    --nombreDeTranche;
                }
            }
            result = this.computeRangee(result, taux, nombreDeTranche);
            premiereRangee = false;
        }
        return result;
    }

    private BigDecimal computeRangee(BigDecimal taux, long nombreDeTranche) {
        return this.computeRangee(BigDecimal.ZERO, taux, nombreDeTranche);
    }

    private BigDecimal computeRangee(BigDecimal initial, BigDecimal taux, long nombreDeTranche) {
        initial = initial.add(taux.multiply(BigDecimal.valueOf(nombreDeTranche)));
        return this.round(initial);
    }

    private BigDecimal round(BigDecimal value) {
        return value.divide(ROUNDING_UNIT).setScale(0, RoundingMode.DOWN).multiply(ROUNDING_UNIT);
    }
}

