/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.engine.calcitems;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.engine.util.StackUtil;
import ch.dvbern.tax.common.transfer.dto.OptionItemDTO;
import java.util.Map;
import java.util.StringTokenizer;

public abstract class CFDetermineImpotFortune
implements CalcItem {
    private final DataResource dataResource;
    private Object[] stufen;

    public CFDetermineImpotFortune(DataResource dataResource) {
        this.dataResource = dataResource;
    }

    protected abstract String getDataSourceType();

    public void evaluate(LogicModelItem.ProtectedMap model, FastStack stack, String dataModelKey) {
        long fortune = StackUtil.getLong((FastStack)stack);
        long fortuneDeterminantePourLeTaux = StackUtil.getLong((FastStack)stack);
        Map optionMap = this.dataResource.get(this.getDataSourceType(), null, null);
        this.stufen = optionMap.keySet().toArray();
        long montant = fortune - fortune % 10L;
        double impot = 0.0;
        String stufe = this.getStufe(fortuneDeterminantePourLeTaux);
        if (stufe != null) {
            long milliersSupplementaires = fortuneDeterminantePourLeTaux - Long.parseLong(stufe);
            double impotAnnuel = Double.parseDouble(this.getImpotAnnuel(fortuneDeterminantePourLeTaux));
            double montantParMilleFrancsSupp = Double.parseDouble(this.getMontantParMilleFrancsSupp(fortuneDeterminantePourLeTaux));
            impot = impotAnnuel + (double)milliersSupplementaires * montantParMilleFrancsSupp / 1000.0;
            if (fortuneDeterminantePourLeTaux != 0L) {
                impot = impot / (double)fortuneDeterminantePourLeTaux * (double)montant;
            }
        }
        double d = Math.round(impot * 20.0);
        stack.push((Object)(d / 20.0));
    }

    private String getStufe(long fortuneDeterminantePourLeTaux) {
        long maxStufe = -1L;
        for (int i = 1; i < this.stufen.length; ++i) {
            long currentStuffe = Long.parseLong((String)this.stufen[i]);
            long stufeBefore = Long.parseLong((String)this.stufen[i - 1]);
            if (currentStuffe > maxStufe) {
                maxStufe = currentStuffe;
            }
            if (currentStuffe <= fortuneDeterminantePourLeTaux) continue;
            if (i == 0) {
                return null;
            }
            return String.valueOf(stufeBefore);
        }
        return String.valueOf(maxStufe);
    }

    private String getImpotAnnuel(long fortuneDeterminantePourLeTaux) {
        String stufe = this.getStufe(fortuneDeterminantePourLeTaux);
        OptionItemDTO item = (OptionItemDTO)this.dataResource.get(this.getDataSourceType(), null, null).get(stufe);
        String impotAnnuel = null;
        if (item != null) {
            String values = (String)item.getText();
            StringTokenizer tokenizer = new StringTokenizer(values, "\t");
            impotAnnuel = tokenizer.nextToken();
            tokenizer.nextToken();
        }
        return impotAnnuel;
    }

    private String getMontantParMilleFrancsSupp(long fortuneDeterminantePourLeTaux) {
        String stufe = this.getStufe(fortuneDeterminantePourLeTaux);
        OptionItemDTO item = (OptionItemDTO)this.dataResource.get(this.getDataSourceType(), null, null).get(stufe);
        String par1000CHFSupp = null;
        if (item != null) {
            String values = (String)item.getText();
            StringTokenizer tokenizer = new StringTokenizer(values, "\t");
            tokenizer.nextToken();
            par1000CHFSupp = tokenizer.nextToken();
        }
        return par1000CHFSupp;
    }
}

