/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.engine.calcitems;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.ge.pp.transfer.dto.DeductionDTO;
import ch.dvbern.tax.ge.pp.utils.ResourceEnum;
import java.util.Map;

public class CFDeductionAvs
implements CalcItem {
    private final DataResource dataResource;

    public CFDeductionAvs(DataResource dataResource) {
        this.dataResource = dataResource;
    }

    public void evaluate(LogicModelItem.ProtectedMap dataModel, FastStack stack, String dataModelKey) {
        long revenu = 0L;
        long autresRevenuConjoint = 0L;
        long autresRevenuContribuable = 0L;
        boolean isRenteSurvivant = false;
        boolean isRenteComplementConjoint = false;
        boolean isRenteComplementContribuable = false;
        boolean isRenteSimpleConjoint = false;
        boolean isRenteSimpleContribuable = false;
        boolean mariee = false;
        Object oRevenu = stack.pop();
        Object oAutresRevenuConjoint = stack.pop();
        Object oAutresRevenuContribuable = stack.pop();
        Object oRenteSurvivant = stack.pop();
        Object oRenteSimpleConjoint = stack.pop();
        Object oRenteSimpleContribuable = stack.pop();
        Object oRenteComplementConjoint = stack.pop();
        Object oRenteComplementContribuable = stack.pop();
        Object oMariee = stack.pop();
        if (oMariee == null) {
            stack.push(null);
            return;
        }
        if (oRevenu == null) {
            stack.push(null);
            return;
        }
        if (oRenteSurvivant == null && oRenteSimpleConjoint == null && oRenteSimpleContribuable == null) {
            stack.push(null);
            return;
        }
        if (oAutresRevenuConjoint instanceof Number) {
            autresRevenuConjoint = ((Number)oAutresRevenuConjoint).longValue();
        }
        if (oAutresRevenuContribuable instanceof Number) {
            autresRevenuContribuable = ((Number)oAutresRevenuContribuable).longValue();
        }
        if (oRevenu instanceof Number) {
            revenu = ((Number)oRevenu).longValue();
        }
        if (oRenteSurvivant instanceof Boolean) {
            isRenteSurvivant = (Boolean)oRenteSurvivant;
        }
        if (oRenteSimpleConjoint instanceof Boolean) {
            isRenteSimpleConjoint = (Boolean)oRenteSimpleConjoint;
        }
        if (oRenteSimpleContribuable instanceof Boolean) {
            isRenteSimpleContribuable = (Boolean)oRenteSimpleContribuable;
        }
        if (oRenteComplementConjoint instanceof Boolean) {
            isRenteComplementConjoint = (Boolean)oRenteComplementConjoint;
        }
        if (oRenteComplementContribuable instanceof Boolean) {
            isRenteComplementContribuable = (Boolean)oRenteComplementContribuable;
        }
        if (oMariee instanceof Boolean) {
            mariee = (Boolean)oMariee;
        }
        Long result = null;
        DeductionDTO correctDTO = null;
        boolean isRenteContribuable = isRenteSimpleContribuable || isRenteSurvivant;
        boolean isMehrpersonenHaushalt = mariee;
        String resource = isMehrpersonenHaushalt ? ResourceEnum.DEDUCTION_AVS_MEHRPERSONEN_HAUSHALT.code() : ResourceEnum.DEDUCTION_AVS_EINPERSONEN_HAUSHALT.code();
        Map deductionsMap = this.dataResource.get(resource, null, null);
        for (Object element : deductionsMap.keySet()) {
            Long revenuMaxOfThisItem = (Long)element;
            if (revenu > revenuMaxOfThisItem) continue;
            correctDTO = (DeductionDTO)deductionsMap.get(revenuMaxOfThisItem);
        }
        if (correctDTO != null) {
            if (autresRevenuConjoint > 0L && autresRevenuContribuable > 0L || (isRenteSimpleContribuable || isRenteComplementContribuable || isRenteSurvivant) && (isRenteSimpleConjoint || isRenteComplementConjoint)) {
                result = correctDTO.getDeductionMajoree();
            } else if (autresRevenuConjoint > 0L || autresRevenuContribuable > 0L || isRenteSimpleContribuable || isRenteComplementContribuable || isRenteSurvivant || isRenteSimpleConjoint || isRenteComplementConjoint) {
                result = correctDTO.getDeductionSimple();
            }
        }
        stack.push(result);
    }
}

