/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.engine.calcitems;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.engine.util.StackUtil;
import ch.dvbern.tax.ge.pp.transfer.dto.AutrePersonneAChargeDTO;
import ch.dvbern.tax.ge.pp.transfer.dto.DeducPersChargeDTO;
import ch.dvbern.tax.ge.pp.transfer.logic.DeductionAutrePersonneAChargeUtils;
import ch.dvbern.tax.ge.pp.transfer.logic.DeductionPersonneAChargeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CFDeductionAutrePersonne
implements CalcItem {
    public void evaluate(LogicModelItem.ProtectedMap dataModel, @NotNull FastStack stack, @Nullable String dataModelKey) {
        AutrePersonneAChargeDTO autrePersonneAChargeDTO = this.createAutrePersonneAChargeFromStack(stack);
        DeducPersChargeDTO deducPersChargeDTO = DeductionAutrePersonneAChargeUtils.calculateDeductionForAutrePersACharge(autrePersonneAChargeDTO);
        stack.push(DeductionPersonneAChargeUtils.createMapFromDeduction(deducPersChargeDTO));
    }

    private AutrePersonneAChargeDTO createAutrePersonneAChargeFromStack(@NotNull FastStack stack) {
        long prestationVersee = StackUtil.getLong((FastStack)stack);
        long revenu = StackUtil.getLong((FastStack)stack);
        long fortune = StackUtil.getLong((FastStack)stack);
        boolean visAvec = StackUtil.getBoolean((FastStack)stack);
        long nbrAutrePersonnesEntretient = StackUtil.getLong((FastStack)stack);
        boolean responsabilite = StackUtil.getBoolean((FastStack)stack);
        int degreDeParente = StackUtil.getInteger((FastStack)stack);
        int statut = StackUtil.getInteger((FastStack)stack);
        long age = StackUtil.getLong((FastStack)stack);
        AutrePersonneAChargeDTO autrePersonneAChargeDTO = new AutrePersonneAChargeDTO(age, responsabilite, degreDeParente, statut, nbrAutrePersonnesEntretient, prestationVersee, visAvec, revenu, fortune);
        return autrePersonneAChargeDTO;
    }
}

