/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.engine.calcitems;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.ge.pp.transfer.dto.AssurancesMaladieDTO;
import ch.dvbern.tax.ge.pp.utils.ResourceEnum;
import java.util.Map;
import java.util.StringTokenizer;

public class CFDeductionAssurancesMaladie
implements CalcItem {
    private final DataResource dataResource;

    public CFDeductionAssurancesMaladie(DataResource dataResource) {
        this.dataResource = dataResource;
    }

    public void evaluate(LogicModelItem.ProtectedMap model, FastStack stack, String dataModelKey) {
        long result = 0L;
        Object oAgeActuel = stack.pop();
        if (oAgeActuel == null) {
            stack.push(null);
            return;
        }
        if (oAgeActuel instanceof Number) {
            long ageActuel = ((Number)oAgeActuel).longValue();
            result = this.getDeduction(ageActuel);
        } else if (oAgeActuel instanceof String) {
            String sAgeActuelConcat = (String)oAgeActuel;
            StringTokenizer tokenizer = new StringTokenizer(sAgeActuelConcat, ";");
            while (tokenizer.hasMoreTokens()) {
                long ageActuel = Long.valueOf(tokenizer.nextToken());
                if (ageActuel < 0L) {
                    return;
                }
                result += this.getDeduction(ageActuel);
            }
        }
        stack.push((Object)result);
    }

    private long getDeduction(long ageActuel) {
        long deduction = 0L;
        Map dtoMap = this.dataResource.get(ResourceEnum.DEDUCTION_ASSURANCES_MALADIE.code(), null, null);
        for (Object element : dtoMap.keySet()) {
            Long ageOfThisItem = (Long)element;
            if (ageActuel < ageOfThisItem) continue;
            deduction = ((AssurancesMaladieDTO)dtoMap.get(ageOfThisItem)).getDeduction();
        }
        return deduction;
    }
}

