/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.engine.calcitems;

import ch.dvbern.tax.common.engine.ComplexCalcItem;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.modelitems.Select;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.ge.pp.utils.SharedUtils;
import java.util.Map;

public class CFCurrentSelectLabel
implements ComplexCalcItem {
    private final Reference selectRef;
    private final Reference valueRef;
    private final boolean useShortText;

    public CFCurrentSelectLabel(Reference selectRef) {
        this(selectRef, selectRef);
    }

    public CFCurrentSelectLabel(Reference selectRef, boolean useShortText) {
        this(selectRef, selectRef, useShortText);
    }

    public CFCurrentSelectLabel(Reference selectRef, Reference valueRef) {
        this(selectRef, valueRef, false);
    }

    public CFCurrentSelectLabel(Reference selectRef, Reference valueRef, boolean useShortText) {
        if (selectRef == null) {
            throw new NullPointerException("Select item reference cannot be null.");
        }
        if (valueRef == null) {
            throw new NullPointerException("Value item reference cannot be null.");
        }
        this.selectRef = selectRef;
        this.valueRef = valueRef;
        this.useShortText = useShortText;
    }

    public void evaluate(LogicModelItem.ProtectedMap dataModel, FastStack stack, String dataModelKey) {
        OptionItemsDTO items;
        OptionItemDTO item;
        Object selectValue;
        Select select = (Select)this.selectRef.getReference();
        String dmk = EngineUtil.mergeModelKey((String)this.valueRef.getReference().getName(), (String)dataModelKey);
        ModelItemDTO selectValueItem = dataModel.get((Object)dmk);
        String label = "";
        if (selectValueItem != null && (selectValue = selectValueItem.getValue()) != null && (item = (items = select.getOptionItems(dataModel, dataModelKey)).get((Object)selectValue.toString())) != null) {
            String txt = (this.useShortText ? item.getShortText() : item.getText()).toString();
            label = item.isResourceKey() ? SharedUtils.translate(txt, new Object[0]) : txt;
        }
        stack.push((Object)label);
    }

    public void initializeReferences(Map<String, LogicModelItem> logicModel, LogicModelItem logicModelItem) throws InvalidModelException {
        this.selectRef.registerListenerOnReference(logicModel, logicModelItem, false);
        if (!this.selectRef.getName().equals(this.valueRef.getName())) {
            this.valueRef.registerListenerOnReference(logicModel, logicModelItem, false);
        }
    }
}

