/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.engine.calcitems;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.ge.pp.utils.ResourceEnum;
import ch.dvbern.tax.ge.pp.utils.SharedUtils;
import ch.dvbern.tax.ge.pp.utils.StackUtil;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class CFCurrencyToCHFConverter
implements CalcItem {
    private final DataResource dataResource;

    public CFCurrencyToCHFConverter(DataResource dataResource) {
        this.dataResource = dataResource;
    }

    public void evaluate(LogicModelItem.ProtectedMap model, FastStack stack, String dataModelKey) {
        double result = 0.0;
        String currency = StackUtil.getString(stack);
        Long montantAcquisition = StackUtil.getLong(stack);
        SharedUtils.Currency currencyRate = (SharedUtils.Currency)this.dataResource.get(ResourceEnum.TAUX_CHANGE_FORTUNE.code(), (Object)currency, null).get(currency);
        if (montantAcquisition > 0L && currencyRate != null) {
            result = (double)montantAcquisition.longValue() / currencyRate.getUnit() * currencyRate.getTauxFortune();
        }
        stack.push((Object)result);
    }

    public static class PrintCurrencyLong
    implements CalcItem {
        public void evaluate(LogicModelItem.ProtectedMap dataModel, @NotNull FastStack stack, @NotNull String dataModelKey) {
            long amount = StackUtil.getLong(stack);
            stack.push((Object)amount);
        }
    }

    public static class PrintCurrency
    implements CalcItem {
        public void evaluate(LogicModelItem.ProtectedMap dataModel, @NotNull FastStack stack, @NotNull String dataModelKey) {
            Object value = stack.pop();
            if (value instanceof Double) {
                Double d = (Double)value;
                DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.US);
                DecimalFormat df = new DecimalFormat("0.##########", symbols);
                String s = df.format(d);
                stack.push((Object)s);
            }
        }
    }
}

