/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.engine.calcitems;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.engine.util.StackUtil;
import ch.dvbern.tax.ge.pp.transfer.dto.EgliseDTO;
import ch.dvbern.tax.ge.pp.utils.ResourceEnum;
import java.util.Map;

public class CFContributionReligieuse
implements CalcItem {
    private final DataResource dataResource;

    public CFContributionReligieuse(DataResource dataResource) {
        this.dataResource = dataResource;
    }

    public void evaluate(LogicModelItem.ProtectedMap dataModel, FastStack stack, String dataModelKey) {
        double impotDeBaseSurRevenu = StackUtil.getDouble((FastStack)stack);
        double impotDeBaseSurFortune = StackUtil.getDouble((FastStack)stack);
        double revenuICCPartImposableGeneve = StackUtil.getDouble((FastStack)stack);
        long confessionContribuable = StackUtil.getLong((FastStack)stack);
        long confessionConjoint = StackUtil.getLong((FastStack)stack);
        boolean isCouple = StackUtil.getBoolean((FastStack)stack);
        double crv = 0.0;
        Map optionMap = this.dataResource.get(ResourceEnum.EGLISES.code(), null, null);
        double crvContribuable = this.calculateCrv(confessionContribuable, impotDeBaseSurRevenu, impotDeBaseSurFortune, revenuICCPartImposableGeneve, optionMap);
        double crvConjoint = this.calculateCrv(confessionConjoint, impotDeBaseSurRevenu, impotDeBaseSurFortune, revenuICCPartImposableGeneve, optionMap);
        crv = isCouple ? crvContribuable * 0.5 + crvConjoint * 0.5 : crvContribuable;
        stack.push((Object)Math.max(0.0, crv));
    }

    private double calculateCrv(long confession, double impotDeBaseSurRevenu, double impotDeBaseSurFortune, double revenuICCPartImposableGeneve, Map<String, EgliseDTO> optionMap) {
        double crv = 0.0;
        if (confession != 0L) {
            EgliseDTO eglise = null;
            if (optionMap != null) {
                eglise = optionMap.get(confession);
            }
            if (eglise != null) {
                double crvRevenu = impotDeBaseSurRevenu * (eglise.getTcrOr() / 100.0);
                double crvFortune = impotDeBaseSurFortune * (eglise.getTcfOr() / 100.0);
                crv = eglise.getDpfOr() + crvRevenu + crvFortune;
            }
        }
        double valeurPlafond = revenuICCPartImposableGeneve * 0.015;
        return Math.min(crv, valeurPlafond);
    }
}

