/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.calculimpot.repartition.table;

import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.RepartitionCivilite;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.table.RepartitionColumn;
import ch.dvbern.tax.ge.pp.utils.SharedUtils;
import java.util.Map;
import java.util.TreeMap;

public class RepartitionTable {
    private int countRows = 0;
    private final RepartitionColumn columnCode = new RepartitionColumn();
    private final RepartitionColumn columnLibelle = new RepartitionColumn();
    private final RepartitionColumn columnCivilite = new RepartitionColumn();
    private final RepartitionColumn columnAdmis = new RepartitionColumn();
    private final Map<String, RepartitionColumn> repartition = new TreeMap<String, RepartitionColumn>();
    private final Map<String, RepartitionColumn> repartitionPart = new TreeMap<String, RepartitionColumn>();
    private final RepartitionColumn columnDatamodelKey = new RepartitionColumn();

    public RepartitionTable(DataResource dataResource) {
        this.columnCode.setTitle(SharedUtils.translate("title.col.recapitulation.repartition.code", new Object[0]));
        this.columnLibelle.setTitle(SharedUtils.translate("title.col.recapitulation.repartition.libelle", new Object[0]));
        this.columnCivilite.setTitle(SharedUtils.translate("title.col.recapitulation.repartition.civilite", new Object[0]));
        this.columnAdmis.setTitle(SharedUtils.translate("title.col.recapitulation.repartition.admis", new Object[0]));
        this.columnDatamodelKey.setTitle("Test");
    }

    public void addRow(int rowIndex, String code, String libelle, RepartitionCivilite civilite, long admis, String canton, long value, double valuePart, String key) {
        RepartitionColumn column;
        this.columnCode.put(rowIndex, code);
        this.columnLibelle.put(rowIndex, libelle);
        this.columnCivilite.put(rowIndex, (Object)civilite);
        this.columnAdmis.put(rowIndex, String.valueOf(admis));
        this.columnDatamodelKey.put(rowIndex, key);
        if (this.repartition.containsKey(canton)) {
            column = this.repartition.get(canton);
        } else {
            column = new RepartitionColumn();
            column.setTitle(canton);
            this.repartition.put(canton, column);
        }
        column.put(rowIndex, value);
        if (valuePart != 0.0) {
            RepartitionColumn columnPart;
            if (this.repartitionPart.containsKey(canton)) {
                columnPart = this.repartitionPart.get(canton);
            } else {
                columnPart = new RepartitionColumn();
                columnPart.setTitle(canton);
                this.repartitionPart.put(canton, columnPart);
            }
            columnPart.put(rowIndex, valuePart);
        }
        this.countRows = rowIndex;
    }

    public int getCountRows() {
        return this.countRows;
    }

    public RepartitionColumn getColumnCode() {
        return this.columnCode;
    }

    public RepartitionColumn getColumnLibelle() {
        return this.columnLibelle;
    }

    public RepartitionColumn getColumnCivilite() {
        return this.columnCivilite;
    }

    public RepartitionColumn getColumnAdmis() {
        return this.columnAdmis;
    }

    public Map<String, RepartitionColumn> getRepartition() {
        return this.repartition;
    }

    public Map<String, RepartitionColumn> getRepartitionPart() {
        return this.repartitionPart;
    }

    public RepartitionColumn getColumnDatamodelKey() {
        return this.columnDatamodelKey;
    }
}

