/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.calculimpot.repartition.results;

import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.utils.RepartitionColumnSum;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.utils.enums.RepartitionHierarchie;
import ch.dvbern.tax.ge.pp.engine.modelitems.repartition.RepartitionItem;
import ch.dvbern.tax.ge.pp.utils.DataModelUtil;

public abstract class RepartitionResults {
    protected LogicModelItem.ProtectedMap dataModel = null;
    private final String sessionAttributePrefix;
    protected DataModelUtil dmUtil = null;
    private Long fortuneDeterminantePourLeTaux = 0L;
    private Long fortuneTotalImposableGeneve = 0L;
    private Long fortuneTotalNonImposable = 0L;
    private Long revenuDeterminantPourLeTaux = 0L;
    private Long revenuTotalImposable = 0L;
    private Long revenuTotalNonImposable = 0L;

    protected RepartitionResults(LogicModelItem.ProtectedMap dataModel, RepartitionHierarchie sessionAttributePrefix) {
        this.dataModel = dataModel;
        this.sessionAttributePrefix = sessionAttributePrefix.toString();
        this.dmUtil = new DataModelUtil(this.dataModel);
    }

    public Long getFortuneTotalImposableGeneve() {
        return this.fortuneTotalImposableGeneve;
    }

    public void setFortuneTotalImposableGeneve(Long fortuneTotalImposableGeneve) {
        this.fortuneTotalImposableGeneve = fortuneTotalImposableGeneve;
    }

    public Long getFortuneTotalNonImposable() {
        return this.fortuneTotalNonImposable;
    }

    public void setFortuneTotalNonImposable(Long fortuneTotalNonImposable) {
        this.fortuneTotalNonImposable = fortuneTotalNonImposable;
    }

    public Long getRevenuTotalImposable() {
        return this.revenuTotalImposable;
    }

    public void setRevenuTotalImposable(Long revenuTotalImposable) {
        this.revenuTotalImposable = revenuTotalImposable;
    }

    public Long getRevenuTotalNonImposable() {
        return this.revenuTotalNonImposable;
    }

    public void setRevenuTotalNonImposable(Long revenuTotalNonImposable) {
        this.revenuTotalNonImposable = revenuTotalNonImposable;
    }

    public Long getFortuneDeterminantePourLeTaux() {
        return this.fortuneDeterminantePourLeTaux;
    }

    public void setFortuneDeterminantePourLeTaux(Long fortuneDeterminantePourLeTaux) {
        this.fortuneDeterminantePourLeTaux = fortuneDeterminantePourLeTaux;
    }

    public Long getRevenuDeterminantPourLeTaux() {
        return this.revenuDeterminantPourLeTaux;
    }

    public void setRevenuDeterminantPourLeTaux(Long revenuDeterminantPourLeTaux) {
        this.revenuDeterminantPourLeTaux = revenuDeterminantPourLeTaux;
    }

    private String getSessionAttributeFullKey(String key) {
        return key + "." + this.sessionAttributePrefix;
    }

    protected RepartitionColumnSum getSessionAttribute(String key) {
        String fullKey = this.getSessionAttributeFullKey(key);
        if (this.dataModel.getSessionAttributes().get(fullKey) != null) {
            return (RepartitionColumnSum)this.dataModel.getSessionAttributes().get(fullKey);
        }
        RepartitionColumnSum tmp = new RepartitionColumnSum();
        this.dataModel.getSessionAttributes().put(fullKey, tmp);
        return tmp;
    }

    public RepartitionColumnSum getActifsBrutsLocalises() {
        return this.getSessionAttribute("Recapitulation.CalculImpot.ActifsBrutsLocalises");
    }

    public RepartitionColumnSum getFortuneNette() {
        return this.getSessionAttribute("Recapitulation.CalculImpot.FortuneNette");
    }

    public RepartitionColumnSum getFortuneTotale() {
        return this.getSessionAttribute("Recapitulation.CalculImpot.FortuneTotale");
    }

    public RepartitionColumnSum getRevenuNet() {
        return this.getSessionAttribute("Recapitulation.CalculImpot.RevenuNet");
    }

    public RepartitionColumnSum getRendementBrutDeFortune() {
        return this.getSessionAttribute("Recapitulation.CalculImpot.RendementBrutDeFortune");
    }

    public RepartitionColumnSum getFortuneBrute() {
        return this.getSessionAttribute("Recapitulation.CalculImpot.FortuneNette");
    }

    private void resetSessionAttribute(String key) {
        String fullKey = this.getSessionAttributeFullKey(key);
        RepartitionColumnSum tmp = new RepartitionColumnSum();
        this.dataModel.getSessionAttributes().put(fullKey, tmp);
    }

    protected void resetSessionAttributes() {
        this.resetSessionAttribute("Recapitulation.CalculImpot.ActifsBrutsLocalises");
        this.resetSessionAttribute("Recapitulation.CalculImpot.FortuneNette");
        this.resetSessionAttribute("Recapitulation.CalculImpot.FortuneTotale");
        this.resetSessionAttribute("Recapitulation.CalculImpot.RevenuNet");
        this.resetSessionAttribute("Recapitulation.CalculImpot.RendementBrutDeFortune");
        this.resetSessionAttribute("Recapitulation.CalculImpot.FortuneNette");
    }

    public abstract void saveInstance(RepartitionItem var1);
}

