/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.calculimpot.repartition.internationale;

import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.RepartitionRevenuCalcul;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.internationale.results.RepartitionInternationaleResults;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.results.RepartitionResults;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.utils.enums.RepartitionHierarchie;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.utils.enums.RepartitionMode;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.utils.enums.RepartitionType;
import ch.dvbern.tax.ge.pp.repartition.RepartitionVariable;
import ch.dvbern.tax.ge.pp.repartition.RepartitionVariableSelect;

public class RepartitionInternationaleRevenuCalcul
extends RepartitionRevenuCalcul {
    private final RepartitionInternationaleResults results;

    public RepartitionInternationaleRevenuCalcul(LogicModelItem.ProtectedMap dataModel, DataResource dataResource, RepartitionHierarchie hierarchie) {
        super(dataModel, dataResource, hierarchie);
        this.results = new RepartitionInternationaleResults(dataModel, true);
    }

    @Override
    public RepartitionResults getResults() {
        return this.results;
    }

    @Override
    protected void setSelectParticipeAssieteType(RepartitionVariableSelect selectVariable) {
        selectVariable.setWhereIFDParticipeAssiette(Boolean.TRUE);
    }

    @Override
    protected void setSelectRevenuRepartitionRevenusNets(RepartitionVariableSelect selectVariable) {
        if (this.quasiResident) {
            selectVariable.setWhereRevenuRepartitionFederaleQuasiResident(RepartitionMode.REVENUS_NETS);
        } else {
            selectVariable.setWhereRevenuRepartitionFederale(RepartitionMode.REVENUS_NETS);
        }
    }

    @Override
    protected void setSelectRevenuRepartitionTypeNotRevenusNets(RepartitionVariableSelect selectVariable) {
        if (this.quasiResident) {
            selectVariable.setWhereRevenuRepartitionFederaleQuasiResidentNot(RepartitionMode.REVENUS_NETS);
        } else {
            selectVariable.setWhereRevenuRepartitionFederaleNot(RepartitionMode.REVENUS_NETS);
        }
    }

    @Override
    protected String getSelectedKey(RepartitionVariable variable, String key, String keyInternationale, String keyCommunale) {
        if (variable.getKeyRevenuInternational() != null && variable.getKeyRevenuInternational().length() > 0) {
            return keyInternationale;
        }
        return key;
    }

    @Override
    protected RepartitionType getTypeRepartition() {
        if (this.quasiResident) {
            return RepartitionType.REVENU_NATIONAL_QUASI_RESIDENT;
        }
        return RepartitionType.REVENU_NATIONAL;
    }

    @Override
    protected void computeRevenuDeterminantTaux() {
        Long imposableValue;
        Long revenuDeterminant = this.columnsSum.getSumAllColumns();
        Long etrangerValue = 0L;
        if (this.columnsSum.getColumns().containsKey("EX")) {
            etrangerValue = this.columnsSum.getColumnValue("EX");
        }
        if ((imposableValue = Long.valueOf(this.columnsSum.getSumAllColumns() - etrangerValue)) <= 0L) {
            revenuDeterminant = 0L;
            imposableValue = 0L;
            etrangerValue = 0L;
        }
        this.getResults().setRevenuDeterminantPourLeTaux(revenuDeterminant);
        this.getResults().setRevenuTotalImposable(imposableValue);
        this.getResults().setRevenuTotalNonImposable(etrangerValue);
    }
}

