/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.calculimpot.repartition.intercommunale;

import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.RepartitionCivilite;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.RepartitionRevenuCalcul;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.intercantonale.RepartitionIntercantonaleRevenuCalcul;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.intercommunale.results.RepartitionIntercommunaleResults;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.results.RepartitionResults;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.table.RepartitionColumn;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.table.RepartitionTable;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.utils.enums.RepartitionHierarchie;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.utils.enums.RepartitionMode;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.utils.enums.RepartitionType;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.utils.enums.RevenuFortune;
import ch.dvbern.tax.ge.pp.engine.modelitems.repartition.RepartitionItem;
import ch.dvbern.tax.ge.pp.repartition.RepartitionVariable;
import ch.dvbern.tax.ge.pp.repartition.RepartitionVariableSelect;
import ch.dvbern.tax.ge.pp.utils.SharedUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;

public class RepartitionIntercommunaleRevenuCalcul
extends RepartitionRevenuCalcul {
    private final RepartitionIntercommunaleResults results;
    private final RepartitionItem destination;
    private RepartitionTable tableRevenuICC = null;

    public RepartitionIntercommunaleRevenuCalcul(LogicModelItem.ProtectedMap dataModel, DataResource dataResource, RepartitionHierarchie hierarchie, RepartitionItem destination) {
        super(dataModel, dataResource, hierarchie);
        this.destination = destination;
        this.results = new RepartitionIntercommunaleResults(dataModel, true);
    }

    @Override
    public RepartitionResults getResults() {
        return this.results;
    }

    @Override
    public RepartitionTable compute() throws SQLException {
        this.initRepartitionIntercantonale();
        this.initKeyTaxation();
        this.computeRevenuNet();
        this.computeExcedentDeChargeCommunaux();
        this.computeRevenuImposable();
        this.computeAucunRevenuImposable();
        return this.table;
    }

    private void initRepartitionIntercantonale() throws SQLException {
        RepartitionIntercantonaleRevenuCalcul calculRevenuICC = new RepartitionIntercantonaleRevenuCalcul(this.dataModel, this.dataResource, RepartitionHierarchie.CANTONAL);
        this.tableRevenuICC = calculRevenuICC.compute();
        calculRevenuICC.getResults().saveInstance(this.destination);
    }

    private void computeRevenuNet() throws SQLException {
        RepartitionVariableSelect selectVariable = new RepartitionVariableSelect();
        selectVariable.setWhereRevenuLibelleNotEmpty(true);
        selectVariable.setWhereRevenuRepartitionCommunaleNot(RepartitionMode.REVENUS_NETS);
        selectVariable.setWhereICCParticipeAssiette(Boolean.TRUE);
        this.processVariables(selectVariable, RevenuFortune.REVENU, this.getTypeRepartition());
        this.addTotalToTable("92.15", SharedUtils.translate("label.recapitulation.repartition.communale.revenuNet", new Object[0]), RepartitionCivilite.FO, true);
        this.saveRevenuNet();
    }

    private void computeExcedentDeChargeCommunaux() {
        this.compensationSelonLesRevenusNetsPositifs();
    }

    private void computeRevenuImposable() throws SQLException {
        RepartitionVariableSelect selectVariable = new RepartitionVariableSelect();
        selectVariable.setWhereRevenuLibelleNotEmpty(true);
        selectVariable.setWhereRevenuRepartitionCommunale(RepartitionMode.REVENUS_NETS);
        selectVariable.setWhereICCParticipeAssiette(Boolean.TRUE);
        this.processVariables(selectVariable, RevenuFortune.REVENU, this.getTypeRepartition());
        String libelleRevenuTotal = "label.recapitulation.repartition.communale.revenuTotal";
        String libelleCompensation = "label.recapitulation.repartition.compensation";
        this.computeCompensationPourRevenuCantonal("label.recapitulation.repartition.compensation");
        this.addTotalToTable("99.00", SharedUtils.translate("label.recapitulation.repartition.communale.revenuTotal", new Object[0]), RepartitionCivilite.FO, true);
        this.computeCommunesNegatives("94.70", "label.recapitulation.repartition.compensation", "99.00", "label.recapitulation.repartition.communale.revenuTotal");
        this.saveRevenuImposable();
    }

    private void computeCompensationPourRevenuCantonal(String libelleCompensation) {
        RepartitionColumn columnRevenuICCCode;
        if (this.tableRevenuICC != null && (columnRevenuICCCode = this.tableRevenuICC.getColumnCode()) != null) {
            for (int i = 0; i <= this.tableRevenuICC.getCountRows(); ++i) {
                boolean isCorrectCompensationCode;
                int nextRow = i + 1;
                boolean bl = isCorrectCompensationCode = "94.70".equals(columnRevenuICCCode.get(i)) && nextRow < this.tableRevenuICC.getCountRows() && "91.50".equals(columnRevenuICCCode.get(nextRow));
                if (!isCorrectCompensationCode) continue;
                this.computeCompensation(libelleCompensation, i);
            }
        }
    }

    private void computeCompensation(String libelleCompensation, int i) {
        long valueColumnAdmis;
        Long valueColumnAdmisL = (Long)this.tableRevenuICC.getRepartition().get("GE").get(i);
        long l = valueColumnAdmis = valueColumnAdmisL != null ? valueColumnAdmisL : 0L;
        if (valueColumnAdmis != 0L) {
            this.addTotalToTable("99.00", SharedUtils.translate("label.recapitulation.repartition.communale.revenuTotalIntermediaire", new Object[0]), RepartitionCivilite.FO, true);
            long totalValueAdded = 0L;
            boolean isRowAdded = false;
            Iterator<Object> it = this.columnsSum.getColumns().keySet().iterator();
            while (it.hasNext()) {
                String commune = (String)it.next();
                RepartitionColumn tmpColumnPart = this.table.getRepartitionPart().get(commune);
                if (tmpColumnPart == null || tmpColumnPart.get(this.rowIndex - 1) == null) continue;
                double part = (Double)tmpColumnPart.get(this.rowIndex - 1);
                BigDecimal bdValue = BigDecimal.valueOf((double)valueColumnAdmis * part / 100.0);
                bdValue = bdValue.setScale(2, 2);
                long value = bdValue.longValue();
                if (it.hasNext()) {
                    totalValueAdded += value;
                } else {
                    value = valueColumnAdmis - totalValueAdded;
                }
                this.table.addRow(this.rowIndex, "94.70", SharedUtils.translate(libelleCompensation, new Object[0]), RepartitionCivilite.FO, valueColumnAdmis, commune, value, part, "");
                this.addToColumnTotal(commune, value);
                isRowAdded = true;
            }
            if (isRowAdded) {
                ++this.rowIndex;
            }
        }
    }

    private void saveRevenuImposable() {
        this.getResults().setRevenuDeterminantPourLeTaux(this.columnsSum.getSumAllColumns());
        ((RepartitionIntercommunaleResults)this.getResults()).setRecapitulationRevenuColumns(this.columnsSum.getColumns());
    }

    @Override
    protected long getValueRepartitionMode(RepartitionVariable variable, String key, String keyInternationale, String keyIntercommunale, String referencedKey, Object cantonOuCommune) {
        if (this.tableRevenuICC != null && !RepartitionMode.LOCALISATION_OU_DOMICILE.toString().equals(variable.getModeRepartitionFortuneCommunale())) {
            RepartitionColumn columnRevenuICCCode = this.tableRevenuICC.getColumnCode();
            RepartitionColumn columnRevenuICCKey = this.tableRevenuICC.getColumnDatamodelKey();
            long value = 0L;
            if (columnRevenuICCCode != null && columnRevenuICCKey != null) {
                ArrayList<Integer> tmpRowIndex = new ArrayList<Integer>();
                String selectedKey = this.getSelectedKey(variable, key, keyInternationale, keyIntercommunale);
                for (int i = 0; i <= this.tableRevenuICC.getCountRows(); ++i) {
                    if (!variable.getCode().equals(columnRevenuICCCode.get(i)) || !selectedKey.equals(columnRevenuICCKey.get(i))) continue;
                    tmpRowIndex.add(i);
                }
                if (this.tableRevenuICC.getRepartition() != null && this.tableRevenuICC.getRepartition().containsKey("GE")) {
                    RepartitionColumn columnGERevenuICC = this.tableRevenuICC.getRepartition().get("GE");
                    for (Integer row : tmpRowIndex) {
                        if (columnGERevenuICC.get(row) == null) continue;
                        value += ((Long)columnGERevenuICC.get(row)).longValue();
                    }
                }
            }
            return value;
        }
        if (!"EX".equals(cantonOuCommune)) {
            return this.getValue(variable, this.getSelectedKey(variable, key, keyInternationale, keyIntercommunale), referencedKey);
        }
        return 0L;
    }

    @Override
    protected String getSelectedKey(RepartitionVariable variable, String key, String keyInternationale, String keyCommunale) {
        if (variable.getKeyRevenuCommunal() != null && variable.getKeyRevenuCommunal().length() > 0) {
            return keyCommunale;
        }
        return key;
    }

    @Override
    protected RepartitionType getTypeRepartition() {
        return RepartitionType.REVENU_COMMUNAL;
    }

    private void saveRevenuNet() {
        this.getResults().getRevenuNet().setColumns(this.columnsSum.getColumns());
        this.getResults().getRevenuNet().setSumAllColumns(this.columnsSum.getSumAllColumns());
    }

    @Override
    protected void setSelectRevenuRepartitionRevenusNets(RepartitionVariableSelect selectVariable) {
    }

    @Override
    protected void setSelectRevenuRepartitionTypeNotRevenusNets(RepartitionVariableSelect selectVariable) {
    }

    @Override
    protected void computeRevenuDeterminantTaux() {
    }

    @Override
    protected void setSelectParticipeAssieteType(RepartitionVariableSelect selectVariable) {
    }
}

