/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.calculimpot.repartition;

import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.transfer.dto.OptionItemDTO;
import ch.dvbern.tax.common.transfer.failure.ApplicationException;
import ch.dvbern.tax.ge.pp.calculimpot.RepartitionCalculAbstract;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.RepartitionCivilite;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.results.RepartitionResults;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.table.RepartitionTable;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.utils.RepartitionColumnSum;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.utils.enums.RepartitionHierarchie;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.utils.enums.RepartitionMode;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.utils.enums.RepartitionType;
import ch.dvbern.tax.ge.pp.calculimpot.repartition.utils.enums.RevenuFortune;
import ch.dvbern.tax.ge.pp.repartition.RepartitionVariable;
import ch.dvbern.tax.ge.pp.repartition.RepartitionVariableSelect;
import ch.dvbern.tax.ge.pp.transfer.dto.CommuneDTO;
import ch.dvbern.tax.ge.pp.utils.ResourceEnum;
import ch.dvbern.tax.ge.pp.utils.SharedUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class RepartitionCalcul
extends RepartitionCalculAbstract {
    public RepartitionHierarchie hierarchie;
    protected String communeOuCantonTaxation;
    protected RepartitionTable table;
    protected int rowIndex = 0;
    protected RepartitionColumnSum columnsSum = new RepartitionColumnSum();
    protected boolean quasiResident = false;

    public RepartitionCalcul(LogicModelItem.ProtectedMap dataModel, DataResource dataResource, RepartitionHierarchie hierarchie) {
        super(dataModel, dataResource);
        this.table = new RepartitionTable(dataResource);
        this.hierarchie = hierarchie;
    }

    public abstract RepartitionTable compute() throws SQLException;

    public abstract RepartitionResults getResults();

    protected abstract void setSelectParticipeAssieteType(RepartitionVariableSelect var1);

    protected abstract String getSelectedKey(RepartitionVariable var1, String var2, String var3, String var4);

    protected long getValueRepartitionMode(RepartitionVariable variable, String key, String keyInternationale, String keyCommunale, String referencedKey, Object cantonOuCommune) {
        return this.getValue(variable, this.getSelectedKey(variable, key, keyInternationale, keyCommunale), referencedKey);
    }

    protected void initKeyTaxation() throws ApplicationException {
        this.communeOuCantonTaxation = this.hierarchie.equals((Object)RepartitionHierarchie.COMMUNAL) ? String.valueOf(this.getValue("Stammdaten.CommuneTaxationEffective")) : String.valueOf(this.getValue("Stammdaten.CantonTaxationEffectif"));
        if (this.communeOuCantonTaxation == null || this.communeOuCantonTaxation.length() <= 0) {
            throw new ApplicationException(SharedUtils.translate("label.recapitulation.repartitionintercommunale.cantontaxation.error", new Object[0]));
        }
    }

    protected void initQuasiResident() {
        String keyValue = String.valueOf(this.getValue("Stammdaten.Declaration.QuasiResident"));
        if (keyValue != null && keyValue.length() > 0 && !"null".equals(keyValue)) {
            this.quasiResident = Boolean.valueOf(keyValue);
        }
    }

    protected void processVariables(RepartitionVariableSelect selectVariable, RevenuFortune revenuOuFortune, RepartitionType typeRepartition) throws SQLException {
        List<RepartitionVariable> variables = selectVariable.getVariable();
        for (RepartitionVariable variable : variables) {
            if (variable.getTable() != null && !"".equals(variable.getTable())) {
                Collection<?> coll = this.getTableRowIndexes(variable.getTable());
                if (coll == null || coll.isEmpty()) continue;
                for (Object aColl : coll) {
                    String key = (String)aColl;
                    String basekey = variable.getTable() + "." + key;
                    this.processVariable(variable, basekey + "." + variable.getKeyCantonale(revenuOuFortune), basekey + "." + variable.getKeyInternationale(revenuOuFortune), basekey + "." + variable.getKeyCommunale(revenuOuFortune), basekey + "." + variable.getCanton(), basekey + "." + variable.getLocalite(), basekey + "." + variable.getReferencedKey(), variable.getModeRepartitionFromType(typeRepartition));
                }
                continue;
            }
            this.processVariable(variable, variable.getKeyCantonale(revenuOuFortune), variable.getKeyInternationale(revenuOuFortune), variable.getKeyCommunale(revenuOuFortune), variable.getCanton(), variable.getLocalite(), variable.getReferencedKey(), variable.getModeRepartitionFromType(typeRepartition));
        }
    }

    private void processVariable(RepartitionVariable variable, String key, String keyInternationale, String keyCommunale, String keyCanton, String keyLocalite, String referencedKey, String modeRepartition) throws SQLException {
        if (key != null && key.length() > 0 || keyInternationale != null && keyInternationale.length() > 0 || keyCommunale != null && keyCommunale.length() > 0) {
            Object cantonOuCommune = this.getCommuneOuCantonTaxation(keyCanton, keyLocalite);
            long value = this.getValueRepartitionMode(variable, key, keyInternationale, keyCommunale, referencedKey, cantonOuCommune);
            String selectedKey = this.getSelectedKey(variable, key, keyInternationale, keyCommunale);
            this.addRow(variable, cantonOuCommune, value, RepartitionMode.fromString(modeRepartition), selectedKey);
        }
    }

    protected Object getCommuneOuCantonTaxation(String keyCanton, String keyLocalite) {
        if (this.hierarchie.equals((Object)RepartitionHierarchie.COMMUNAL)) {
            return this.getCommune(keyCanton, keyLocalite);
        }
        return this.getCanton(keyCanton, keyLocalite);
    }

    private Object getCanton(String keyCanton, String keyLocalite) {
        Object canton = this.getValue(keyCanton);
        if (canton == null) {
            canton = this.getCantonIdentification(String.valueOf(this.getValue(keyLocalite)));
        }
        if (canton == null || "".equals(canton)) {
            canton = this.communeOuCantonTaxation;
        }
        return canton;
    }

    private Object getCommune(String keyCanton, String keyLocalite) {
        Object canton = this.getValue(keyCanton);
        if (canton == null && keyLocalite != null) {
            canton = this.getCantonIdentification(String.valueOf(this.getValue(keyLocalite)));
        }
        if (canton == null) {
            canton = String.valueOf(this.getValue("Stammdaten.CantonTaxationEffectif"));
        }
        if (canton.equals("GE")) {
            Object commune = this.getValue(keyLocalite);
            if (commune == null || "".equals(commune)) {
                commune = this.communeOuCantonTaxation;
            }
            return commune.toString();
        }
        return "EX";
    }

    protected long getValue(RepartitionVariable variable, String key, String referencedKey) {
        long referencedValue;
        long value = this.getItemLongValue(key);
        if (variable.hasReferencedKey() && (referencedValue = this.getItemLongValue(referencedKey)) != 0L) {
            long tmp = value * referencedValue;
            value = Math.round(tmp / 100L);
        }
        if (!variable.isSigne()) {
            value *= -1L;
        }
        return value;
    }

    protected void addTotalToTable(String code, String libelle, RepartitionCivilite civilite, boolean addProRata) {
        Map<Object, Long> sortedColumnsSum = this.sortByValue(this.columnsSum.getColumns());
        Long totalPositif = this.getTotalColumnPositive(sortedColumnsSum);
        Iterator<Map.Entry<Object, Long>> it = sortedColumnsSum.entrySet().iterator();
        double totalPart = 0.0;
        boolean rowAdded = false;
        while (it.hasNext()) {
            Map.Entry<Object, Long> entry = it.next();
            String canton = (String)entry.getKey();
            Long value = entry.getValue();
            double part = 0.0;
            if (addProRata && totalPositif > 0L && value > 0L) {
                part = value.doubleValue() / (double)totalPositif.longValue() * 100.0;
                BigDecimal bd = BigDecimal.valueOf(part);
                bd = bd.setScale(2, 2);
                part = bd.doubleValue();
                if (it.hasNext()) {
                    totalPart += part;
                } else {
                    part = 100.0 - totalPart;
                }
            }
            this.table.addRow(this.rowIndex, code, libelle, civilite, this.columnsSum.getSumAllColumns(), canton, value, part, "");
            rowAdded = true;
        }
        if (rowAdded) {
            ++this.rowIndex;
        }
    }

    protected Map<Object, Long> sortByValue(Map<Object, Long> map) {
        LinkedList<Map.Entry<Object, Long>> list = new LinkedList<Map.Entry<Object, Long>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<Object, Long>>(){

            @Override
            public int compare(Map.Entry<Object, Long> o1, Map.Entry<Object, Long> o2) {
                return o1.getValue().compareTo(o2.getValue());
            }
        });
        LinkedHashMap<Object, Long> result = new LinkedHashMap<Object, Long>();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), (Long)entry.getValue());
        }
        return result;
    }

    protected void addToColumnTotal(Object canton, long value) {
        this.columnsSum.put(canton, value);
    }

    private void addRow(RepartitionVariable variable, Object canton, long value, RepartitionMode modeRepartition, String selectedKey) throws SQLException {
        if (value == 0L) {
            return;
        }
        boolean incrementRowIndex = true;
        if (modeRepartition == null) {
            this.repartitionLocalisationOuDomicile(variable, canton, value, selectedKey);
        } else if (RepartitionMode.LOCALISATION_OU_DOMICILE.equals((Object)modeRepartition)) {
            this.repartitionLocalisationOuDomicile(variable, canton, value, selectedKey);
        } else if (RepartitionMode.ACTIFS_BRUTS_DE_FORTUNE.equals((Object)modeRepartition)) {
            RepartitionColumnSum actifsBrutsLocalises = this.getResults().getActifsBrutsLocalises();
            if (actifsBrutsLocalises.getColumns().isEmpty()) {
                this.addRow(variable, canton, value, RepartitionMode.DOMICILE_PRINCIPAL, selectedKey);
                incrementRowIndex = false;
            } else {
                incrementRowIndex = this.repartitionSumProportional(variable, value, actifsBrutsLocalises, selectedKey);
            }
        } else if (RepartitionMode.FORTUNE_BRUTE.equals((Object)modeRepartition)) {
            incrementRowIndex = this.repartitionSumProportional(variable, value, this.getResults().getFortuneBrute(), selectedKey);
        } else if (RepartitionMode.FORTUNE_NETTE.equals((Object)modeRepartition)) {
            incrementRowIndex = this.repartitionSumProportional(variable, value, this.getResults().getFortuneNette(), selectedKey);
        } else if (RepartitionMode.REVENUS_NETS.equals((Object)modeRepartition)) {
            incrementRowIndex = this.repartitionSumProportional(variable, value, this.getResults().getRevenuNet(), selectedKey);
        } else if (RepartitionMode.REVENUS_ACTIVITE.equals((Object)modeRepartition)) {
            this.reparitionRevenusActivite(variable, value, selectedKey);
        } else if (RepartitionMode.DOMICILE_PRINCIPAL.equals((Object)modeRepartition)) {
            this.repartitionLocalisationOuDomicile(variable, this.communeOuCantonTaxation, value, selectedKey);
        } else {
            throw new ApplicationException(SharedUtils.translate("label.recapitulation.repartition.error.mode", new Object[0]) + " : " + String.valueOf((Object)modeRepartition));
        }
        if (incrementRowIndex) {
            ++this.rowIndex;
        }
    }

    private void reparitionRevenusActivite(RepartitionVariable variable, long value, String selectedKey) throws SQLException {
        RepartitionVariableSelect selectVariable = new RepartitionVariableSelect();
        if (RepartitionCivilite.CJ.equals((Object)variable.getCivilite())) {
            selectVariable.setWhereRubrique("21.00");
        } else if (RepartitionCivilite.CT.equals((Object)variable.getCivilite())) {
            selectVariable.setWhereRubrique("11.00");
        } else {
            throw new ApplicationException(SharedUtils.translate("label.recapitulation.repartition.error.civilite", new Object[0]));
        }
        RepartitionColumnSum revenu = this.getVariablesSum(selectVariable);
        this.repartitionSumProportional(variable, value, revenu, selectedKey);
    }

    protected RepartitionColumnSum getVariablesSum(RepartitionVariableSelect selectVariable) throws SQLException {
        List<RepartitionVariable> variables = selectVariable.getVariable();
        TreeMap<Object, Long> columns = new TreeMap<Object, Long>();
        Long total = 0L;
        for (RepartitionVariable variable : variables) {
            if (variable.getTable() != null && !"".equals(variable.getTable())) {
                total = this.computeMultipleValues(columns, total, variable);
                continue;
            }
            total = this.computeValue(columns, total, variable);
        }
        RepartitionColumnSum result = new RepartitionColumnSum();
        result.setSumAllColumns(total);
        result.setColumns(columns);
        return result;
    }

    private Long computeMultipleValues(Map<Object, Long> columns, Long total, RepartitionVariable variable) {
        Collection<?> coll = this.getTableRowIndexes(variable.getTable());
        if (coll != null && !coll.isEmpty()) {
            for (Object aColl : coll) {
                String key = (String)aColl;
                String basekey = variable.getTable() + "." + key;
                Long valueCanton = this.getValue(variable, basekey + "." + variable.getKeyCantonale(RevenuFortune.REVENU), basekey + "." + variable.getReferencedKey());
                if (valueCanton == 0L) continue;
                total = total + valueCanton;
                Object cantonOuCommuneVariable = this.getCommuneOuCantonTaxation(basekey + "." + variable.getCanton(), basekey + "." + variable.getLocalite());
                if (columns.containsKey(cantonOuCommuneVariable)) {
                    valueCanton = valueCanton + columns.get(cantonOuCommuneVariable);
                }
                columns.put(cantonOuCommuneVariable, valueCanton);
            }
        }
        return total;
    }

    private Long computeValue(Map<Object, Long> columns, Long total, RepartitionVariable variable) {
        Long valueCanton = this.getValue(variable, variable.getKeyCantonale(RevenuFortune.REVENU), variable.getReferencedKey());
        if (valueCanton != 0L) {
            total = total + valueCanton;
            Object cantonOuCommuneVariable = this.getCommuneOuCantonTaxation(variable.getCanton(), variable.getLocalite());
            if (columns.containsKey(cantonOuCommuneVariable)) {
                valueCanton = valueCanton + columns.get(cantonOuCommuneVariable);
            }
            columns.put(cantonOuCommuneVariable, valueCanton);
        }
        return total;
    }

    private void repartitionLocalisationOuDomicile(RepartitionVariable variable, Object canton, long value, String selectedKey) {
        this.table.addRow(this.rowIndex, variable.getCode(), variable.getLibelle(), variable.getCivilite(), value, String.valueOf(canton), value, 0.0, selectedKey);
        this.addToColumnTotal(canton, value);
    }

    private boolean repartitionSumProportional(RepartitionVariable variable, long value, RepartitionColumnSum columnSum, String selectedKey) {
        if (columnSum.getColumns().isEmpty()) {
            return false;
        }
        boolean linesAdded = false;
        Map<Object, Long> sortedColumnsSum = this.sortByValue(columnSum.getColumns());
        Long totalPositif = this.getTotalColumnPositive(sortedColumnsSum);
        if (totalPositif > 0L) {
            Iterator<Map.Entry<Object, Long>> it = sortedColumnsSum.entrySet().iterator();
            long total = 0L;
            double totalPart = 0.0;
            while (it.hasNext()) {
                long valueRepartie;
                Map.Entry<Object, Long> entry = it.next();
                String canton = (String)entry.getKey();
                Long valueSum = entry.getValue();
                if (valueSum <= 0L) continue;
                double part = valueSum.doubleValue() / (double)totalPositif.longValue() * 100.0;
                BigDecimal bd = BigDecimal.valueOf(part);
                bd = bd.setScale(2, 2);
                part = bd.doubleValue();
                if (it.hasNext()) {
                    valueRepartie = Math.round(part / 100.0 * (double)value);
                    total += valueRepartie;
                    totalPart += part;
                } else {
                    valueRepartie = value - total;
                    part = 100.0 - totalPart;
                }
                this.table.addRow(this.rowIndex, variable.getCode(), variable.getLibelle(), variable.getCivilite(), value, canton, valueRepartie, part, selectedKey);
                this.addToColumnTotal(canton, valueRepartie);
                linesAdded = true;
            }
        }
        return linesAdded;
    }

    private Long getTotalColumnPositive(Map<Object, Long> sortedColumnsSum) {
        Long totalPositif = 0L;
        for (Map.Entry<Object, Long> entry : sortedColumnsSum.entrySet()) {
            Long valueCanton = entry.getValue();
            if (valueCanton <= 0L) continue;
            totalPositif = totalPositif + valueCanton;
        }
        return totalPositif;
    }

    private String getCantonIdentification(String code) {
        if (code == null || "".equals(code) || "null".equals(code)) {
            return null;
        }
        CommuneDTO commune = (CommuneDTO)((Object)this.dataResource.get(ResourceEnum.COMMUNES_TOTAL.code(), (Object)code, null).get(code));
        if (commune == null) {
            OptionItemDTO canton = (OptionItemDTO)this.dataResource.get(ResourceEnum.CANTONS_INDEX_SORTED.code(), (Object)code, null).get(code);
            if (canton != null) {
                return String.valueOf(canton.getShortText());
            }
            return null;
        }
        return commune.getCanton();
    }

    protected void addResultBlankLine(String code, String libelle, RepartitionCivilite civilite) {
        if (this.columnsSum.getSumAllColumns() == 0L && this.rowIndex == 0) {
            long zero = 0L;
            this.table.addRow(this.rowIndex, code, libelle, civilite, this.columnsSum.getSumAllColumns(), this.communeOuCantonTaxation, 0L, 0.0, "");
            ++this.rowIndex;
        }
    }

    protected abstract RepartitionType getTypeRepartition();

    protected void computeCommunesNegatives(String code, String msgKey, String codeTotal, String msgKeyTotal) {
        Map<Object, Long> sortedColumnsSum = this.sortByValue(this.columnsSum.getColumns());
        Long totalPositif = this.getTotalColumnPositive(sortedColumnsSum);
        Long totalNegatif = this.getTotalColumnNegative(sortedColumnsSum);
        if (totalNegatif < 0L && totalPositif == 0L) {
            String libelleCompensation = SharedUtils.translate(msgKey, new Object[0]);
            Iterator<Map.Entry<Object, Long>> it = sortedColumnsSum.entrySet().iterator();
            boolean rowAdded = false;
            Long admis = 0L;
            while (it.hasNext()) {
                Map.Entry<Object, Long> entry = it.next();
                String commune = (String)entry.getKey();
                Long value = entry.getValue();
                value = value * -1L;
                admis = admis + value;
                this.table.addRow(this.rowIndex, code, libelleCompensation, RepartitionCivilite.FO, admis, commune, value, 0.0, "");
                this.addToColumnTotal(commune, value);
                rowAdded = true;
            }
            if (rowAdded) {
                ++this.rowIndex;
                this.addTotalToTable(codeTotal, SharedUtils.translate(msgKeyTotal, new Object[0]), RepartitionCivilite.FO, true);
            }
        }
    }

    private Long getTotalColumnNegative(Map<Object, Long> sortedColumnsSum) {
        Long totalNegatif = 0L;
        for (Map.Entry<Object, Long> entry : sortedColumnsSum.entrySet()) {
            Long valueCanton = entry.getValue();
            if (valueCanton >= 0L) continue;
            totalNegatif = totalNegatif + valueCanton;
        }
        return totalNegatif;
    }
}

