/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rdatamatrix;

import com.java4less.rbarcode.common.IBarcodeGenerator;
import com.java4less.rdatamatrix.RDataMatrix;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Properties;

public class RDataMatrixFacade
implements IBarcodeGenerator {
    RDataMatrix bc;

    public RDataMatrixFacade() {
    }

    public RDataMatrixFacade(String code, byte[] codeBinary, boolean processTilde, int moduleSize, int margin, String encoding, String format, Properties properties) {
        this.createBarcode(code, codeBinary, processTilde, moduleSize, margin, encoding, format, properties);
    }

    public RDataMatrix getBarcode() {
        return this.bc;
    }

    public Image createBarcodeImage(String code, byte[] codeBinary, boolean processTilde, int moduleSize, int margin, String encoding, String format, Properties properties) {
        this.createBarcode(code, codeBinary, processTilde, moduleSize, margin, encoding, format, properties);
        return this.createImage();
    }

    public void createBarcode(String code, byte[] codeBinary, boolean processTilde, int moduleSize, int margin, String encoding, String format, Properties properties) {
        this.bc = new RDataMatrix();
        this.bc.code = code;
        if (codeBinary != null && codeBinary.length > 0) {
            this.bc.codeBinary = codeBinary;
        }
        this.bc.processTilde = processTilde;
        this.bc.dotPixels = moduleSize;
        this.bc.margin = margin;
        if (encoding == null) {
            encoding = "";
        }
        if (encoding.toUpperCase().compareTo("ASCII") == 0) {
            this.bc.encoding = RDataMatrix.E_ASCII;
        }
        if (encoding.toUpperCase().compareTo("C40") == 0) {
            this.bc.encoding = RDataMatrix.E_C40;
        }
        if (encoding.toUpperCase().compareTo("TEXT") == 0) {
            this.bc.encoding = RDataMatrix.E_TEXT;
        }
        if (encoding.toUpperCase().compareTo("BASE256") == 0) {
            this.bc.encoding = RDataMatrix.E_BASE256;
        }
        if (encoding.toUpperCase().compareTo("AUTO") == 0) {
            this.bc.encoding = RDataMatrix.E_AUTO;
        }
        if (format == null) {
            format = "";
        }
        this.bc.preferredFormat = -1;
        if (format.toUpperCase().compareTo("C10X10") == 0) {
            this.bc.preferredFormat = 0;
        }
        if (format.toUpperCase().compareTo("C12X12") == 0) {
            this.bc.preferredFormat = 1;
        }
        if (format.toUpperCase().compareTo("C14X14") == 0) {
            this.bc.preferredFormat = 2;
        }
        if (format.toUpperCase().compareTo("C16X16") == 0) {
            this.bc.preferredFormat = 3;
        }
        if (format.toUpperCase().compareTo("C18X18") == 0) {
            this.bc.preferredFormat = 4;
        }
        if (format.toUpperCase().compareTo("C20X20") == 0) {
            this.bc.preferredFormat = 5;
        }
        if (format.toUpperCase().compareTo("C22X22") == 0) {
            this.bc.preferredFormat = 6;
        }
        if (format.toUpperCase().compareTo("C24X24") == 0) {
            this.bc.preferredFormat = 7;
        }
        if (format.toUpperCase().compareTo("C26X26") == 0) {
            this.bc.preferredFormat = 8;
        }
        if (format.toUpperCase().compareTo("C32X32") == 0) {
            this.bc.preferredFormat = 9;
        }
        if (format.toUpperCase().compareTo("C36X36") == 0) {
            this.bc.preferredFormat = 10;
        }
        if (format.toUpperCase().compareTo("C40X40") == 0) {
            this.bc.preferredFormat = 11;
        }
        if (format.toUpperCase().compareTo("C44X44") == 0) {
            this.bc.preferredFormat = 12;
        }
        if (format.toUpperCase().compareTo("C48X48") == 0) {
            this.bc.preferredFormat = 13;
        }
        if (format.toUpperCase().compareTo("C52X52") == 0) {
            this.bc.preferredFormat = 14;
        }
        if (format.toUpperCase().compareTo("C64X64") == 0) {
            this.bc.preferredFormat = 15;
        }
        if (format.toUpperCase().compareTo("C72X72") == 0) {
            this.bc.preferredFormat = 16;
        }
        if (format.toUpperCase().compareTo("C80X80") == 0) {
            this.bc.preferredFormat = 17;
        }
        if (format.toUpperCase().compareTo("C96X96") == 0) {
            this.bc.preferredFormat = 19;
        }
        if (format.toUpperCase().compareTo("C104X104") == 0) {
            this.bc.preferredFormat = 20;
        }
        if (format.toUpperCase().compareTo("C88X88") == 0) {
            this.bc.preferredFormat = 18;
        }
        if (format.toUpperCase().compareTo("C120X120") == 0) {
            this.bc.preferredFormat = 21;
        }
        if (format.toUpperCase().compareTo("C132X132") == 0) {
            this.bc.preferredFormat = 22;
        }
        if (format.toUpperCase().compareTo("C144X144") == 0) {
            this.bc.preferredFormat = 23;
        }
        if (format.toUpperCase().compareTo("C8X18") == 0) {
            this.bc.preferredFormat = 24;
        }
        if (format.toUpperCase().compareTo("C8X32") == 0) {
            this.bc.preferredFormat = 25;
        }
        if (format.toUpperCase().compareTo("C12X26") == 0) {
            this.bc.preferredFormat = 26;
        }
        if (format.toUpperCase().compareTo("C12X36") == 0) {
            this.bc.preferredFormat = 27;
        }
        if (format.toUpperCase().compareTo("C16X36") == 0) {
            this.bc.preferredFormat = 28;
        }
        if (format.toUpperCase().compareTo("C16X48") == 0) {
            this.bc.preferredFormat = 29;
        }
    }

    public Image createImage() {
        BufferedImage barImage = new BufferedImage(500, 500, 1);
        Graphics2D barGraphics = barImage.createGraphics();
        this.bc.setSize(500, 500);
        this.bc.paint(barGraphics);
        int w = (int)(this.bc.getPaintedArea().getWidth() + (double)this.bc.margin);
        int h = (int)(this.bc.getPaintedArea().getHeight() + (double)this.bc.margin);
        barImage = new BufferedImage(w, h, 1);
        this.bc.setSize(w, h);
        barGraphics = barImage.createGraphics();
        this.bc.paint(barGraphics);
        return barImage;
    }

    public void createBarcode(Properties properties) {
        this.createBarcodeFromProperties(properties);
    }

    protected void createBarcodeFromProperties(Properties properties) {
        String format;
        String encoding;
        String margin;
        String processTilde;
        String code = properties.getProperty("code".toUpperCase());
        if (code == null) {
            code = "";
        }
        byte[] codeBinary = (byte[])properties.get("codeBinary".toUpperCase());
        String moduleSize = properties.getProperty("moduleSize".toUpperCase());
        if (moduleSize == null) {
            moduleSize = "3";
        }
        if ((processTilde = properties.getProperty("processTilde".toUpperCase())) == null) {
            processTilde = "false";
        }
        if ((margin = properties.getProperty("margin".toUpperCase())) == null) {
            margin = "0";
        }
        if ((encoding = properties.getProperty("encoding".toUpperCase())) == null) {
            encoding = "AUTO";
        }
        if ((format = properties.getProperty("format".toUpperCase())) == null) {
            format = "C16X16";
        }
        Properties additionalProperties = (Properties)properties.get("additionalProperties");
        this.createBarcode(code, codeBinary, processTilde.equalsIgnoreCase("true"), Integer.parseInt(moduleSize), Integer.parseInt(margin), encoding, format, additionalProperties);
    }

    public void paintBarcode(Graphics g) {
        this.bc.reBuild = true;
        this.bc.paint(g);
    }
}

