/*
 * Decompiled with CFR 0.152.
 */
package au.com.bytecode.opencsv.bean;

import au.com.bytecode.opencsv.CSVWriter;
import au.com.bytecode.opencsv.bean.MappingStrategy;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class BeanToCsv<T> {
    public boolean write(MappingStrategy<T> mappingStrategy, Writer writer, List<?> list) {
        return this.write(mappingStrategy, new CSVWriter(writer), list);
    }

    public boolean write(MappingStrategy<T> mappingStrategy, CSVWriter cSVWriter, List<?> list) {
        if (list == null || list.isEmpty()) {
            return false;
        }
        try {
            cSVWriter.writeNext(this.processHeader(mappingStrategy));
            List<Method> list2 = this.findGetters(mappingStrategy);
            for (Object obj : list) {
                String[] stringArray = this.processObject(list2, obj);
                cSVWriter.writeNext(stringArray);
            }
            return true;
        }
        catch (Exception exception) {
            throw new RuntimeException("Error writing CSV !", exception);
        }
    }

    protected String[] processHeader(MappingStrategy<T> mappingStrategy) throws IntrospectionException {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        PropertyDescriptor propertyDescriptor = mappingStrategy.findDescriptor(n);
        while (propertyDescriptor != null) {
            arrayList.add(propertyDescriptor.getName());
            propertyDescriptor = mappingStrategy.findDescriptor(++n);
        }
        return arrayList.toArray(new String[0]);
    }

    protected String[] processObject(List<Method> list, Object object) throws IntrospectionException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Method method : list) {
            Object object2 = method.invoke(object, (Object[])null);
            if (object2 == null) {
                arrayList.add("null");
                continue;
            }
            arrayList.add(object2.toString());
        }
        return arrayList.toArray(new String[0]);
    }

    private List<Method> findGetters(MappingStrategy<T> mappingStrategy) throws IntrospectionException {
        int n = 0;
        PropertyDescriptor propertyDescriptor = mappingStrategy.findDescriptor(n);
        ArrayList<Method> arrayList = new ArrayList<Method>();
        while (propertyDescriptor != null) {
            arrayList.add(propertyDescriptor.getReadMethod());
            propertyDescriptor = mappingStrategy.findDescriptor(++n);
        }
        return arrayList;
    }
}

