/*
 * Decompiled with CFR 0.152.
 */
package au.com.bytecode.opencsv;

import au.com.bytecode.opencsv.CSVParser;

public class CSVParserBuilder {
    char separator = (char)44;
    char quoteChar = (char)34;
    char escapeChar = (char)92;
    boolean strictQuotes = false;
    boolean ignoreLeadingWhiteSpace = true;
    boolean ignoreQuotations = false;

    CSVParserBuilder withSeparator(char c) {
        this.separator = c;
        return this;
    }

    CSVParserBuilder withQuoteChar(char c) {
        this.quoteChar = c;
        return this;
    }

    CSVParserBuilder withEscapeChar(char c) {
        this.escapeChar = c;
        return this;
    }

    CSVParserBuilder withStrictQuotes(boolean bl) {
        this.strictQuotes = bl;
        return this;
    }

    CSVParserBuilder withIgnoreLeadingWhiteSpace(boolean bl) {
        this.ignoreLeadingWhiteSpace = bl;
        return this;
    }

    CSVParserBuilder withIgnoreQuotations(boolean bl) {
        this.ignoreQuotations = bl;
        return this;
    }

    CSVParser build() {
        return new CSVParser(this.separator, this.quoteChar, this.escapeChar, this.strictQuotes, this.ignoreLeadingWhiteSpace, this.ignoreQuotations);
    }
}

