/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.report;

import ch.ewv.taxstatement.cache.DocumentCache;
import ch.ewv.taxstatement.report.TaxStatementReportOperator;
import ch.ewv.taxstatement.report.TaxStatementReportProperty;
import ch.ewv.taxstatement.report.TaxStatementReportResult;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.xml.xpath.XPathExpressionException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.util.IOUtils;
import org.w3c.dom.Document;

public class TaxStatementReportUtil {
    public static final String FORMAT_DATE = "dd.MM.yyyy";

    public static Double abs(Double a) {
        return a != null && !a.isNaN() && a < 0.0 ? -a.doubleValue() : a;
    }

    public static Integer abs(Integer a) {
        return a != null && a < 0 ? -a.intValue() : a;
    }

    public static Double NaN(Double value) {
        return value != null && !value.isNaN() ? value : null;
    }

    public static Boolean approximately(Double a, Double b) {
        return TaxStatementReportUtil.abs(TaxStatementReportUtil.nvl(a, 0.0)) >= 100.0 && TaxStatementReportUtil.abs(TaxStatementReportUtil.nvl(b, 0.0)) >= 100.0 ? TaxStatementReportUtil.approximately(a, b, 0.0049999999) : TaxStatementReportUtil.approximately(a, b, 4.999999E-4);
    }

    public static Boolean approximately(Double a, Double b, Double t) {
        return TaxStatementReportUtil.approximately(a, b, t, false);
    }

    public static Boolean approximately(Double a, Double b, Double t, Boolean f) {
        Double tolerance = 0.0;
        if (TaxStatementReportProperty.TOLERANCE != null) {
            try {
                if (TaxStatementReportProperty.TOLERANCE.indexOf("%") > 0) {
                    Double percent = Double.parseDouble(TaxStatementReportProperty.TOLERANCE.replace("%", ""));
                    if (a != null && !a.isNaN()) {
                        tolerance = a * percent / 100.0;
                    }
                } else {
                    tolerance = Double.parseDouble(TaxStatementReportProperty.TOLERANCE);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Boolean result = a != null && !a.isNaN() && b != null && !b.isNaN() && f != null && f != false ? Boolean.valueOf(a >= b - t && a <= b + t) : (a != null && !a.isNaN() && b != null && !b.isNaN() ? Boolean.valueOf(a >= b - tolerance && a <= b + tolerance || a >= b - t && a <= b + t) : (a != null && a.isNaN() && b != null && b.isNaN() ? Boolean.valueOf(true) : (a != null && a.isNaN() && b == null ? Boolean.valueOf(true) : (b != null && b.isNaN() && a == null ? Boolean.valueOf(true) : (a == null && b == null ? Boolean.valueOf(true) : Boolean.valueOf(false))))));
        return result;
    }

    public static Boolean nvl(Boolean a, Boolean b) {
        return a != null ? a : b;
    }

    public static Boolean nvl(Boolean a, boolean b) {
        return TaxStatementReportUtil.nvl(a, (Boolean)b);
    }

    public static Date nvl(Date a, Date b) {
        return a != null ? a : b;
    }

    public static Double nvl(Double a, Double b) {
        return a != null && !a.isNaN() ? a : b;
    }

    public static Double nvl(Double a, double b) {
        return TaxStatementReportUtil.nvl(a, (Double)b);
    }

    public static Integer nvl(Integer a, Integer b) {
        return a != null ? a : b;
    }

    public static Integer nvl(Integer a, int b) {
        return TaxStatementReportUtil.nvl(a, (Integer)b);
    }

    public static String nvl(String a, String b) {
        return a != null && a.length() > 0 ? a : b;
    }

    public static Double round(Double a) {
        if (a != null && !a.isNaN() && TaxStatementReportUtil.abs(a) >= 100.0) {
            return a != null && !a.isNaN() ? Double.valueOf(Double.valueOf(Math.round(a * 100.0)) / 100.0) : null;
        }
        return a != null && !a.isNaN() ? Double.valueOf(Double.valueOf(Math.round(a * 1000.0)) / 1000.0) : null;
    }

    public static Double round(Double a, int digits) {
        try {
            if (digits <= 0) {
                return a != null && !a.isNaN() ? Double.valueOf(Math.round(a)) : null;
            }
            if (digits == 1) {
                return a != null && !a.isNaN() ? Double.valueOf(Double.valueOf(Math.round(a * 10.0)) / 10.0) : null;
            }
            if (digits == 2) {
                return a != null && !a.isNaN() ? Double.valueOf(Double.valueOf(Math.round(a * 100.0)) / 100.0) : null;
            }
            if (digits == 3) {
                return a != null && !a.isNaN() ? Double.valueOf(Double.valueOf(Math.round(a * 1000.0)) / 1000.0) : null;
            }
            if (digits == 4) {
                return a != null && !a.isNaN() ? Double.valueOf(Double.valueOf(Math.round(a * 10000.0)) / 10000.0) : null;
            }
            return a != null && !a.isNaN() ? Double.valueOf(Double.valueOf(Math.round(a * 100000.0)) / 100000.0) : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String concat(String a, String b) {
        return TaxStatementReportUtil.concat(a, b, " ");
    }

    public static String concat(String a, String b, String c) {
        if (a != null && a.length() > 0 && b != null && b.length() > 0) {
            return a + c + b;
        }
        if (a != null && a.length() > 0) {
            return a;
        }
        return b;
    }

    public static HashMap<String, Double> getDARate() throws IOException {
        HashMap<String, Double> rates = new HashMap<String, Double>();
        BufferedReader br = new BufferedReader(new InputStreamReader(TaxStatementReportUtil.class.getResourceAsStream("/resources/darate.csv")));
        String line = null;
        while ((line = br.readLine()) != null) {
            String[] str = line.split(";");
            if (str.length < 7) continue;
            try {
                rates.put((str[0] != null ? str[0] : "") + "-" + (str[1] != null ? str[1] : "") + "-" + (str[2] != null ? str[2] : "") + "-" + (str[3] != null ? str[3] : ""), Double.parseDouble(str[4]));
            }
            catch (Exception exception) {}
        }
        return rates;
    }

    public static Double getDARate(HashMap<String, Double> rates, Integer year, String country, String category, String securityType) {
        return rates != null ? rates.get((year != null ? year : "") + "-" + (country != null ? country : "") + "-" + (category != null ? category : "") + "-" + (securityType != null && securityType.equals("SHARE.BONUS") ? securityType : "")) : null;
    }

    public static Double getDARate(HashMap<String, Double> rates, Date date, String country, String category, String securityType) {
        Integer year = date != null ? Integer.valueOf(Integer.parseInt(new SimpleDateFormat("yyyy").format(date))) : null;
        return TaxStatementReportUtil.getDARate(rates, year, country, category, securityType);
    }

    public static HashMap<String, Double> getDARateNonRecoverable() throws IOException {
        HashMap<String, Double> rates = new HashMap<String, Double>();
        BufferedReader br = new BufferedReader(new InputStreamReader(TaxStatementReportUtil.class.getResourceAsStream("/resources/darate.csv")));
        String line = null;
        while ((line = br.readLine()) != null) {
            String[] str = line.split(";");
            if (str.length < 7) continue;
            try {
                rates.put((str[0] != null ? str[0] : "") + "-" + (str[1] != null ? str[1] : "") + "-" + (str[2] != null ? str[2] : "") + "-" + (str[3] != null ? str[3] : "") + "--", Double.parseDouble(str[6]));
            }
            catch (Exception exception) {}
        }
        return rates;
    }

    public static Double getDARateNonRecoverable(HashMap<String, Double> rates, Integer year, String country, String category, String securityType) {
        return rates != null ? rates.get((year != null ? year : "") + "-" + (country != null ? country : "") + "-" + (category != null ? category : "") + "-" + (securityType != null && securityType.equals("SHARE.BONUS") ? securityType : "") + "--") : null;
    }

    public static Double getDARateNonRecoverable(HashMap<String, Double> rates, Date date, String country, String category, String securityType) {
        Integer year = date != null ? Integer.valueOf(Integer.parseInt(new SimpleDateFormat("yyyy").format(date))) : null;
        return TaxStatementReportUtil.getDARateNonRecoverable(rates, year, country, category, securityType);
    }

    public static HashMap<String, Double> getDARateRelease() throws IOException {
        HashMap<String, Double> rates = new HashMap<String, Double>();
        BufferedReader br = new BufferedReader(new InputStreamReader(TaxStatementReportUtil.class.getResourceAsStream("/resources/darate.csv")));
        String line = null;
        while ((line = br.readLine()) != null) {
            String[] str = line.split(";");
            if (str.length < 7) continue;
            try {
                rates.put((str[0] != null ? str[0] : "") + "-" + (str[1] != null ? str[1] : "") + "-" + (str[2] != null ? str[2] : "") + "-" + (str[3] != null ? str[3] : "") + "-", Double.parseDouble(str[5]));
            }
            catch (Exception exception) {}
        }
        return rates;
    }

    public static Double getDARateRelease(HashMap<String, Double> rates, Integer year, String country, String category, String securityType) {
        return rates != null ? rates.get((year != null ? year : "") + "-" + (country != null ? country : "") + "-" + (category != null ? category : "") + "-" + (securityType != null && securityType.equals("SHARE.BONUS") ? securityType : "") + "-") : null;
    }

    public static Double getDARateRelease(HashMap<String, Double> rates, Date date, String country, String category, String securityType) {
        Integer year = date != null ? Integer.valueOf(Integer.parseInt(new SimpleDateFormat("yyyy").format(date))) : null;
        return TaxStatementReportUtil.getDARateRelease(rates, year, country, category, securityType);
    }

    public static String getVersion() throws IOException {
        Manifest mf = new Manifest(TaxStatementReportUtil.class.getResourceAsStream("/META-INF/MANIFEST.MF"));
        Attributes atts = mf.getMainAttributes();
        return atts.getValue("Specification-Version") + "-" + atts.getValue("Implementation-Version");
    }

    public static Properties getLanguage(String language) throws IOException {
        Properties lang = new Properties();
        lang.load(TaxStatementReportUtil.class.getResourceAsStream("/resources/report-messages_" + language + ".properties"));
        return lang;
    }

    public static String getText(Properties lang, String key) {
        return TaxStatementReportUtil.getText(lang, key, "[" + key + "]");
    }

    public static String getText(Properties lang, String[] keys) {
        String text = null;
        for (String key : keys) {
            text = text != null ? TaxStatementReportUtil.concat(text, TaxStatementReportUtil.getText(lang, key, "[" + key + "]")) : TaxStatementReportUtil.getText(lang, key, "[" + key + "]");
        }
        return text;
    }

    public static String getText(Properties lang, String key, String d) {
        String text = d;
        try {
            text = lang.getProperty(key, d);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return text;
    }

    public static int getCount(Document doc, String exp) throws XPathExpressionException {
        return DocumentCache.count(doc, exp);
    }

    public static String getValue(Document doc, String exp) throws XPathExpressionException {
        return TaxStatementReportUtil.getValue(doc, exp, false);
    }

    public static String getValue(Document doc, String exp, boolean empty) throws XPathExpressionException {
        String value = DocumentCache.get(doc, exp, empty);
        return value != null && (value.length() > 0 || empty) ? value : null;
    }

    public static Boolean getValueBoolean(Document doc, String exp) throws ParseException, XPathExpressionException {
        String value = TaxStatementReportUtil.getValue(doc, exp);
        Boolean b = null;
        if (value != null) {
            if (value.toLowerCase().equals("true") || value.equals("1")) {
                b = Boolean.TRUE;
            } else if (value.toLowerCase().equals("false") || value.equals("0")) {
                b = Boolean.FALSE;
            }
        }
        return b;
    }

    public static Boolean getValueBoolean(Document doc, String exp, boolean d) throws ParseException, XPathExpressionException {
        Boolean b = TaxStatementReportUtil.getValueBoolean(doc, exp);
        return b != null ? b : Boolean.valueOf(d);
    }

    public static Date getValueDate(Document doc, String exp) throws ParseException, XPathExpressionException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String value = TaxStatementReportUtil.getValue(doc, exp);
        return value != null && value.length() > 0 ? sdf.parse(value) : null;
    }

    public static String getValueDate(Document doc, String exp, String format) throws ParseException, XPathExpressionException {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date value = TaxStatementReportUtil.getValueDate(doc, exp);
        return value != null ? sdf.format(value) : null;
    }

    public static Date getValueDateTime(Document doc, String exp) throws ParseException, XPathExpressionException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        String value = TaxStatementReportUtil.getValue(doc, exp);
        return value != null && value.length() > 0 ? sdf.parse(value) : null;
    }

    public static String getValueDateTime(Document doc, String exp, String format) throws ParseException, XPathExpressionException {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date value = TaxStatementReportUtil.getValueDateTime(doc, exp);
        return value != null ? sdf.format(value) : null;
    }

    public static Integer getValueInteger(Document doc, String exp) throws XPathExpressionException {
        String value = TaxStatementReportUtil.getValue(doc, exp);
        return value != null && value.length() > 0 ? Integer.valueOf(value) : null;
    }

    public static Integer getValueInteger(Document doc, String exp, int i) throws XPathExpressionException {
        Integer value = TaxStatementReportUtil.getValueInteger(doc, exp);
        return value != null ? value : Integer.valueOf(i);
    }

    public static String getValueInteger(Document doc, String exp, String format) throws NumberFormatException, XPathExpressionException {
        DecimalFormat df = new DecimalFormat(format);
        Integer value = TaxStatementReportUtil.getValueInteger(doc, exp);
        return value != null ? df.format(value) : null;
    }

    public static String getValueInteger(Document doc, String exp, String format, int i) throws NumberFormatException, XPathExpressionException {
        DecimalFormat df = new DecimalFormat(format);
        Integer value = TaxStatementReportUtil.getValueInteger(doc, exp);
        return value != null ? df.format(value) : df.format((Object)i);
    }

    public static Double getValueNumber(Document doc, String exp) throws XPathExpressionException {
        String value = TaxStatementReportUtil.getValue(doc, exp);
        return TaxStatementReportUtil.NaN(value != null && value.length() > 0 ? Double.valueOf(value) : null);
    }

    public static Double getValueNumber(Document doc, String exp, double d) throws XPathExpressionException {
        Double value = TaxStatementReportUtil.getValueNumber(doc, exp);
        return TaxStatementReportUtil.NaN(value != null ? value : Double.valueOf(d));
    }

    public static String getValueNumber(Document doc, String exp, String format) throws NumberFormatException, XPathExpressionException {
        DecimalFormat df = new DecimalFormat(format);
        Double value = TaxStatementReportUtil.getValueNumber(doc, exp);
        return value != null ? df.format(value) : null;
    }

    public static String getValueNumber(Document doc, String exp, String format, double d) throws NumberFormatException, XPathExpressionException {
        DecimalFormat df = new DecimalFormat(format);
        Double value = TaxStatementReportUtil.getValueNumber(doc, exp);
        return value != null ? df.format(value) : df.format((Object)d);
    }

    public static void addSheet(Workbook wb, String name) {
        Sheet sheet = wb.createSheet(name);
    }

    public static Sheet getSheet(Workbook wb) {
        return wb.getSheetAt(wb.getNumberOfSheets() - 1);
    }

    public static Sheet getSheet(Workbook wb, String name) {
        return wb != null ? wb.getSheet(name) : null;
    }

    public static int getNumberOfRows(Sheet sheet) {
        int rows = sheet.getLastRowNum();
        if (rows == 0) {
            if (sheet.getRow(0) != null) {
                rows = 1;
            }
        } else {
            ++rows;
        }
        return rows;
    }

    public static int getNumberOfRows(Workbook wb) {
        return TaxStatementReportUtil.getNumberOfRows(wb.getSheetAt(wb.getNumberOfSheets() - 1));
    }

    public static short getNumberOfCells(Row row) {
        short cells = 0;
        try {
            cells = row.getLastCellNum();
            if (cells < 0) {
                cells = 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cells;
    }

    private static short getNumberOfCells(Sheet sheet) {
        return TaxStatementReportUtil.getNumberOfCells(sheet.getRow(sheet.getLastRowNum()));
    }

    public static short getNumberOfCells(Workbook wb) {
        return TaxStatementReportUtil.getNumberOfCells(wb.getSheetAt(wb.getNumberOfSheets() - 1));
    }

    public static void addRow(Sheet sheet) {
        Row row = sheet.createRow(TaxStatementReportUtil.getNumberOfRows(sheet));
    }

    public static void addRow(Workbook wb) {
        int sheet = wb.getNumberOfSheets() - 1;
        TaxStatementReportUtil.addRow(wb.getSheetAt(sheet));
    }

    public static void setHeight(Sheet sheet, int height) {
        sheet.getRow(sheet.getLastRowNum()).setHeight((short)(256 * height));
    }

    public static void setHeight(Sheet sheet, double height) {
        sheet.getRow(sheet.getLastRowNum()).setHeight((short)(256.0 * height));
    }

    public static void setHeight(Workbook wb, int height) {
        TaxStatementReportUtil.setHeight(wb.getSheetAt(wb.getNumberOfSheets() - 1), height);
    }

    public static void setHeight(Workbook wb, double height) {
        TaxStatementReportUtil.setHeight(wb.getSheetAt(wb.getNumberOfSheets() - 1), height);
    }

    public static Cell addCell(Row row) {
        short cell = row.getLastCellNum();
        if (cell < 0) {
            cell = 0;
        }
        return row.createCell((int)cell);
    }

    public static void addCell(Row row, CellStyle cs, Date value) {
        Cell ce = TaxStatementReportUtil.addCell(row);
        try {
            ce.setCellStyle(cs);
            if (value != null) {
                ce.setCellValue(value);
                if (!DateUtil.isCellDateFormatted((Cell)ce)) {
                    CellStyle style = row.getSheet().getWorkbook().createCellStyle();
                    short df = row.getSheet().getWorkbook().createDataFormat().getFormat(FORMAT_DATE);
                    style.cloneStyleFrom(ce.getCellStyle());
                    style.setDataFormat(df);
                    ce.setCellStyle(style);
                }
            } else {
                ce.setCellValue(new String());
            }
        }
        catch (Exception e) {
            ce.setCellValue(new String());
        }
    }

    public static void addCell(Row row, CellStyle cs, Double value) {
        Cell ce = TaxStatementReportUtil.addCell(row);
        try {
            ce.setCellStyle(cs);
            if (value != null) {
                ce.setCellValue(value.doubleValue());
            } else {
                ce.setCellValue(new String());
            }
        }
        catch (Exception e) {
            ce.setCellValue(new String());
        }
    }

    public static void addCell(Row row, CellStyle cs, String value) {
        Cell ce = TaxStatementReportUtil.addCell(row);
        try {
            ce.setCellStyle(cs);
            if (value != null) {
                ce.setCellValue(value);
            } else {
                ce.setCellValue(new String());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void addCell(Row row, CellStyle cs, TaxStatementReportOperator value) {
        TaxStatementReportUtil.addCell(row, cs, value != null ? value.toString() : new String());
    }

    public static void addCell(Row row, CellStyle cs, TaxStatementReportResult value) {
        TaxStatementReportUtil.addCell(row, cs, value != null ? value.toString() : new String());
    }

    public static void addCell(Sheet sheet, CellStyle cs, Date value) {
        TaxStatementReportUtil.addCell(sheet.getRow(sheet.getLastRowNum()), cs, value);
    }

    public static void addCell(Sheet sheet, CellStyle cs, Double value) {
        TaxStatementReportUtil.addCell(sheet.getRow(sheet.getLastRowNum()), cs, value);
    }

    public static void addCell(Sheet sheet, CellStyle cs, String value) {
        TaxStatementReportUtil.addCell(sheet.getRow(sheet.getLastRowNum()), cs, value);
    }

    public static void addCell(Sheet sheet, CellStyle cs, TaxStatementReportOperator value) {
        TaxStatementReportUtil.addCell(sheet, cs, value != null ? value.toString() : new String());
    }

    public static void addCell(Sheet sheet, CellStyle cs, TaxStatementReportResult value) {
        TaxStatementReportUtil.addCell(sheet, cs, value != null ? value.toString() : new String());
    }

    public static void addCell(Workbook wb, CellStyle cs, Date value) {
        TaxStatementReportUtil.addCell(wb.getSheetAt(wb.getNumberOfSheets() - 1), cs, value);
    }

    public static void addCell(Workbook wb, CellStyle cs, Double value) {
        TaxStatementReportUtil.addCell(wb.getSheetAt(wb.getNumberOfSheets() - 1), cs, value);
    }

    public static void addCell(Workbook wb, CellStyle cs, Integer value) {
        TaxStatementReportUtil.addCell(wb, cs, (Double)((Object)value));
    }

    public static void addCell(Workbook wb, CellStyle cs, String value) {
        TaxStatementReportUtil.addCell(wb.getSheetAt(wb.getNumberOfSheets() - 1), cs, value);
    }

    public static void addCell(Workbook wb, CellStyle cs, TaxStatementReportOperator value) {
        TaxStatementReportUtil.addCell(wb, cs, value != null ? value.toString() : new String());
    }

    public static void addCell(Workbook wb, CellStyle cs, TaxStatementReportResult value) {
        TaxStatementReportUtil.addCell(wb, cs, value != null ? value.toString() : new String());
    }

    public static void addCell(Row row, CellStyle cs) {
        TaxStatementReportUtil.addCell(row, cs, new String());
    }

    public static void addCell(Sheet sheet, CellStyle cs) {
        TaxStatementReportUtil.addCell(sheet, cs, new String());
    }

    public static void addCell(Workbook wb, CellStyle cs) {
        TaxStatementReportUtil.addCell(wb, cs, new String());
    }

    public static Cell getCell(Row row) {
        return row.getCell(row.getLastCellNum() - 1);
    }

    public static Cell getCell(Sheet sheet) {
        return TaxStatementReportUtil.getCell(sheet.getRow(sheet.getLastRowNum()));
    }

    public static Cell getCell(Workbook wb) {
        return TaxStatementReportUtil.getCell(wb.getSheetAt(wb.getNumberOfSheets() - 1));
    }

    public static void setHidden(Row row, boolean hidden) {
        row.getSheet().setColumnHidden(TaxStatementReportUtil.getNumberOfCells(row) - 1, hidden);
    }

    public static void setHidden(Sheet sheet, boolean hidden) {
        sheet.setColumnHidden(TaxStatementReportUtil.getNumberOfCells(sheet) - 1, hidden);
    }

    public static void setHidden(Workbook wb, boolean hidden) {
        TaxStatementReportUtil.setHidden(wb.getSheetAt(wb.getNumberOfSheets() - 1), hidden);
    }

    public static void setWidth(Row row, int width) {
        row.getSheet().setColumnWidth(TaxStatementReportUtil.getNumberOfCells(row) - 1, 256 * width);
    }

    public static void setWidth(Sheet sheet, int width) {
        sheet.setColumnWidth(TaxStatementReportUtil.getNumberOfCells(sheet) - 1, 256 * width);
    }

    public static void setWidth(Workbook wb, int width) {
        TaxStatementReportUtil.setWidth(wb.getSheetAt(wb.getNumberOfSheets() - 1), width);
    }

    public static void addImage(Workbook wb, String name) throws IOException {
        TaxStatementReportUtil.addImage(wb, name, 1, 1);
    }

    public static void addImage(Workbook wb, String name, int columns, int rows) throws IOException {
        InputStream is = TaxStatementReportUtil.class.getResourceAsStream("/resources/" + name);
        if (is == null) {
            is = TaxStatementReportUtil.class.getResourceAsStream("/images/" + name);
        }
        byte[] bytes = IOUtils.toByteArray((InputStream)is);
        int pidx = wb.addPicture(bytes, 5);
        is.close();
        CreationHelper helper = wb.getCreationHelper();
        Drawing drawing = TaxStatementReportUtil.getSheet(wb).createDrawingPatriarch();
        ClientAnchor anchor = helper.createClientAnchor();
        Sheet sheet = wb.getSheetAt(wb.getNumberOfSheets() - 1);
        Row row = sheet.getRow(sheet.getLastRowNum());
        anchor.setCol1(row.getLastCellNum() - 1);
        anchor.setRow1(sheet.getLastRowNum());
        anchor.setCol2(row.getLastCellNum() + columns - 1);
        anchor.setRow2(sheet.getLastRowNum() + rows);
        Picture pict = drawing.createPicture(anchor, pidx);
        pict.resize(1.0, 1.0);
    }
}

