/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.report;

import ch.ewv.taxstatement.report.TaxStatementReportCase;
import ch.ewv.taxstatement.report.TaxStatementReportFormula;
import ch.ewv.taxstatement.report.TaxStatementReportResult;
import ch.ewv.taxstatement.report.TaxStatementReportResultCase;
import ch.ewv.taxstatement.report.TaxStatementReportResultStep;
import ch.ewv.taxstatement.report.TaxStatementReportSecurityData;
import java.io.IOException;
import java.text.ParseException;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class TaxStatementReportTaxStatementCase12
extends TaxStatementReportCase {
    public static final Double LIMIT = 50.0;

    protected TaxStatementReportResultStep execute01(Document doc, Properties lang, TaxStatementReportFormula formula) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeExist(1, this.getStepDescription(lang, 1), this.getStepCondition(lang, 1), false, TaxStatementReportSecurityData.getTotalTaxValue(doc));
    }

    protected TaxStatementReportResultStep execute02(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeCount(2, this.getStepDescription(lang, 2), this.getStepCondition(lang, 2), filter, TaxStatementReportSecurityData.getSecurityCount(doc));
    }

    protected TaxStatementReportResultStep execute03(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeTotal(3, this.getStepDescription(lang, 3), this.getStepCondition(lang, 3), filter, TaxStatementReportSecurityData.getTotalLumpSumTaxCredit(doc));
    }

    protected TaxStatementReportResultStep execute04(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeEqual(4, this.getStepDescription(lang, 4), this.getStepCondition(lang, 4), filter, TaxStatementReportSecurityData.getTotalLumpSumTaxCredit(doc), formula.calcTotalSecurityLumpSumTaxCredit(), formula, LIMIT);
    }

    protected TaxStatementReportResultStep execute05(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeRound(5, this.getStepDescription(lang, 5), this.getStepCondition(lang, 5), filter, TaxStatementReportSecurityData.getTotalLumpSumTaxCredit(doc));
    }

    protected TaxStatementReportResultStep execute06(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeTotal(6, this.getStepDescription(lang, 6), this.getStepCondition(lang, 6), filter, TaxStatementReportSecurityData.getTotalNonRecoverableTax(doc));
    }

    protected TaxStatementReportResultStep execute07(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeEqual(7, this.getStepDescription(lang, 7), this.getStepCondition(lang, 7), filter, TaxStatementReportSecurityData.getTotalNonRecoverableTax(doc), formula.calcTotalSecurityNonRecoverableTax(), formula);
    }

    protected TaxStatementReportResultStep execute08(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeRound(8, this.getStepDescription(lang, 8), this.getStepCondition(lang, 8), filter, TaxStatementReportSecurityData.getTotalNonRecoverableTax(doc));
    }

    protected TaxStatementReportResultStep execute09(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeTotal(9, this.getStepDescription(lang, 9), this.getStepCondition(lang, 9), filter, TaxStatementReportSecurityData.getTotalAdditionalWithHoldingTaxUSA(doc));
    }

    protected TaxStatementReportResultStep execute10(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeEqual(10, this.getStepDescription(lang, 10), this.getStepCondition(lang, 10), filter, TaxStatementReportSecurityData.getTotalAdditionalWithHoldingTaxUSA(doc), formula.calcTotalSecurityAdditionalWithHoldingTaxUSA(), formula);
    }

    protected TaxStatementReportResultStep execute11(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeRound(11, this.getStepDescription(lang, 11), this.getStepCondition(lang, 11), filter, TaxStatementReportSecurityData.getTotalAdditionalWithHoldingTaxUSA(doc));
    }

    @Override
    public TaxStatementReportResultCase execute(Document doc, byte[] xml, Properties lang, TaxStatementReportFormula formula) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultCase cs = new TaxStatementReportResultCase(this.getCaseGroup(), this.getCaseId(), this.getCaseGroup(lang), this.getCaseName(lang), this.getCaseDescription(lang));
        TaxStatementReportResult[][] ok = new TaxStatementReportResult[][]{new TaxStatementReportResult[0], {TaxStatementReportResult.ERROR, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, TaxStatementReportResult.ERROR, TaxStatementReportResult.OK}, {null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, TaxStatementReportResult.ERROR, TaxStatementReportResult.OK}, {null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, TaxStatementReportResult.ERROR, TaxStatementReportResult.OK}, {null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, TaxStatementReportResult.ERROR, TaxStatementReportResult.OK}, {null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}};
        cs.addStepResultOptional(ok[1], this.execute01(doc, lang, formula));
        cs.addStepResultOptional(ok[2], this.execute02(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getSecurityCount(doc) > 0));
        cs.addStepResultMandatory(ok[3], this.execute03(doc, lang, formula, TaxStatementReportSecurityData.getTotalLumpSumTaxCredit(doc) != null));
        cs.addStepResultMandatory(ok[4], this.execute04(doc, lang, formula, TaxStatementReportSecurityData.getSecurityCount(doc) > 0));
        cs.addStepResultMandatory(ok[5], this.execute05(doc, lang, formula, TaxStatementReportSecurityData.getTotalLumpSumTaxCredit(doc) != null));
        cs.addStepResultMandatory(ok[6], this.execute06(doc, lang, formula, TaxStatementReportSecurityData.getTotalNonRecoverableTax(doc) != null));
        cs.addStepResultMandatory(ok[7], this.execute07(doc, lang, formula, TaxStatementReportSecurityData.getSecurityCount(doc) > 0));
        cs.addStepResultMandatory(ok[8], this.execute08(doc, lang, formula, TaxStatementReportSecurityData.getTotalNonRecoverableTax(doc) != null));
        cs.addStepResultMandatory(ok[9], this.execute09(doc, lang, formula, TaxStatementReportSecurityData.getTotalAdditionalWithHoldingTaxUSA(doc) != null));
        cs.addStepResultMandatory(ok[10], this.execute10(doc, lang, formula, TaxStatementReportSecurityData.getSecurityCount(doc) > 0));
        cs.addStepResultMandatory(ok[11], this.execute11(doc, lang, formula, TaxStatementReportSecurityData.getTotalAdditionalWithHoldingTaxUSA(doc) != null));
        return cs;
    }

    public TaxStatementReportTaxStatementCase12() {
        super("TAX_STATEMENT_CASE", 12);
    }
}

