/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.report;

import ch.ewv.taxstatement.report.TaxStatementReportUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;

public class TaxStatementReportSecurityData {
    public static Double getTotalTaxValue(Document doc) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/@totalTaxValue");
    }

    public static Double getTotalGrossRevenueA(Document doc) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/@totalGrossRevenueA");
    }

    public static Double getTotalGrossRevenueACanton(Document doc) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/@totalGrossRevenueACanton");
    }

    public static Double getTotalGrossRevenueB(Document doc) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/@totalGrossRevenueB");
    }

    public static Double getTotalGrossRevenueBCanton(Document doc) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/@totalGrossRevenueBCanton");
    }

    public static Double getTotalGrossRevenueConversion(Document doc) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/@totalGrossRevenueConversion");
    }

    public static Double getTotalGrossRevenueIUP(Document doc) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/@totalGrossRevenueIUP");
    }

    public static Double getTotalWithHoldingTaxClaim(Document doc) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/@totalWithHoldingTaxClaim");
    }

    public static Double getTotalLumpSumTaxCredit(Document doc) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/@totalLumpSumTaxCredit");
    }

    public static Double getTotalNonRecoverableTax(Document doc) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/@totalNonRecoverableTax");
    }

    public static Double getTotalAdditionalWithHoldingTaxUSA(Document doc) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/@totalAdditionalWithHoldingTaxUSA");
    }

    public static int getDepotCount(Document doc) throws XPathExpressionException {
        return TaxStatementReportUtil.getCount(doc, "count(/taxStatement/listOfSecurities/depot)");
    }

    public static String getDepotDepotNumber(Document doc, int depot) throws ParseException, XPathExpressionException {
        return TaxStatementReportUtil.getValue(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/@depotNumber");
    }

    public static int getSecurityCount(Document doc) throws XPathExpressionException {
        int count = 0;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            count += TaxStatementReportSecurityData.getSecurityCount(doc, i);
        }
        return count;
    }

    public static int getSecurityCount(Document doc, int depot) throws XPathExpressionException {
        return TaxStatementReportUtil.getCount(doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security)");
    }

    public static Boolean getSecurityBFP(Document doc, int depot, int security) throws ParseException, XPathExpressionException {
        return TaxStatementReportUtil.getValueBoolean(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@bfp", false);
    }

    public static String getSecurityCategory(Document doc, int depot, int security) throws XPathExpressionException {
        return TaxStatementReportUtil.getValue(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@securityCategory");
    }

    public static String getSecurityCategory(Document doc, String valorNumber, String isin) throws XPathExpressionException {
        String category = null;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 0; i < depots && category == null; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i + 1);
            for (int j = 0; j < securities && category == null; ++j) {
                if (valorNumber != null && TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j) != null && valorNumber.equals(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j))) {
                    category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                    continue;
                }
                if (isin == null || TaxStatementReportSecurityData.getSecurityISIN(doc, i, j) == null || !isin.equals(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j))) continue;
                category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
            }
        }
        return category;
    }

    public static boolean getSecurityCity(Document doc) throws XPathExpressionException {
        boolean value = true;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && value; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && value; ++j) {
                String city = TaxStatementReportSecurityData.getSecurityCity(doc, i, j);
                if (city != null) continue;
                value = false;
            }
        }
        return value;
    }

    public static String getSecurityCity(Document doc, int depot, int security) throws XPathExpressionException {
        return TaxStatementReportUtil.getValue(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@city");
    }

    public static String getSecurityCountry(Document doc, int depot, int security) throws XPathExpressionException {
        return TaxStatementReportUtil.getValue(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@country");
    }

    public static boolean getSecurityCountryUSA(Document doc) throws XPathExpressionException {
        boolean value = false;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && !value; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && !value; ++j) {
                String country = TaxStatementReportSecurityData.getSecurityCountry(doc, i, j);
                if (country == null || !country.equals("US")) continue;
                value = true;
            }
        }
        return value;
    }

    public static String getSecurityCurrency(Document doc, int depot, int security) throws XPathExpressionException {
        return TaxStatementReportUtil.getValue(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@currency");
    }

    public static boolean getSecurityInterestRate(Document doc) throws XPathExpressionException {
        boolean value = true;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && value; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && value; ++j) {
                Double interestRate = TaxStatementReportSecurityData.getSecurityInterestRate(doc, i, j);
                if (interestRate != null) continue;
                value = false;
            }
        }
        return value;
    }

    public static Double getSecurityInterestRate(Document doc, int depot, int security) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@interestRate");
    }

    public static boolean getSecurityISIN(Document doc) throws XPathExpressionException {
        boolean value = true;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && value; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && value; ++j) {
                String isin = TaxStatementReportSecurityData.getSecurityISIN(doc, i, j);
                if (isin != null && isin.length() == 12) continue;
                value = false;
            }
        }
        return value;
    }

    public static String getSecurityISIN(Document doc, int depot, int security) throws XPathExpressionException {
        return TaxStatementReportUtil.getValue(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@isin");
    }

    public static boolean getSecurityIssueDate(Document doc) throws ParseException, XPathExpressionException {
        boolean value = true;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && value; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && value; ++j) {
                Date issueDate = TaxStatementReportSecurityData.getSecurityIssueDate(doc, i, j);
                if (issueDate != null) continue;
                value = false;
            }
        }
        return value;
    }

    public static Date getSecurityIssueDate(Document doc, int depot, int security) throws ParseException, XPathExpressionException {
        return TaxStatementReportUtil.getValueDate(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@issueDate");
    }

    public static Date getSecurityIssueDate(Document doc, String valorNumber, String isin) throws ParseException, XPathExpressionException {
        Date issueDate = null;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 0; i < depots && issueDate == null; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i + 1);
            for (int j = 0; j < securities && issueDate == null; ++j) {
                if (valorNumber != null && TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j) != null && valorNumber.equals(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j))) {
                    issueDate = TaxStatementReportSecurityData.getSecurityIssueDate(doc, i, j);
                    continue;
                }
                if (isin == null || TaxStatementReportSecurityData.getSecurityISIN(doc, i, j) == null || !isin.equals(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j))) continue;
                issueDate = TaxStatementReportSecurityData.getSecurityIssueDate(doc, i, j);
            }
        }
        return issueDate;
    }

    public static boolean getSecurityIssuePrice(Document doc) throws XPathExpressionException {
        boolean value = true;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && value; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && value; ++j) {
                Double issuePrice = TaxStatementReportSecurityData.getSecurityIssuePrice(doc, i, j);
                if (issuePrice != null) continue;
                value = false;
            }
        }
        return value;
    }

    public static Double getSecurityIssuePrice(Document doc, int depot, int security) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@issuePrice");
    }

    public static Boolean getSecurityIUP(Document doc, int depot, int security) throws ParseException, XPathExpressionException {
        return TaxStatementReportUtil.getValueBoolean(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@iup", false);
    }

    public static String getSecurityName(Document doc, int depot, int security) throws XPathExpressionException {
        return TaxStatementReportUtil.getValue(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@securityName");
    }

    public static boolean getSecurityNominalValue(Document doc) throws XPathExpressionException {
        boolean value = true;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && value; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && value; ++j) {
                Double nominalValue = TaxStatementReportSecurityData.getSecurityNominalValue(doc, i, j);
                if (nominalValue != null) continue;
                value = false;
            }
        }
        return value;
    }

    public static Double getSecurityNominalValue(Document doc, int depot, int security) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@nominalValue");
    }

    public static String getSecurityPositionId(Document doc, int depot, int security) throws XPathExpressionException {
        return TaxStatementReportUtil.getValue(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@positionId");
    }

    public static String getSecurityQuotationType(Document doc, int depot, int security) throws XPathExpressionException {
        return TaxStatementReportUtil.getValue(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@quotationType");
    }

    public static boolean getSecurityRedemptionDate(Document doc) throws ParseException, XPathExpressionException {
        boolean value = true;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && value; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && value; ++j) {
                Date redemptionDate = TaxStatementReportSecurityData.getSecurityRedemptionDate(doc, i, j);
                if (redemptionDate != null) continue;
                value = false;
            }
        }
        return value;
    }

    public static Date getSecurityRedemptionDate(Document doc, int depot, int security) throws ParseException, XPathExpressionException {
        return TaxStatementReportUtil.getValueDate(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@redemptionDate");
    }

    public static Date getSecurityRedemptionDate(Document doc, String valorNumber, String isin) throws ParseException, XPathExpressionException {
        Date redemptionDate = null;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 0; i < depots && redemptionDate == null; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i + 1);
            for (int j = 0; j < securities && redemptionDate == null; ++j) {
                if (valorNumber != null && TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j) != null && valorNumber.equals(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j))) {
                    redemptionDate = TaxStatementReportSecurityData.getSecurityRedemptionDate(doc, i, j);
                    continue;
                }
                if (isin == null || TaxStatementReportSecurityData.getSecurityISIN(doc, i, j) == null || !isin.equals(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j))) continue;
                redemptionDate = TaxStatementReportSecurityData.getSecurityRedemptionDate(doc, i, j);
            }
        }
        return redemptionDate;
    }

    public static boolean getSecurityRedemptionDateEarly(Document doc) throws ParseException, XPathExpressionException {
        boolean value = true;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && value; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && value; ++j) {
                Date redemptionDateEarly = TaxStatementReportSecurityData.getSecurityRedemptionDateEarly(doc, i, j);
                if (redemptionDateEarly != null) continue;
                value = false;
            }
        }
        return value;
    }

    public static Date getSecurityRedemptionDateEarly(Document doc, int depot, int security) throws ParseException, XPathExpressionException {
        return TaxStatementReportUtil.getValueDate(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@redemptionDateEarly");
    }

    public static boolean getSecurityRedemptionPrice(Document doc) throws XPathExpressionException {
        boolean value = true;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && value; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && value; ++j) {
                Double redemptionPrice = TaxStatementReportSecurityData.getSecurityRedemptionPrice(doc, i, j);
                if (redemptionPrice != null) continue;
                value = false;
            }
        }
        return value;
    }

    public static Double getSecurityRedemptionPrice(Document doc, int depot, int security) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@redemptionPrice");
    }

    public static boolean getSecurityRedemptionPriceEarly(Document doc) throws XPathExpressionException {
        boolean value = true;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && value; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && value; ++j) {
                Double redemptionPriceEarly = TaxStatementReportSecurityData.getSecurityRedemptionPriceEarly(doc, i, j);
                if (redemptionPriceEarly != null) continue;
                value = false;
            }
        }
        return value;
    }

    public static Double getSecurityRedemptionPriceEarly(Document doc, int depot, int security) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@redemptionPriceEarly");
    }

    public static boolean getSecurityType(Document doc) throws XPathExpressionException {
        boolean value = true;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && value; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && value; ++j) {
                String securityType = TaxStatementReportSecurityData.getSecurityType(doc, i, j);
                if (securityType != null) continue;
                value = false;
            }
        }
        return value;
    }

    public static String getSecurityType(Document doc, int depot, int security) throws XPathExpressionException {
        return TaxStatementReportUtil.getValue(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@securityType");
    }

    public static boolean getSecurityValorNumber(Document doc) throws XPathExpressionException {
        boolean value = true;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && value; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && value; ++j) {
                String valorNumber = TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j);
                if (valorNumber != null) continue;
                value = false;
            }
        }
        return value;
    }

    public static String getSecurityValorNumber(Document doc, int depot, int security) throws XPathExpressionException {
        return TaxStatementReportUtil.getValue(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@valorNumber");
    }

    public static Boolean getSecurityVariableInterest(Document doc, int depot, int security) throws ParseException, XPathExpressionException {
        return TaxStatementReportUtil.getValueBoolean(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/@variableInterest", false);
    }

    public static int getTaxValueCount(Document doc) throws XPathExpressionException {
        int count = 0;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                count += TaxStatementReportSecurityData.getTaxValueCount(doc, i, j);
            }
        }
        return count;
    }

    public static int getTaxValueCount(Document doc, int depot, int security) throws XPathExpressionException {
        return TaxStatementReportUtil.getCount(doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/taxValue)");
    }

    public static boolean getTaxValueBalance(Document doc) throws XPathExpressionException {
        boolean value = true;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && value; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && value; ++j) {
                int taxValues = TaxStatementReportSecurityData.getTaxValueCount(doc, i, j);
                for (int k = 1; k <= taxValues && value; ++k) {
                    Double balance = TaxStatementReportSecurityData.getTaxValueBalance(doc, i, j, k);
                    if (balance != null) continue;
                    value = false;
                }
            }
        }
        return value;
    }

    public static Double getTaxValueBalance(Document doc, int depot, int security, int taxValue) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/taxValue[" + taxValue + "]/@balance");
    }

    public static boolean getTaxValueBalanceCurrency(Document doc) throws XPathExpressionException {
        boolean value = true;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && value; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && value; ++j) {
                int taxValues = TaxStatementReportSecurityData.getTaxValueCount(doc, i, j);
                for (int k = 1; k <= taxValues && value; ++k) {
                    String currency = TaxStatementReportSecurityData.getTaxValueBalanceCurrency(doc, i, j, k);
                    if (currency == null || !currency.equals("CHF")) continue;
                    value = false;
                }
            }
        }
        return value;
    }

    public static String getTaxValueBalanceCurrency(Document doc, int depot, int security, int taxValue) throws XPathExpressionException {
        return TaxStatementReportUtil.getValue(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/taxValue[" + taxValue + "]/@balanceCurrency");
    }

    public static Boolean getTaxValueBlocked(Document doc, int depot, int security, int taxValue) throws ParseException, XPathExpressionException {
        return TaxStatementReportUtil.getValueBoolean(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/taxValue[" + taxValue + "]/@blocked", false);
    }

    public static boolean getTaxValueBlockingTo(Document doc) throws ParseException, XPathExpressionException {
        boolean value = true;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && value; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && value; ++j) {
                int taxValues = TaxStatementReportSecurityData.getTaxValueCount(doc, i, j);
                for (int k = 1; k <= taxValues && value; ++k) {
                    Date blockingTo = TaxStatementReportSecurityData.getTaxValueBlockingTo(doc, i, j, k);
                    if (blockingTo != null) continue;
                    value = false;
                }
            }
        }
        return value;
    }

    public static Date getTaxValueBlockingTo(Document doc, int depot, int security, int taxValue) throws ParseException, XPathExpressionException {
        return TaxStatementReportUtil.getValueDate(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/taxValue[" + taxValue + "]/@blockingTo");
    }

    public static boolean getTaxValueExchangeRate(Document doc) throws XPathExpressionException {
        boolean value = true;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && value; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && value; ++j) {
                int taxValues = TaxStatementReportSecurityData.getTaxValueCount(doc, i, j);
                for (int k = 1; k <= taxValues && value; ++k) {
                    Double exchangeRate = TaxStatementReportSecurityData.getTaxValueExchangeRate(doc, i, j, k);
                    if (exchangeRate != null) continue;
                    value = false;
                }
            }
        }
        return value;
    }

    public static Double getTaxValueExchangeRate(Document doc, int depot, int security, int taxValue) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/taxValue[" + taxValue + "]/@exchangeRate");
    }

    public static boolean getTaxValueName(Document doc) throws XPathExpressionException {
        boolean value = true;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && value; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && value; ++j) {
                int taxValues = TaxStatementReportSecurityData.getTaxValueCount(doc, i, j);
                for (int k = 1; k <= taxValues && value; ++k) {
                    String name = TaxStatementReportSecurityData.getTaxValueName(doc, i, j, k);
                    if (name != null) continue;
                    value = false;
                }
            }
        }
        return value;
    }

    public static String getTaxValueName(Document doc, int depot, int security, int taxValue) throws XPathExpressionException {
        return TaxStatementReportUtil.getValue(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/taxValue[" + taxValue + "]/@name");
    }

    public static Double getTaxValueQuantity(Document doc, int depot, int security, int taxValue) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/taxValue[" + taxValue + "]/@quantity");
    }

    public static String getTaxValueQuotationType(Document doc, int depot, int security, int taxValue) throws XPathExpressionException {
        return TaxStatementReportUtil.getValue(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/taxValue[" + taxValue + "]/@quotationType");
    }

    public static Date getTaxValueReferenceDate(Document doc, int depot, int security, int taxValue) throws ParseException, XPathExpressionException {
        return TaxStatementReportUtil.getValueDate(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/taxValue[" + taxValue + "]/@referenceDate");
    }

    public static Boolean getTaxValueUndefined(Document doc, int depot, int security, int taxValue) throws ParseException, XPathExpressionException {
        return TaxStatementReportUtil.getValueBoolean(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/taxValue[" + taxValue + "]/@undefined", false);
    }

    public static boolean getTaxValueUnitPrice(Document doc) throws XPathExpressionException {
        boolean value = true;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && value; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && value; ++j) {
                int taxValues = TaxStatementReportSecurityData.getTaxValueCount(doc, i, j);
                for (int k = 1; k <= taxValues && value; ++k) {
                    Double unitPrice = TaxStatementReportSecurityData.getTaxValueUnitPrice(doc, i, j, k);
                    if (unitPrice != null) continue;
                    value = false;
                }
            }
        }
        return value;
    }

    public static Double getTaxValueUnitPrice(Document doc, int depot, int security, int taxValue) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/taxValue[" + taxValue + "]/@unitPrice");
    }

    public static Double getTaxValueValue(Document doc, int depot, int security, int taxValue) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/taxValue[" + taxValue + "]/@value");
    }

    public static int getPaymentCount(Document doc) throws XPathExpressionException {
        int count = 0;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                count += TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
            }
        }
        return count;
    }

    public static int getPaymentCount(Document doc, int depot, int security) throws XPathExpressionException {
        return TaxStatementReportUtil.getCount(doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment)");
    }

    public static Double getPaymentAdditionalWithHoldingTaxUSA(Document doc, int depot, int security, int payment) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@additionalWithHoldingTaxUSA");
    }

    public static boolean getPaymentAmount(Document doc) throws XPathExpressionException {
        boolean value = true;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && value; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && value; ++j) {
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                for (int k = 1; k <= payments && value; ++k) {
                    Double amount = TaxStatementReportSecurityData.getPaymentAmount(doc, i, j, k);
                    if (amount != null) continue;
                    value = false;
                }
            }
        }
        return value;
    }

    public static Double getPaymentAmount(Document doc, int depot, int security, int payment) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@amount");
    }

    public static boolean getPaymentAmountCurrency(Document doc) throws XPathExpressionException {
        boolean value = true;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && value; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && value; ++j) {
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                for (int k = 1; k <= payments && value; ++k) {
                    String currency = TaxStatementReportSecurityData.getPaymentAmountCurrency(doc, i, j, k);
                    if (currency == null || !currency.equals("CHF")) continue;
                    value = false;
                }
            }
        }
        return value;
    }

    public static String getPaymentAmountCurrency(Document doc, int depot, int security, int payment) throws XPathExpressionException {
        return TaxStatementReportUtil.getValue(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@amountCurrency");
    }

    public static boolean getPaymentAmountPerUnit(Document doc) throws ParseException, XPathExpressionException {
        boolean value = true;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && value; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && value; ++j) {
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                for (int k = 1; k <= payments && value; ++k) {
                    Double amountPerUnit = TaxStatementReportSecurityData.getPaymentAmountPerUnit(doc, i, j, k);
                    if (amountPerUnit != null) continue;
                    value = false;
                }
            }
        }
        return value;
    }

    public static Double getPaymentAmountPerUnit(Document doc, int depot, int security, int payment) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@amountPerUnit");
    }

    public static Boolean getPaymentConversion(Document doc, int depot, int security, int payment) throws ParseException, XPathExpressionException {
        return TaxStatementReportUtil.getValueBoolean(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@conversion", false);
    }

    public static boolean getPaymentExchangeRate(Document doc) throws XPathExpressionException {
        boolean value = true;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && value; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && value; ++j) {
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                for (int k = 1; k <= payments && value; ++k) {
                    Double exchangeRate = TaxStatementReportSecurityData.getPaymentExchangeRate(doc, i, j, k);
                    if (exchangeRate != null) continue;
                    value = false;
                }
            }
        }
        return value;
    }

    public static Double getPaymentExchangeRate(Document doc, int depot, int security, int payment) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@exchangeRate");
    }

    public static boolean getPaymentExDate(Document doc) throws ParseException, XPathExpressionException {
        boolean value = true;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && value; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && value; ++j) {
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                for (int k = 1; k <= payments && value; ++k) {
                    Date exDate = TaxStatementReportSecurityData.getPaymentExDate(doc, i, j, k);
                    if (exDate != null) continue;
                    value = false;
                }
            }
        }
        return value;
    }

    public static Date getPaymentExDate(Document doc, int depot, int security, int payment) throws ParseException, XPathExpressionException {
        return TaxStatementReportUtil.getValueDate(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@exDate");
    }

    public static Double getPaymentGrossRevenueA(Document doc, int depot, int security, int payment) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueA");
    }

    public static Double getPaymentGrossRevenueB(Document doc, int depot, int security, int payment) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@grossRevenueB");
    }

    public static Boolean getPaymentIUP(Document doc, int depot, int security, int payment) throws ParseException, XPathExpressionException {
        return TaxStatementReportUtil.getValueBoolean(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@iup", false);
    }

    public static Boolean getPaymentLendingFee(Document doc, int depot, int security) throws ParseException, XPathExpressionException {
        Boolean lendingFee = false;
        int payments = TaxStatementReportSecurityData.getPaymentCount(doc, depot, security);
        for (int i = 1; i <= payments && !lendingFee.booleanValue(); ++i) {
            lendingFee = TaxStatementReportSecurityData.getPaymentLendingFee(doc, depot, security, i);
        }
        return lendingFee;
    }

    public static Boolean getPaymentLendingFee(Document doc, int depot, int security, int payment) throws ParseException, XPathExpressionException {
        return TaxStatementReportUtil.getValueBoolean(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@lendingFee", false);
    }

    public static boolean getPaymentLumpSumTaxCredit(Document doc) throws ParseException, XPathExpressionException {
        boolean value = true;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && value; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && value; ++j) {
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                for (int k = 1; k <= payments && value; ++k) {
                    Boolean lumpSumTaxCredit = TaxStatementReportSecurityData.getPaymentLumpSumTaxCredit(doc, i, j, k);
                    if (lumpSumTaxCredit.booleanValue()) continue;
                    value = false;
                }
            }
        }
        return value;
    }

    public static Boolean getPaymentLumpSumTaxCredit(Document doc, int depot, int security, Date date) throws ParseException, XPathExpressionException {
        boolean lumpSumTaxCredit = false;
        int payments = TaxStatementReportSecurityData.getPaymentCount(doc, depot, security);
        for (int i = 1; i <= payments && !lumpSumTaxCredit; ++i) {
            Date exDate = TaxStatementReportSecurityData.getPaymentExDate(doc, depot, security, i);
            Date paymentDate = TaxStatementReportSecurityData.getPaymentPaymentDate(doc, depot, security, i);
            if (exDate != null) {
                if (date == null || !date.equals(exDate)) continue;
                lumpSumTaxCredit = TaxStatementReportSecurityData.getPaymentLumpSumTaxCredit(doc, depot, security, i);
                continue;
            }
            if (paymentDate == null || date == null || !date.equals(paymentDate)) continue;
            lumpSumTaxCredit = TaxStatementReportSecurityData.getPaymentLumpSumTaxCredit(doc, depot, security, i);
        }
        return lumpSumTaxCredit;
    }

    public static Boolean getPaymentLumpSumTaxCredit(Document doc, int depot, int security, int payment) throws ParseException, XPathExpressionException {
        return TaxStatementReportUtil.getValueBoolean(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@lumpSumTaxCredit", false);
    }

    public static Double getPaymentLumpSumTaxCreditAmount(Document doc, int depot, int security, int payment) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@lumpSumTaxCreditAmount");
    }

    public static Double getPaymentLumpSumTaxCreditPercent(Document doc, int depot, int security, int payment) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@lumpSumTaxCreditPercent");
    }

    public static boolean getPaymentName(Document doc) throws XPathExpressionException {
        boolean value = true;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && value; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && value; ++j) {
                int payments = TaxStatementReportSecurityData.getPaymentCount(doc, i, j);
                for (int k = 1; k <= payments && value; ++k) {
                    String name = TaxStatementReportSecurityData.getPaymentName(doc, i, j, k);
                    if (name != null) continue;
                    value = false;
                }
            }
        }
        return value;
    }

    public static String getPaymentName(Document doc, int depot, int security, int payment) throws XPathExpressionException {
        return TaxStatementReportUtil.getValue(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@name");
    }

    public static Double getPaymentNonRecoverableTaxAmount(Document doc, int depot, int security, int payment) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@nonRecoverableTaxAmount");
    }

    public static Double getPaymentNonRecoverableTaxPercent(Document doc, int depot, int security, int payment) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@nonRecoverableTaxPercent");
    }

    public static Date getPaymentPaymentDate(Document doc, int depot, int security, int payment) throws ParseException, XPathExpressionException {
        return TaxStatementReportUtil.getValueDate(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@paymentDate");
    }

    public static Double getPaymentQuantity(Document doc, int depot, int security, int payment) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@quantity");
    }

    public static Double getPaymentQuantity(Document doc, int depot, int security, Date date, int payment) throws ParseException, XPathExpressionException {
        Double quantity = null;
        int count = 0;
        int payments = TaxStatementReportSecurityData.getPaymentCount(doc, depot, security);
        for (int i = 1; i <= payments; ++i) {
            Date exDate = TaxStatementReportSecurityData.getPaymentExDate(doc, depot, security, i);
            Date paymentDate = TaxStatementReportSecurityData.getPaymentPaymentDate(doc, depot, security, i);
            if (date == null || TaxStatementReportUtil.nvl(exDate, paymentDate) == null || !date.equals(TaxStatementReportUtil.nvl(exDate, paymentDate)) || payment != count++) continue;
            quantity = TaxStatementReportSecurityData.getPaymentQuantity(doc, depot, security, i);
        }
        return quantity;
    }

    public static int getPaymentQuantityCount(Document doc, int depot, int security, Date date) throws ParseException, XPathExpressionException {
        int count = 0;
        int payments = TaxStatementReportSecurityData.getPaymentCount(doc, depot, security);
        for (int i = 1; i <= payments; ++i) {
            Date exDate = TaxStatementReportSecurityData.getPaymentExDate(doc, depot, security, i);
            Date paymentDate = TaxStatementReportSecurityData.getPaymentPaymentDate(doc, depot, security, i);
            if (date == null || TaxStatementReportUtil.nvl(exDate, paymentDate) == null || !date.equals(TaxStatementReportUtil.nvl(exDate, paymentDate))) continue;
            ++count;
        }
        return count;
    }

    public static Double getPaymentQuantityTotal(Document doc, int depot, int security, Date date) throws ParseException, XPathExpressionException {
        Double total = null;
        int payments = TaxStatementReportSecurityData.getPaymentCount(doc, depot, security);
        for (int i = 1; i <= payments; ++i) {
            Double quantity;
            Date exDate = TaxStatementReportSecurityData.getPaymentExDate(doc, depot, security, i);
            Date paymentDate = TaxStatementReportSecurityData.getPaymentPaymentDate(doc, depot, security, i);
            if ((date == null || exDate == null || !date.equals(exDate)) && (paymentDate == null || !date.equals(paymentDate)) || (quantity = TaxStatementReportSecurityData.getPaymentQuantity(doc, depot, security, i)) == null) continue;
            total = TaxStatementReportUtil.nvl(total, 0.0) + quantity;
        }
        return total;
    }

    public static String getPaymentQuotationType(Document doc, int depot, int security, int payment) throws XPathExpressionException {
        return TaxStatementReportUtil.getValue(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@quotationType");
    }

    public static Double getPaymentReductionCost(Document doc, int depot, int security, int payment) throws ParseException, XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@reductionCost");
    }

    public static Boolean getPaymentRetrocession(Document doc, int depot, int security) throws ParseException, XPathExpressionException {
        Boolean retrocession = false;
        int payments = TaxStatementReportSecurityData.getPaymentCount(doc, depot, security);
        for (int i = 1; i <= payments && !retrocession.booleanValue(); ++i) {
            retrocession = TaxStatementReportSecurityData.getPaymentRetrocession(doc, depot, security, i);
        }
        return retrocession;
    }

    public static Boolean getPaymentRetrocession(Document doc, int depot, int security, int payment) throws ParseException, XPathExpressionException {
        return TaxStatementReportUtil.getValueBoolean(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@retrocession", false);
    }

    public static Boolean getPaymentSecuritiesLending(Document doc, int depot, int security) throws ParseException, XPathExpressionException {
        Boolean securitiesLending = false;
        int payments = TaxStatementReportSecurityData.getPaymentCount(doc, depot, security);
        for (int i = 1; i <= payments && !securitiesLending.booleanValue(); ++i) {
            securitiesLending = TaxStatementReportSecurityData.getPaymentSecuritiesLending(doc, depot, security, i);
        }
        return securitiesLending;
    }

    public static Boolean getPaymentSecuritiesLending(Document doc, int depot, int security, int payment) throws ParseException, XPathExpressionException {
        return TaxStatementReportUtil.getValueBoolean(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@securitiesLending", false);
    }

    public static String getPaymentSign(Document doc, int depot, int security, int payment) throws XPathExpressionException {
        return TaxStatementReportUtil.getValue(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@sign");
    }

    public static Boolean getPaymentUndefined(Document doc, int depot, int security, int payment) throws ParseException, XPathExpressionException {
        return TaxStatementReportUtil.getValueBoolean(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@undefined", false);
    }

    public static Double getPaymentWithHoldingTaxClaim(Document doc, int depot, int security, int payment) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/payment[" + payment + "]/@withHoldingTaxClaim");
    }

    public static Double getPaymentWithHoldingTaxClaimCalc(Document doc, int depot, int security, int payment) throws XPathExpressionException {
        Double grossRevenueA = TaxStatementReportSecurityData.getPaymentGrossRevenueA(doc, depot, security, payment);
        Double withHoldingTaxClaim = null;
        if (grossRevenueA != null) {
            withHoldingTaxClaim = grossRevenueA * 0.35;
        }
        return withHoldingTaxClaim;
    }

    public static int getStockCount(Document doc) throws ParseException, XPathExpressionException {
        int count = 0;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities; ++j) {
                count += TaxStatementReportSecurityData.getStockCount(doc, i, j);
            }
        }
        return count;
    }

    public static int getStockCount(Document doc, int depot, int security) throws ParseException, XPathExpressionException {
        return TaxStatementReportUtil.getCount(doc, "count(/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/stock)");
    }

    public static boolean getStockBalance(Document doc) throws ParseException, XPathExpressionException {
        boolean value = true;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && value; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && value; ++j) {
                int stocks = TaxStatementReportSecurityData.getStockCount(doc, i, j);
                for (int k = 1; k <= stocks && value; ++k) {
                    Double balance = TaxStatementReportSecurityData.getStockBalance(doc, i, j, k);
                    if (balance != null) continue;
                    value = false;
                }
            }
        }
        return value;
    }

    public static Double getStockBalance(Document doc, int depot, int security, int stock) throws ParseException, XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/stock[" + stock + "]/@balance");
    }

    public static boolean getStockBalanceCurrency(Document doc) throws ParseException, XPathExpressionException {
        boolean value = true;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && value; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && value; ++j) {
                int stocks = TaxStatementReportSecurityData.getStockCount(doc, i, j);
                for (int k = 1; k <= stocks && value; ++k) {
                    String currency = TaxStatementReportSecurityData.getStockBalanceCurrency(doc, i, j, k);
                    if (currency == null || !currency.equals("CHF")) continue;
                    value = false;
                }
            }
        }
        return value;
    }

    public static String getStockBalanceCurrency(Document doc, int depot, int security, int stock) throws ParseException, XPathExpressionException {
        return TaxStatementReportUtil.getValue(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/stock[" + stock + "]/@balanceCurrency");
    }

    public static Boolean getStockBlocked(Document doc, int depot, int security, int stock) throws ParseException, XPathExpressionException {
        return TaxStatementReportUtil.getValueBoolean(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/stock[" + stock + "]/@blocked", false);
    }

    public static boolean getStockBlockingTo(Document doc) throws ParseException, XPathExpressionException {
        boolean value = true;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && value; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && value; ++j) {
                int stocks = TaxStatementReportSecurityData.getStockCount(doc, i, j);
                for (int k = 1; k <= stocks && value; ++k) {
                    Date blockingTo = TaxStatementReportSecurityData.getStockBlockingTo(doc, i, j, k);
                    if (blockingTo != null) continue;
                    value = false;
                }
            }
        }
        return value;
    }

    public static Date getStockBlockingTo(Document doc, int depot, int security, int stock) throws ParseException, XPathExpressionException {
        return TaxStatementReportUtil.getValueDate(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/stock[" + stock + "]/@blockingTo");
    }

    public static boolean getStockExchangeRate(Document doc) throws ParseException, XPathExpressionException {
        boolean value = true;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && value; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && value; ++j) {
                int stocks = TaxStatementReportSecurityData.getStockCount(doc, i, j);
                for (int k = 1; k <= stocks && value; ++k) {
                    Double exchangeRate = TaxStatementReportSecurityData.getStockExchangeRate(doc, i, j, k);
                    if (exchangeRate != null) continue;
                    value = false;
                }
            }
        }
        return value;
    }

    public static Double getStockExchangeRate(Document doc, int depot, int security, int stock) throws ParseException, XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/stock[" + stock + "]/@exchangeRate");
    }

    public static Boolean getStockMutation(Document doc, int depot, int security, int stock) throws ParseException, XPathExpressionException {
        return TaxStatementReportUtil.getValueBoolean(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/stock[" + stock + "]/@mutation");
    }

    public static boolean getStockName(Document doc) throws ParseException, XPathExpressionException {
        boolean value = true;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && value; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && value; ++j) {
                int stocks = TaxStatementReportSecurityData.getStockCount(doc, i, j);
                for (int k = 1; k <= stocks && value; ++k) {
                    String name = TaxStatementReportSecurityData.getStockName(doc, i, j, k);
                    if (name != null) continue;
                    value = false;
                }
            }
        }
        return value;
    }

    public static String getStockName(Document doc, int depot, int security, int stock) throws ParseException, XPathExpressionException {
        return TaxStatementReportUtil.getValue(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/stock[" + stock + "]/@name");
    }

    public static Double getStockQuantity(Document doc, int depot, int security, int stock) throws ParseException, XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/stock[" + stock + "]/@quantity");
    }

    public static Double getStockQuantity(Document doc, int depot, int security, Date date) throws ParseException, XPathExpressionException {
        return TaxStatementReportSecurityData.getStockQuantity(doc, depot, security, date, false, false);
    }

    public static Double getStockQuantity(Document doc, int depot, int security, Date date, Boolean iup, Boolean conversion) throws ParseException, XPathExpressionException {
        Date yearBegin;
        int year;
        Double quantity;
        Boolean mutation;
        Date referenceDate;
        int i;
        Double quantityCalc = 0.0;
        int stocks = TaxStatementReportSecurityData.getStockCount(doc, depot, security);
        for (i = 1; i <= stocks; ++i) {
            referenceDate = TaxStatementReportSecurityData.getStockReferenceDate(doc, depot, security, i);
            mutation = TaxStatementReportSecurityData.getStockMutation(doc, depot, security, i);
            quantity = TaxStatementReportSecurityData.getStockQuantity(doc, depot, security, i);
            if (date == null || referenceDate == null || quantity == null || mutation == null || mutation.booleanValue()) continue;
            year = Integer.parseInt(new SimpleDateFormat("yyyy").format(referenceDate));
            yearBegin = new SimpleDateFormat("yyyyMMdd").parse(year + "0101");
            Date yearEnd = new SimpleDateFormat("yyyyMMdd").parse(year + "1231");
            if (!(date.after(referenceDate) || date.equals(referenceDate) && date.equals(yearBegin) || date.equals(referenceDate) && date.equals(yearEnd)) && (!date.before(yearBegin) || i != 1)) continue;
            quantityCalc = quantity;
        }
        stocks = TaxStatementReportSecurityData.getStockCount(doc, depot, security);
        for (i = 1; i <= stocks; ++i) {
            referenceDate = TaxStatementReportSecurityData.getStockReferenceDate(doc, depot, security, i);
            mutation = TaxStatementReportSecurityData.getStockMutation(doc, depot, security, i);
            quantity = TaxStatementReportSecurityData.getStockQuantity(doc, depot, security, i);
            if (date == null || referenceDate == null || quantity == null || mutation == null || !mutation.booleanValue()) continue;
            year = Integer.parseInt(new SimpleDateFormat("yyyy").format(referenceDate));
            yearBegin = new SimpleDateFormat("yyyyMMdd").parse(year + "0101");
            if (!date.after(referenceDate) && (!date.equals(referenceDate) || !date.equals(yearBegin)) && (!date.before(yearBegin) || i != 1)) continue;
            quantityCalc = quantityCalc + quantity;
        }
        stocks = TaxStatementReportSecurityData.getStockCount(doc, depot, security);
        for (i = 1; i <= stocks; ++i) {
            referenceDate = TaxStatementReportSecurityData.getStockReferenceDate(doc, depot, security, i);
            mutation = TaxStatementReportSecurityData.getStockMutation(doc, depot, security, i);
            quantity = TaxStatementReportSecurityData.getStockQuantity(doc, depot, security, i);
            if (date == null || referenceDate == null || quantity == null || mutation == null || !mutation.booleanValue()) continue;
            year = Integer.parseInt(new SimpleDateFormat("yyyy").format(referenceDate));
            yearBegin = new SimpleDateFormat("yyyyMMdd").parse(year + "0101");
            if (!date.equals(referenceDate) || mutation == null || !mutation.booleanValue() || (iup == null || !iup.booleanValue()) && (conversion == null || !conversion.booleanValue())) continue;
            quantityCalc = TaxStatementReportUtil.abs(quantity);
        }
        return quantityCalc;
    }

    public static Double getStockQuantityBefore(Document doc, int depot, int security, Date date) throws ParseException, XPathExpressionException {
        return TaxStatementReportSecurityData.getStockQuantityBefore(doc, depot, security, date, false, false, 1);
    }

    public static Double getStockQuantityBefore(Document doc, int depot, int security, Date date, int step) throws ParseException, XPathExpressionException {
        return TaxStatementReportSecurityData.getStockQuantityBefore(doc, depot, security, date, false, false, step);
    }

    public static Double getStockQuantityBefore(Document doc, int depot, int security, Date date, Boolean iup, Boolean conversion) throws ParseException, XPathExpressionException {
        return TaxStatementReportSecurityData.getStockQuantityBefore(doc, depot, security, date, iup, conversion, 1);
    }

    public static Double getStockQuantityBefore(Document doc, int depot, int security, Date date, Boolean iup, Boolean conversion, int step) throws ParseException, XPathExpressionException {
        Date dateBefore = date;
        int stocks = TaxStatementReportSecurityData.getStockCount(doc, depot, security);
        for (int i = 1 + step; i <= stocks; ++i) {
            Date referenceDate = TaxStatementReportSecurityData.getStockReferenceDate(doc, depot, security, i);
            Date referenceDateBefore = TaxStatementReportSecurityData.getStockReferenceDate(doc, depot, security, i - step);
            if (date == null || referenceDate == null || !referenceDate.before(date) || referenceDateBefore == null || !referenceDateBefore.before(date) || !referenceDateBefore.before(referenceDate)) continue;
            dateBefore = new Date(referenceDateBefore.getTime() + 86400000L);
        }
        return TaxStatementReportSecurityData.getStockQuantity(doc, depot, security, dateBefore, iup, conversion);
    }

    public static Double getStockQuantityMutation(Document doc, int depot, int security, Date date) throws ParseException, XPathExpressionException {
        Double quantity = null;
        int stocks = TaxStatementReportSecurityData.getStockCount(doc, depot, security);
        for (int i = 1; i <= stocks; ++i) {
            Date referenceDate = TaxStatementReportSecurityData.getStockReferenceDate(doc, depot, security, i);
            Boolean mutation = TaxStatementReportSecurityData.getStockMutation(doc, depot, security, i);
            if (date == null || referenceDate == null || !referenceDate.equals(date) || mutation == null || !mutation.booleanValue()) continue;
            quantity = TaxStatementReportSecurityData.getStockQuantity(doc, depot, security, i);
        }
        return quantity;
    }

    public static Double getStockQuantityTaxValue(Document doc, int depot, int security, Date date) throws ParseException, XPathExpressionException {
        Date yearBegin;
        int year;
        Double quantity;
        Boolean mutation;
        Date referenceDate;
        int i;
        Double quantityCalc = 0.0;
        int stocks = TaxStatementReportSecurityData.getStockCount(doc, depot, security);
        for (i = 1; i <= stocks; ++i) {
            referenceDate = TaxStatementReportSecurityData.getStockReferenceDate(doc, depot, security, i);
            mutation = TaxStatementReportSecurityData.getStockMutation(doc, depot, security, i);
            quantity = TaxStatementReportSecurityData.getStockQuantity(doc, depot, security, i);
            if (date == null || referenceDate == null || quantity == null || mutation == null || mutation.booleanValue()) continue;
            year = Integer.parseInt(new SimpleDateFormat("yyyy").format(referenceDate));
            yearBegin = new SimpleDateFormat("yyyyMMdd").parse(year + "0101");
            if (date.before(referenceDate) && (!date.equals(referenceDate) || !date.equals(yearBegin)) && (!date.before(yearBegin) || i != 1)) continue;
            quantityCalc = quantity;
        }
        stocks = TaxStatementReportSecurityData.getStockCount(doc, depot, security);
        for (i = 1; i <= stocks; ++i) {
            referenceDate = TaxStatementReportSecurityData.getStockReferenceDate(doc, depot, security, i);
            mutation = TaxStatementReportSecurityData.getStockMutation(doc, depot, security, i);
            quantity = TaxStatementReportSecurityData.getStockQuantity(doc, depot, security, i);
            if (date == null || referenceDate == null || quantity == null || mutation == null || !mutation.booleanValue()) continue;
            year = Integer.parseInt(new SimpleDateFormat("yyyy").format(referenceDate));
            yearBegin = new SimpleDateFormat("yyyyMMdd").parse(year + "0101");
            if (date.before(referenceDate) && (!date.equals(referenceDate) || !date.equals(yearBegin)) && (!date.before(yearBegin) || i != 1)) continue;
            quantityCalc = quantityCalc + quantity;
        }
        return quantityCalc;
    }

    public static String getStockQuotationType(Document doc, int depot, int security, int stock) throws ParseException, XPathExpressionException {
        return TaxStatementReportUtil.getValue(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/stock[" + stock + "]/@quotationType");
    }

    public static boolean getStockReductionCost(Document doc) throws ParseException, XPathExpressionException {
        boolean value = true;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && value; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && value; ++j) {
                int stocks = TaxStatementReportSecurityData.getStockCount(doc, i, j);
                for (int k = 1; k <= stocks && value; ++k) {
                    Double reductionCost = TaxStatementReportSecurityData.getStockReductionCost(doc, i, j, k);
                    if (reductionCost != null) continue;
                    value = false;
                }
            }
        }
        return value;
    }

    public static Double getStockReductionCost(Document doc, int depot, int security, int stock) throws ParseException, XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/stock[" + stock + "]/@reductionCost");
    }

    public static Date getStockReferenceDate(Document doc, int depot, int security, int stock) throws ParseException, XPathExpressionException {
        return TaxStatementReportUtil.getValueDate(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/stock[" + stock + "]/@referenceDate");
    }

    public static boolean getStockUnitPrice(Document doc) throws ParseException, XPathExpressionException {
        boolean value = true;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && value; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && value; ++j) {
                int stocks = TaxStatementReportSecurityData.getStockCount(doc, i, j);
                for (int k = 1; k <= stocks && value; ++k) {
                    Double unitPrice = TaxStatementReportSecurityData.getStockUnitPrice(doc, i, j, k);
                    if (unitPrice != null) continue;
                    value = false;
                }
            }
        }
        return value;
    }

    public static Double getStockUnitPrice(Document doc, int depot, int security, int stock) throws ParseException, XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/stock[" + stock + "]/@unitPrice");
    }

    public static boolean getStockValue(Document doc) throws ParseException, XPathExpressionException {
        boolean value = true;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots && value; ++i) {
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            for (int j = 1; j <= securities && value; ++j) {
                int stocks = TaxStatementReportSecurityData.getStockCount(doc, i, j);
                for (int k = 1; k <= stocks && value; ++k) {
                    Double stockValue = TaxStatementReportSecurityData.getStockValue(doc, i, j, k);
                    if (stockValue != null) continue;
                    value = false;
                }
            }
        }
        return value;
    }

    public static Double getStockValue(Document doc, int depot, int security, int stock) throws ParseException, XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfSecurities/depot[" + depot + "]/security[" + security + "]/stock[" + stock + "]/@value");
    }
}

