/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.report;

import ch.ewv.taxstatement.report.TaxStatementReportCase;
import ch.ewv.taxstatement.report.TaxStatementReportFormula;
import ch.ewv.taxstatement.report.TaxStatementReportOperator;
import ch.ewv.taxstatement.report.TaxStatementReportResult;
import ch.ewv.taxstatement.report.TaxStatementReportResultCase;
import ch.ewv.taxstatement.report.TaxStatementReportResultEntity;
import ch.ewv.taxstatement.report.TaxStatementReportResultStep;
import ch.ewv.taxstatement.report.TaxStatementReportSecurityData;
import ch.ewv.taxstatement.report.TaxStatementReportUtil;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class TaxStatementReportSecurityCase05
extends TaxStatementReportCase {
    protected TaxStatementReportResultStep execute01(Document doc, Properties lang, TaxStatementReportFormula formula) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeExist(1, this.getStepDescription(lang, 1), this.getStepCondition(lang, 1), false, TaxStatementReportSecurityData.getTotalTaxValue(doc));
    }

    protected TaxStatementReportResultStep execute02(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeCount(2, this.getStepDescription(lang, 2), this.getStepCondition(lang, 2), filter, TaxStatementReportSecurityData.getSecurityCount(doc));
    }

    protected TaxStatementReportResultStep execute03(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(3, this.getStepDescription(lang, 3), this.getStepCondition(lang, 3));
        int security = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int j = 1;
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            while (j <= securities) {
                int taxValues = TaxStatementReportSecurityData.getTaxValueCount(doc, i, j);
                for (int k = 1; k <= taxValues; ++k) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getTaxValueReferenceDate(doc, i, j, k));
                    String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                    if (category != null) {
                        if (category.equals("BOND") || category.equals("COINBULL") || category.equals("CURRNOTE") || category.equals("DEVT") || category.equals("FUND") || category.equals("LIBOSWAP") || category.equals("OPTION") || category.equals("SHARE") || category.equals("OTHER")) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + category);
                        } else {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + category);
                        }
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                }
                ++j;
                ++security;
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute04(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(4, this.getStepDescription(lang, 4), this.getStepCondition(lang, 4));
        int security = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int j = 1;
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            while (j <= securities) {
                int taxValues = TaxStatementReportSecurityData.getTaxValueCount(doc, i, j);
                for (int k = 1; k <= taxValues; ++k) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getTaxValueReferenceDate(doc, i, j, k));
                    Boolean undefined = TaxStatementReportSecurityData.getTaxValueUndefined(doc, i, j, k);
                    Double quantity = TaxStatementReportSecurityData.getTaxValueQuantity(doc, i, j, k);
                    Double balance = TaxStatementReportSecurityData.getTaxValueBalance(doc, i, j, k);
                    Double value = TaxStatementReportSecurityData.getTaxValueValue(doc, i, j, k);
                    if (!undefined.booleanValue()) {
                        if (value != null || balance != null) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + (undefined == false));
                        } else if (quantity != null && quantity == 0.0 && value == null && balance == null) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + (undefined == false));
                        } else {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + (undefined == false));
                        }
                    } else if (value == null && balance == null) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + (undefined == false));
                    } else if (value != null && value == 0.0 && balance != null && balance == 0.0) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + (undefined == false));
                    } else {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + String.format("%1$,.2f", TaxStatementReportUtil.nvl(value, balance)));
                    }
                    step.addEntity(entity);
                }
                ++j;
                ++security;
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute05(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(5, this.getStepDescription(lang, 5), this.getStepCondition(lang, 5));
        int security = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int j = 1;
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            while (j <= securities) {
                int taxValues = TaxStatementReportSecurityData.getTaxValueCount(doc, i, j);
                for (int k = 1; k <= taxValues; ++k) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getTaxValueReferenceDate(doc, i, j, k));
                    Date referenceDate = TaxStatementReportSecurityData.getTaxValueReferenceDate(doc, i, j, k);
                    if (referenceDate != null) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + new SimpleDateFormat("dd.MM.yyyy").format(referenceDate));
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                }
                ++j;
                ++security;
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute06(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(6, this.getStepDescription(lang, 6), this.getStepCondition(lang, 6));
        int security = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int j = 1;
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            while (j <= securities) {
                int taxValues = TaxStatementReportSecurityData.getTaxValueCount(doc, i, j);
                for (int k = 1; k <= taxValues; ++k) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getTaxValueReferenceDate(doc, i, j, k));
                    String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                    Double quantity = TaxStatementReportSecurityData.getTaxValueQuantity(doc, i, j, k);
                    if (quantity != null) {
                        if (quantity >= 0.0) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + String.format("%1$,.2f", quantity));
                        } else if (quantity < 0.0 && category != null && (category.equals("OPTION") || category.equals("OTHER"))) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + String.format("%1$,.2f", quantity));
                        } else if (quantity < 0.0 && category != null && category.equals("SHARE")) {
                            entity.setResult(TaxStatementReportResult.IGNORE).setRemark("(" + security + ") " + String.format("%1$,.2f", quantity));
                        } else {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + String.format("%1$,.2f", quantity));
                        }
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                }
                ++j;
                ++security;
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute07(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(7, this.getStepDescription(lang, 7), this.getStepCondition(lang, 7));
        int security = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int j = 1;
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            while (j <= securities) {
                int taxValues = TaxStatementReportSecurityData.getTaxValueCount(doc, i, j);
                for (int k = 1; k <= taxValues; ++k) {
                    Boolean blocked;
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getTaxValueReferenceDate(doc, i, j, k));
                    Boolean blockedStock = blocked = TaxStatementReportSecurityData.getTaxValueBlocked(doc, i, j, k);
                    int stocks = TaxStatementReportSecurityData.getStockCount(doc, i, j);
                    for (int stock = 1; stock <= stocks && blocked.equals(blockedStock); ++stock) {
                        blockedStock = TaxStatementReportSecurityData.getStockBlocked(doc, i, j, stock);
                    }
                    if (blocked.equals(blockedStock)) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + blocked);
                    } else if (!blocked.equals(blockedStock)) {
                        entity.setResult(TaxStatementReportResult.ERROR).setRemark("(" + security + ") " + blocked + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + blockedStock);
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                }
                ++j;
                ++security;
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute08(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(8, this.getStepDescription(lang, 8), this.getStepCondition(lang, 8));
        int security = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int j = 1;
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            while (j <= securities) {
                int taxValues = TaxStatementReportSecurityData.getTaxValueCount(doc, i, j);
                for (int k = 1; k <= taxValues; ++k) {
                    int stock;
                    int stocks;
                    Date blockingTo;
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getTaxValueReferenceDate(doc, i, j, k));
                    Date blockingToStock = blockingTo = TaxStatementReportSecurityData.getTaxValueBlockingTo(doc, i, j, k);
                    if (blockingTo != null) {
                        stocks = TaxStatementReportSecurityData.getStockCount(doc, i, j);
                        for (stock = 1; stock <= stocks && blockingToStock != null && blockingTo.equals(blockingToStock); ++stock) {
                            blockingToStock = TaxStatementReportSecurityData.getStockBlockingTo(doc, i, j, stock);
                        }
                        if (blockingToStock != null && blockingTo.equals(blockingToStock)) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + new SimpleDateFormat("dd.MM.yyyy").format(blockingTo));
                        } else if (blockingToStock != null && !blockingTo.equals(blockingToStock)) {
                            entity.setResult(TaxStatementReportResult.ERROR).setRemark("(" + security + ") " + new SimpleDateFormat("dd.MM.yyyy").format(blockingTo) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + new SimpleDateFormat("dd.MM.yyyy").format(blockingToStock));
                        } else {
                            entity.setResult(TaxStatementReportResult.ERROR).setRemark("(" + security + ") " + new SimpleDateFormat("dd.MM.yyyy").format(blockingTo) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + (Object)((Object)TaxStatementReportOperator.UNDEFINED));
                        }
                    } else if (blockingTo == null) {
                        stocks = TaxStatementReportSecurityData.getStockCount(doc, i, j);
                        for (stock = 1; stock <= stocks && blockingToStock == null; ++stock) {
                            blockingToStock = TaxStatementReportSecurityData.getStockBlockingTo(doc, i, j, stock);
                        }
                        if (blockingToStock == null) {
                            entity.setResult(TaxStatementReportResult.OK);
                        } else {
                            entity.setResult(TaxStatementReportResult.ERROR).setRemark("(" + security + ") " + (Object)((Object)TaxStatementReportOperator.UNDEFINED) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + new SimpleDateFormat("dd.MM.yyyy").format(blockingToStock));
                        }
                    } else {
                        entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                    }
                    step.addEntity(entity);
                }
                ++j;
                ++security;
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute09(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(9, this.getStepDescription(lang, 9), this.getStepCondition(lang, 9));
        int security = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int j = 1;
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            while (j <= securities) {
                int taxValues = TaxStatementReportSecurityData.getTaxValueCount(doc, i, j);
                for (int k = 1; k <= taxValues; ++k) {
                    TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))), TaxStatementReportSecurityData.getTaxValueReferenceDate(doc, i, j, k));
                    String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                    Boolean lendingFee = TaxStatementReportSecurityData.getPaymentLendingFee(doc, i, j);
                    Boolean retrocession = TaxStatementReportSecurityData.getPaymentRetrocession(doc, i, j);
                    Date referenceDate = TaxStatementReportSecurityData.getTaxValueReferenceDate(doc, i, j, k);
                    Double quantity = TaxStatementReportSecurityData.getTaxValueQuantity(doc, i, j, k);
                    Double quantityCalc = TaxStatementReportSecurityData.getStockQuantityTaxValue(doc, i, j, referenceDate);
                    if (quantity != null && quantity >= 0.0 && quantityCalc != null && quantityCalc == 0.0 && (lendingFee.booleanValue() || retrocession.booleanValue())) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + String.format("%1$,.2f", quantity));
                    } else if (quantity != null && quantityCalc != null) {
                        if (String.format("%1$,.2f", quantity).equals(String.format("%1$,.2f", quantityCalc))) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + String.format("%1$,.2f", quantity));
                        } else if (String.format("%1$,.2f", TaxStatementReportUtil.abs(quantity)).equals(String.format("%1$,.2f", quantityCalc)) && category != null && (category.equals("OPTION") || category.equals("OTHER"))) {
                            entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + String.format("%1$,.2f", quantity));
                        } else if (TaxStatementReportUtil.approximately(quantity, quantityCalc, 0.0499999999).booleanValue()) {
                            entity.setResult(TaxStatementReportResult.OK).setReason("(" + security + ") " + String.format("%1$,.2f", quantity) + " " + (Object)((Object)TaxStatementReportOperator.APPROXIMATELY) + " " + String.format("%1$,.2f", quantityCalc));
                        } else if (TaxStatementReportUtil.approximately(TaxStatementReportUtil.abs(quantity), quantityCalc, 0.0499999999).booleanValue() && category != null && (category.equals("OPTION") || category.equals("OTHER"))) {
                            entity.setResult(TaxStatementReportResult.OK).setReason("(" + security + ") " + String.format("%1$,.2f", TaxStatementReportUtil.abs(quantity)) + " " + (Object)((Object)TaxStatementReportOperator.APPROXIMATELY) + " " + String.format("%1$,.2f", quantityCalc));
                        } else {
                            entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + String.format("%1$,.3f", quantity) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.3f", quantityCalc));
                        }
                    } else {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + String.format("%1$,.2f", quantity));
                    }
                    step.addEntity(entity);
                }
                ++j;
                ++security;
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    @Override
    public TaxStatementReportResultCase execute(Document doc, byte[] xml, Properties lang, TaxStatementReportFormula formula) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultCase cs = new TaxStatementReportResultCase(this.getCaseGroup(), this.getCaseId(), this.getCaseGroup(lang), this.getCaseName(lang), this.getCaseDescription(lang));
        TaxStatementReportResult[][] ok = new TaxStatementReportResult[][]{new TaxStatementReportResult[0], {TaxStatementReportResult.ERROR, TaxStatementReportResult.OK, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, TaxStatementReportResult.ERROR, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, null, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, null, TaxStatementReportResult.ERROR, TaxStatementReportResult.OK}, {null, null, null, TaxStatementReportResult.OK}, {null, null, null, TaxStatementReportResult.OK}, {null, null, null, null}, {null, null, null, null}, {null, null, null, TaxStatementReportResult.OK}};
        cs.addStepResultOptional(ok[1], this.execute01(doc, lang, formula));
        cs.addStepResultOptional(ok[2], this.execute02(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getSecurityCount(doc) > 0));
        cs.addStepResultMandatory(ok[3], this.execute03(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getTaxValueCount(doc) > 0));
        cs.addStepResultOptional(ok[4], this.execute04(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getTaxValueCount(doc) > 0));
        cs.addStepResultMandatory(ok[5], this.execute05(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getTaxValueCount(doc) > 0));
        cs.addStepResultMandatory(ok[6], this.execute06(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getTaxValueCount(doc) > 0));
        cs.addStepResultOptional(ok[7], this.execute07(doc, lang, formula, TaxStatementReportSecurityData.getTaxValueCount(doc) > 0));
        cs.addStepResultOptional(ok[8], this.execute08(doc, lang, formula, TaxStatementReportSecurityData.getTaxValueCount(doc) > 0 && TaxStatementReportSecurityData.getTaxValueBlockingTo(doc)));
        cs.addStepResultMandatory(ok[9], this.execute09(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getTaxValueCount(doc) > 0));
        return cs;
    }

    public TaxStatementReportSecurityCase05() {
        super("SECURITY_CASE", 5);
    }
}

