/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.report;

import ch.ewv.taxstatement.report.TaxStatementReportCase;
import ch.ewv.taxstatement.report.TaxStatementReportFormula;
import ch.ewv.taxstatement.report.TaxStatementReportOperator;
import ch.ewv.taxstatement.report.TaxStatementReportResult;
import ch.ewv.taxstatement.report.TaxStatementReportResultCase;
import ch.ewv.taxstatement.report.TaxStatementReportResultEntity;
import ch.ewv.taxstatement.report.TaxStatementReportResultStep;
import ch.ewv.taxstatement.report.TaxStatementReportSchemaData;
import ch.ewv.taxstatement.report.TaxStatementReportSecurityData;
import ch.ewv.taxstatement.report.TaxStatementReportUtil;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class TaxStatementReportSecurityCase01
extends TaxStatementReportCase {
    public static final String INDEFAULT = "LEGEND_INDEFAULT";

    protected TaxStatementReportResultStep execute01(Document doc, Properties lang, TaxStatementReportFormula formula) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeExist(1, this.getStepDescription(lang, 1), this.getStepCondition(lang, 1), false, TaxStatementReportSecurityData.getTotalTaxValue(doc));
    }

    protected TaxStatementReportResultStep execute02(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeCount(2, this.getStepDescription(lang, 2), this.getStepCondition(lang, 2), filter, TaxStatementReportSecurityData.getSecurityCount(doc));
    }

    protected TaxStatementReportResultStep execute03(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(3, this.getStepDescription(lang, 3), this.getStepCondition(lang, 3));
        int security = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int j = 1;
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            while (j <= securities) {
                TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))));
                String positionId = TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j);
                if (positionId != null) {
                    if (positionId.length() > 0) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + positionId);
                    } else {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + positionId);
                    }
                } else {
                    entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                }
                step.addEntity(entity);
                ++j;
                ++security;
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute04(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(4, this.getStepDescription(lang, 4), this.getStepCondition(lang, 4));
        ArrayList<String> ids = new ArrayList<String>();
        int security = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int j = 1;
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            while (j <= securities) {
                TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))));
                String positionId = TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j);
                if (positionId != null && !ids.contains(positionId)) {
                    entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + positionId);
                    ids.add(positionId);
                } else {
                    entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + positionId);
                }
                step.addEntity(entity);
                ++j;
                ++security;
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute05(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(5, this.getStepDescription(lang, 5), this.getStepCondition(lang, 5));
        int security = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int j = 1;
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            while (j <= securities) {
                TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))));
                String valorNumber = TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j);
                if (valorNumber != null) {
                    if (valorNumber.length() >= 3 && valorNumber.length() <= 9 && valorNumber.matches("[0-9]+")) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + valorNumber);
                    } else {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + valorNumber);
                    }
                } else {
                    entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                }
                step.addEntity(entity);
                ++j;
                ++security;
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute06(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(6, this.getStepDescription(lang, 6), this.getStepCondition(lang, 6));
        int security = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int j = 1;
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            while (j <= securities) {
                TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))));
                String isin = TaxStatementReportSecurityData.getSecurityISIN(doc, i, j);
                if (isin != null) {
                    if (isin.length() == 12 && isin.charAt(0) >= 'A' && isin.charAt(0) <= 'Z' && isin.charAt(1) >= 'A' && isin.charAt(1) <= 'Z' && isin.matches("[0-9A-Z]+")) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + isin);
                    } else {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + isin);
                    }
                } else {
                    entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                }
                step.addEntity(entity);
                ++j;
                ++security;
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute07(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(7, this.getStepDescription(lang, 7), this.getStepCondition(lang, 7));
        int security = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int j = 1;
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            while (j <= securities) {
                TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))));
                String country = TaxStatementReportSecurityData.getSecurityCountry(doc, i, j);
                if (country != null) {
                    if (country.length() == 2 && country.charAt(0) >= 'A' && country.charAt(0) <= 'Z' && country.charAt(1) >= 'A' && country.charAt(1) <= 'Z') {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + country);
                    } else {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + country);
                    }
                } else {
                    entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                }
                step.addEntity(entity);
                ++j;
                ++security;
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute08(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(8, this.getStepDescription(lang, 8), this.getStepCondition(lang, 8));
        int security = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int j = 1;
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            while (j <= securities) {
                TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))));
                String city = TaxStatementReportSecurityData.getSecurityCity(doc, i, j);
                if (city != null) {
                    if (city.length() >= 0 && city.length() <= 40) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + city);
                    } else if (city.length() > 40) {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + city.length() + " " + (Object)((Object)TaxStatementReportOperator.GREATER) + " 40");
                    } else {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + city);
                    }
                } else {
                    entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                }
                step.addEntity(entity);
                ++j;
                ++security;
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute09(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(9, this.getStepDescription(lang, 9), this.getStepCondition(lang, 9));
        int security = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int j = 1;
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            while (j <= securities) {
                TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))));
                String currency = TaxStatementReportSecurityData.getSecurityCurrency(doc, i, j);
                if (currency != null) {
                    if (currency.length() == 3 && currency.charAt(0) >= 'A' && currency.charAt(0) <= 'Z' && currency.charAt(1) >= 'A' && currency.charAt(1) <= 'Z' && currency.charAt(2) >= 'A' && currency.charAt(2) <= 'Z') {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + currency);
                    } else {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + currency);
                    }
                } else {
                    entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                }
                step.addEntity(entity);
                ++j;
                ++security;
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute10(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(10, this.getStepDescription(lang, 10), this.getStepCondition(lang, 10));
        int security = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int j = 1;
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            while (j <= securities) {
                TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))));
                String quotationType = TaxStatementReportSecurityData.getSecurityQuotationType(doc, i, j);
                if (quotationType != null) {
                    if (quotationType.equals("PERCENT") || quotationType.equals("PIECE")) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + quotationType);
                    } else {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + quotationType);
                    }
                } else {
                    entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                }
                step.addEntity(entity);
                ++j;
                ++security;
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute11(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(11, this.getStepDescription(lang, 11), this.getStepCondition(lang, 11));
        int security = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int j = 1;
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            while (j <= securities) {
                TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))));
                Double nominalValue = TaxStatementReportSecurityData.getSecurityNominalValue(doc, i, j);
                if (nominalValue != null) {
                    if (nominalValue >= 0.0) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + String.format("%1$,.2f", nominalValue));
                    } else {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + String.format("%1$,.2f", nominalValue));
                    }
                } else {
                    entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                }
                step.addEntity(entity);
                ++j;
                ++security;
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute12(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(12, this.getStepDescription(lang, 12), this.getStepCondition(lang, 12));
        int security = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int j = 1;
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            while (j <= securities) {
                TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))));
                String valorNumber = TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j);
                String isin = TaxStatementReportSecurityData.getSecurityISIN(doc, i, j);
                String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                String categorySID = TaxStatementReportSecurityData.getSecurityCategory(doc, valorNumber, isin);
                if (category != null) {
                    if (categorySID != null && !categorySID.equals(category)) {
                        entity.setResult(TaxStatementReportResult.ERROR).setRemark("(" + security + ") " + category + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + categorySID);
                    } else if (category.equals("BOND") || category.equals("COINBULL") || category.equals("CURRNOTE") || category.equals("DEVT") || category.equals("FUND") || category.equals("LIBOSWAP") || category.equals("OPTION") || category.equals("SHARE") || category.equals("OTHER")) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + category);
                    } else {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + category);
                    }
                } else {
                    entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                }
                step.addEntity(entity);
                ++j;
                ++security;
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute13(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(13, this.getStepDescription(lang, 13), this.getStepCondition(lang, 13));
        int security = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int j = 1;
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            while (j <= securities) {
                TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))));
                String securityType = TaxStatementReportSecurityData.getSecurityType(doc, i, j);
                if (securityType != null) {
                    if (securityType.equals("BOND.BOND") || securityType.equals("BOND.OPTION") || securityType.equals("BOND.CONVERTIBLE") || securityType.equals("COINBULL.COINGOLD") || securityType.equals("COINBULL.GOLD") || securityType.equals("COINBULL.PALLADIUM") || securityType.equals("COINBULL.PLATINUM") || securityType.equals("COINBULL.SILVER") || securityType.equals("CURRNOTE.CURRENCY") || securityType.equals("CURRNOTE.CURRYEAR") || securityType.equals("DEVT.COMBINEDPRODUCT") || securityType.equals("DEVT.FUNDSIMILARASSET") || securityType.equals("DEVT.INDEXBASKET") || securityType.equals("FUND.ACCUMULATION") || securityType.equals("FUND.DISTRIBUTION") || securityType.equals("FUND.REALESTATE") || securityType.equals("LIBOSWAP.LIBOR") || securityType.equals("LIBOSWAP.SWAP") || securityType.equals("OPTION.CALL") || securityType.equals("OPTION.PHANTOM") || securityType.equals("OPTION.PUT") || securityType.equals("SHARE.BEARERCERT") || securityType.equals("SHARE.BONUS") || securityType.equals("SHARE.COMMON") || securityType.equals("SHARE.COOP") || securityType.equals("SHARE.LIMITED") || securityType.equals("SHARE.NOMINAL") || securityType.equals("SHARE.PARTCERT") || securityType.equals("SHARE.PREFERRED") || securityType.equals("SHARE.TRANSFERABLE")) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + securityType);
                    } else {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + securityType);
                    }
                } else {
                    entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                }
                step.addEntity(entity);
                ++j;
                ++security;
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute14(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(14, this.getStepDescription(lang, 14), this.getStepCondition(lang, 14));
        int security = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int j = 1;
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            while (j <= securities) {
                TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))));
                String name = TaxStatementReportSecurityData.getSecurityName(doc, i, j);
                if (name != null) {
                    if (name.length() >= 0 && name.length() <= 60) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + name);
                    } else if (name.length() > 60) {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + name.length() + " " + (Object)((Object)TaxStatementReportOperator.GREATER) + " 60");
                    } else {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + name);
                    }
                } else {
                    entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                }
                step.addEntity(entity);
                ++j;
                ++security;
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute15(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(15, this.getStepDescription(lang, 15), this.getStepCondition(lang, 15));
        int security = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int j = 1;
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            while (j <= securities) {
                TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))));
                String taxPeriod = TaxStatementReportSchemaData.getTaxPeriod(doc);
                String valorNumber = TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j);
                String isin = TaxStatementReportSecurityData.getSecurityISIN(doc, i, j);
                String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                Date issueDate = TaxStatementReportSecurityData.getSecurityIssueDate(doc, i, j);
                Date issueDateSID = TaxStatementReportSecurityData.getSecurityIssueDate(doc, valorNumber, isin);
                Date redemptionDate = TaxStatementReportSecurityData.getSecurityRedemptionDate(doc, i, j);
                if (issueDate != null) {
                    int year = Integer.parseInt(new SimpleDateFormat("yyyy").format(issueDate));
                    if (issueDateSID != null && !issueDateSID.equals(issueDate) && category != null && (category.equals("OPTION") || category.equals("OTHER"))) {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + new SimpleDateFormat("dd.MM.yyyy").format(issueDate) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + new SimpleDateFormat("dd.MM.yyyy").format(issueDateSID));
                    } else if (taxPeriod != null && year <= Integer.parseInt(taxPeriod) && redemptionDate != null && !issueDate.after(redemptionDate)) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + new SimpleDateFormat("dd.MM.yyyy").format(issueDate));
                    } else if (taxPeriod != null && year <= Integer.parseInt(taxPeriod) && redemptionDate == null) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + new SimpleDateFormat("dd.MM.yyyy").format(issueDate));
                    } else if (taxPeriod != null && year > Integer.parseInt(taxPeriod)) {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + new SimpleDateFormat("yyyy").format(issueDate) + " " + (Object)((Object)TaxStatementReportOperator.NOTSMALLEREQUAL) + " " + taxPeriod);
                    } else if (redemptionDate != null && issueDate.after(redemptionDate)) {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + new SimpleDateFormat("dd.MM.yyyy").format(issueDate) + " " + (Object)((Object)TaxStatementReportOperator.NOTSMALLEREQUAL) + " " + new SimpleDateFormat("dd.MM.yyyy").format(redemptionDate));
                    } else {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + new SimpleDateFormat("dd.MM.yyyy").format(issueDate));
                    }
                } else {
                    entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                }
                step.addEntity(entity);
                ++j;
                ++security;
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute16(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(16, this.getStepDescription(lang, 16), this.getStepCondition(lang, 16));
        int security = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int j = 1;
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            while (j <= securities) {
                TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))));
                String taxPeriod = TaxStatementReportSchemaData.getTaxPeriod(doc);
                String valorNumber = TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j);
                String isin = TaxStatementReportSecurityData.getSecurityISIN(doc, i, j);
                String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                Date issueDate = TaxStatementReportSecurityData.getSecurityIssueDate(doc, i, j);
                Date redemptionDate = TaxStatementReportSecurityData.getSecurityRedemptionDate(doc, i, j);
                Date redemptionDateSID = TaxStatementReportSecurityData.getSecurityRedemptionDate(doc, valorNumber, isin);
                Double unitPrice = TaxStatementReportSecurityData.getTaxValueUnitPrice(doc, i, j, 1);
                Double value = TaxStatementReportSecurityData.getTaxValueValue(doc, i, j, 1);
                if (redemptionDate != null) {
                    int year = Integer.parseInt(new SimpleDateFormat("yyyy").format(redemptionDate));
                    if (redemptionDateSID != null && !redemptionDateSID.equals(redemptionDate) && category != null && (category.equals("OPTION") || category.equals("OTHER"))) {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + new SimpleDateFormat("dd.MM.yyyy").format(redemptionDate) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + new SimpleDateFormat("dd.MM.yyyy").format(redemptionDateSID));
                    } else if (taxPeriod != null && year >= Integer.parseInt(taxPeriod) && issueDate != null && !redemptionDate.before(issueDate)) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + new SimpleDateFormat("dd.MM.yyyy").format(redemptionDate));
                    } else if (taxPeriod != null && year >= Integer.parseInt(taxPeriod) && issueDate == null) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + new SimpleDateFormat("dd.MM.yyyy").format(redemptionDate));
                    } else if (taxPeriod != null && year < Integer.parseInt(taxPeriod) && (unitPrice != null || value != null)) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + TaxStatementReportUtil.getText(lang, INDEFAULT));
                    } else if (taxPeriod != null && year < Integer.parseInt(taxPeriod)) {
                        entity.setResult(TaxStatementReportResult.WARNING).setReason("(" + security + ") " + new SimpleDateFormat("yyyy").format(redemptionDate) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + taxPeriod);
                    } else if (issueDate != null && redemptionDate.before(issueDate)) {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + new SimpleDateFormat("dd.MM.yyyy").format(redemptionDate) + " " + (Object)((Object)TaxStatementReportOperator.NOTGREATEREQUAL) + " " + new SimpleDateFormat("dd.MM.yyyy").format(issueDate));
                    } else {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + new SimpleDateFormat("dd.MM.yyyy").format(redemptionDate));
                    }
                } else {
                    entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                }
                step.addEntity(entity);
                ++j;
                ++security;
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute17(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(17, this.getStepDescription(lang, 17), this.getStepCondition(lang, 17));
        int security = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int j = 1;
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            while (j <= securities) {
                TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))));
                String taxPeriod = TaxStatementReportSchemaData.getTaxPeriod(doc);
                Date issueDate = TaxStatementReportSecurityData.getSecurityIssueDate(doc, i, j);
                Date redemptionDateEarly = TaxStatementReportSecurityData.getSecurityRedemptionDateEarly(doc, i, j);
                if (redemptionDateEarly != null) {
                    int year = Integer.parseInt(new SimpleDateFormat("yyyy").format(redemptionDateEarly));
                    if (taxPeriod != null && year >= Integer.parseInt(taxPeriod) && issueDate != null && !redemptionDateEarly.before(issueDate)) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + new SimpleDateFormat("dd.MM.yyyy").format(redemptionDateEarly));
                    } else if (taxPeriod != null && year >= Integer.parseInt(taxPeriod) && issueDate == null) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + new SimpleDateFormat("dd.MM.yyyy").format(redemptionDateEarly));
                    } else if (taxPeriod != null && year < Integer.parseInt(taxPeriod)) {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + new SimpleDateFormat("yyyy").format(redemptionDateEarly) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + taxPeriod);
                    } else if (issueDate != null && redemptionDateEarly.before(issueDate)) {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + new SimpleDateFormat("dd.MM.yyyy").format(redemptionDateEarly) + " " + (Object)((Object)TaxStatementReportOperator.NOTGREATEREQUAL) + " " + new SimpleDateFormat("dd.MM.yyyy").format(issueDate));
                    } else {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + new SimpleDateFormat("dd.MM.yyyy").format(redemptionDateEarly));
                    }
                } else {
                    entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                }
                step.addEntity(entity);
                ++j;
                ++security;
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute18(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(18, this.getStepDescription(lang, 18), this.getStepCondition(lang, 18));
        int security = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int j = 1;
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            while (j <= securities) {
                TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))));
                Double issuePrice = TaxStatementReportSecurityData.getSecurityIssuePrice(doc, i, j);
                if (issuePrice != null) {
                    if (issuePrice >= 0.0) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + String.format("%1$,.2f", issuePrice));
                    } else {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + String.format("%1$,.2f", issuePrice));
                    }
                } else {
                    entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                }
                step.addEntity(entity);
                ++j;
                ++security;
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute19(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(19, this.getStepDescription(lang, 19), this.getStepCondition(lang, 19));
        int security = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int j = 1;
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            while (j <= securities) {
                TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))));
                Double redemptionPrice = TaxStatementReportSecurityData.getSecurityRedemptionPrice(doc, i, j);
                if (redemptionPrice != null) {
                    if (redemptionPrice >= 0.0) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + String.format("%1$,.2f", redemptionPrice));
                    } else {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + String.format("%1$,.2f", redemptionPrice));
                    }
                } else {
                    entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                }
                step.addEntity(entity);
                ++j;
                ++security;
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute20(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(20, this.getStepDescription(lang, 20), this.getStepCondition(lang, 20));
        int security = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int j = 1;
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            while (j <= securities) {
                TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))));
                Double redemptionPriceEarly = TaxStatementReportSecurityData.getSecurityRedemptionPriceEarly(doc, i, j);
                if (redemptionPriceEarly != null) {
                    if (redemptionPriceEarly >= 0.0) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + String.format("%1$,.2f", redemptionPriceEarly));
                    } else {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + String.format("%1$,.2f", redemptionPriceEarly));
                    }
                } else {
                    entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                }
                step.addEntity(entity);
                ++j;
                ++security;
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute21(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(21, this.getStepDescription(lang, 21), this.getStepCondition(lang, 21));
        int security = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int j = 1;
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            while (j <= securities) {
                TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))));
                String category = TaxStatementReportSecurityData.getSecurityCategory(doc, i, j);
                Double interestRate = TaxStatementReportSecurityData.getSecurityInterestRate(doc, i, j);
                if (interestRate != null) {
                    if (interestRate >= 0.0) {
                        entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + String.format("%1$,.2f", interestRate) + "%");
                    } else if (category != null && category.equals("OTHER")) {
                        entity.setResult(TaxStatementReportResult.IGNORE).setReason("(" + security + ") " + String.format("%1$,.2f", interestRate) + "%");
                    } else {
                        entity.setResult(TaxStatementReportResult.ERROR).setReason("(" + security + ") " + String.format("%1$,.2f", interestRate) + "%");
                    }
                } else {
                    entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
                }
                step.addEntity(entity);
                ++j;
                ++security;
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute22(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(22, this.getStepDescription(lang, 22), this.getStepCondition(lang, 22));
        int security = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int j = 1;
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            while (j <= securities) {
                TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))));
                Boolean variableInterest = TaxStatementReportSecurityData.getSecurityVariableInterest(doc, i, j);
                entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + variableInterest);
                step.addEntity(entity);
                ++j;
                ++security;
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute23(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(23, this.getStepDescription(lang, 23), this.getStepCondition(lang, 23));
        int security = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int j = 1;
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            while (j <= securities) {
                TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))));
                Boolean iup = TaxStatementReportSecurityData.getSecurityIUP(doc, i, j);
                entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + iup);
                step.addEntity(entity);
                ++j;
                ++security;
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    protected TaxStatementReportResultStep execute24(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(24, this.getStepDescription(lang, 24), this.getStepCondition(lang, 24));
        int security = 1;
        int depots = TaxStatementReportSecurityData.getDepotCount(doc);
        for (int i = 1; i <= depots; ++i) {
            int j = 1;
            int securities = TaxStatementReportSecurityData.getSecurityCount(doc, i);
            while (j <= securities) {
                TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity(TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityValorNumber(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityISIN(doc, i, j), TaxStatementReportUtil.nvl(TaxStatementReportSecurityData.getSecurityName(doc, i, j), TaxStatementReportSecurityData.getSecurityPositionId(doc, i, j)))));
                Boolean bfp = TaxStatementReportSecurityData.getSecurityBFP(doc, i, j);
                entity.setResult(TaxStatementReportResult.OK).setRemark("(" + security + ") " + bfp);
                step.addEntity(entity);
                ++j;
                ++security;
            }
        }
        if (step.getEntities() == null || step.getEntities().size() == 0) {
            step.addEntity(new TaxStatementReportResultEntity(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE));
        }
        return step;
    }

    @Override
    public TaxStatementReportResultCase execute(Document doc, byte[] xml, Properties lang, TaxStatementReportFormula formula) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultCase cs = new TaxStatementReportResultCase(this.getCaseGroup(), this.getCaseId(), this.getCaseGroup(lang), this.getCaseName(lang), this.getCaseDescription(lang));
        TaxStatementReportResult[][] ok = new TaxStatementReportResult[][]{new TaxStatementReportResult[0], {TaxStatementReportResult.ERROR, TaxStatementReportResult.OK, TaxStatementReportResult.OK}, {null, TaxStatementReportResult.ERROR, TaxStatementReportResult.OK}, {null, null, TaxStatementReportResult.OK}, {null, null, TaxStatementReportResult.OK}, {null, null, null}, {null, null, null}, {null, null, TaxStatementReportResult.OK}, {null, null, null}, {null, null, TaxStatementReportResult.OK}, {null, null, TaxStatementReportResult.OK}, {null, null, null}, {null, null, TaxStatementReportResult.OK}, {null, null, null}, {null, null, TaxStatementReportResult.OK}, {null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}};
        cs.addStepResultOptional(ok[1], this.execute01(doc, lang, formula));
        cs.addStepResultOptional(ok[2], this.execute02(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getSecurityCount(doc) > 0));
        cs.addStepResultMandatory(ok[3], this.execute03(doc, lang, formula, TaxStatementReportSecurityData.getSecurityCount(doc) > 0));
        cs.addStepResultMandatory(ok[4], this.execute04(doc, lang, formula, TaxStatementReportSecurityData.getSecurityCount(doc) > 0));
        cs.addStepResultOptional(ok[5], this.execute05(doc, lang, formula, TaxStatementReportSecurityData.getSecurityCount(doc) > 0 && TaxStatementReportSecurityData.getSecurityValorNumber(doc)));
        cs.addStepResultOptional(ok[6], this.execute06(doc, lang, formula, TaxStatementReportSecurityData.getTotalTaxValue(doc) != null && TaxStatementReportSecurityData.getSecurityCount(doc) > 0 && TaxStatementReportSecurityData.getSecurityISIN(doc)));
        cs.addStepResultMandatory(ok[7], this.execute07(doc, lang, formula, TaxStatementReportSecurityData.getSecurityCount(doc) > 0));
        cs.addStepResultOptional(ok[8], this.execute08(doc, lang, formula, TaxStatementReportSecurityData.getSecurityCount(doc) > 0 && TaxStatementReportSecurityData.getSecurityCity(doc)));
        cs.addStepResultMandatory(ok[9], this.execute09(doc, lang, formula, TaxStatementReportSecurityData.getSecurityCount(doc) > 0));
        cs.addStepResultMandatory(ok[10], this.execute10(doc, lang, formula, TaxStatementReportSecurityData.getSecurityCount(doc) > 0));
        cs.addStepResultOptional(ok[11], this.execute11(doc, lang, formula, TaxStatementReportSecurityData.getSecurityCount(doc) > 0 && TaxStatementReportSecurityData.getSecurityNominalValue(doc)));
        cs.addStepResultMandatory(ok[12], this.execute12(doc, lang, formula, TaxStatementReportSecurityData.getSecurityCount(doc) > 0));
        cs.addStepResultOptional(ok[13], this.execute13(doc, lang, formula, TaxStatementReportSecurityData.getSecurityCount(doc) > 0 && TaxStatementReportSecurityData.getSecurityType(doc)));
        cs.addStepResultMandatory(ok[14], this.execute14(doc, lang, formula, TaxStatementReportSecurityData.getSecurityCount(doc) > 0));
        cs.addStepResultOptional(ok[15], this.execute15(doc, lang, formula, TaxStatementReportSecurityData.getSecurityCount(doc) > 0 && TaxStatementReportSecurityData.getSecurityIssueDate(doc)));
        cs.addStepResultOptional(ok[16], this.execute16(doc, lang, formula, TaxStatementReportSecurityData.getSecurityCount(doc) > 0 && TaxStatementReportSecurityData.getSecurityRedemptionDate(doc)));
        cs.addStepResultOptional(ok[17], this.execute17(doc, lang, formula, TaxStatementReportSecurityData.getSecurityCount(doc) > 0 && TaxStatementReportSecurityData.getSecurityRedemptionDateEarly(doc)));
        cs.addStepResultOptional(ok[18], this.execute18(doc, lang, formula, TaxStatementReportSecurityData.getSecurityCount(doc) > 0 && TaxStatementReportSecurityData.getSecurityIssuePrice(doc)));
        cs.addStepResultOptional(ok[19], this.execute19(doc, lang, formula, TaxStatementReportSecurityData.getSecurityCount(doc) > 0 && TaxStatementReportSecurityData.getSecurityRedemptionPrice(doc)));
        cs.addStepResultOptional(ok[20], this.execute20(doc, lang, formula, TaxStatementReportSecurityData.getSecurityCount(doc) > 0 && TaxStatementReportSecurityData.getSecurityRedemptionPriceEarly(doc)));
        cs.addStepResultOptional(ok[21], this.execute21(doc, lang, formula, TaxStatementReportSecurityData.getSecurityCount(doc) > 0 && TaxStatementReportSecurityData.getSecurityInterestRate(doc)));
        cs.addStepResultOptional(ok[22], this.execute22(doc, lang, formula, TaxStatementReportSecurityData.getSecurityCount(doc) > 0));
        cs.addStepResultOptional(ok[23], this.execute23(doc, lang, formula, TaxStatementReportSecurityData.getSecurityCount(doc) > 0));
        cs.addStepResultOptional(ok[24], this.execute24(doc, lang, formula, TaxStatementReportSecurityData.getSecurityCount(doc) > 0));
        return cs;
    }

    public TaxStatementReportSecurityCase01() {
        super("SECURITY_CASE", 1);
    }
}

