/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.report;

import ch.ewv.taxstatement.report.TaxStatementReportCase;
import ch.ewv.taxstatement.report.TaxStatementReportFormula;
import ch.ewv.taxstatement.report.TaxStatementReportOperator;
import ch.ewv.taxstatement.report.TaxStatementReportResult;
import ch.ewv.taxstatement.report.TaxStatementReportResultCase;
import ch.ewv.taxstatement.report.TaxStatementReportResultEntity;
import ch.ewv.taxstatement.report.TaxStatementReportResultStep;
import ch.ewv.taxstatement.report.TaxStatementReportSchemaData;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class TaxStatementReportSchemaCase05
extends TaxStatementReportCase {
    protected TaxStatementReportResultStep execute01(Document doc, Properties lang, TaxStatementReportFormula formula) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity();
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(1, this.getStepDescription(lang, 1), this.getStepCondition(lang, 1));
        String taxPeriod = TaxStatementReportSchemaData.getTaxPeriod(doc);
        if (taxPeriod != null && taxPeriod.length() > 0) {
            if (taxPeriod.length() == 4) {
                if (taxPeriod.charAt(0) >= '2' && taxPeriod.charAt(0) <= '2' && taxPeriod.charAt(1) >= '0' && taxPeriod.charAt(1) <= '0' && taxPeriod.charAt(2) >= '1' && taxPeriod.charAt(2) <= '9' && taxPeriod.charAt(3) >= '0' && taxPeriod.charAt(3) <= '9') {
                    entity.setResult(TaxStatementReportResult.OK).setReason(taxPeriod);
                } else {
                    entity.setResult(TaxStatementReportResult.ERROR).setReason(taxPeriod);
                }
            } else {
                entity.setResult(TaxStatementReportResult.ERROR).setReason(taxPeriod);
            }
        } else {
            entity.setResult(TaxStatementReportResult.ERROR);
        }
        step.addEntity(entity);
        return step;
    }

    protected TaxStatementReportResultStep execute02(Document doc, Properties lang, TaxStatementReportFormula formula) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity();
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(2, this.getStepDescription(lang, 2), this.getStepCondition(lang, 2));
        String taxPeriod = TaxStatementReportSchemaData.getTaxPeriod(doc);
        Date periodFrom = TaxStatementReportSchemaData.getPeriodFrom(doc);
        Date periodTo = TaxStatementReportSchemaData.getPeriodTo(doc);
        if (periodFrom != null) {
            int year = Integer.parseInt(new SimpleDateFormat("yyyy").format(periodFrom));
            if (taxPeriod != null && year <= Integer.parseInt(taxPeriod) && periodTo != null && !periodFrom.after(periodTo)) {
                entity.setResult(TaxStatementReportResult.OK).setReason(new SimpleDateFormat("dd.MM.yyyy").format(periodFrom));
            } else if (taxPeriod != null && year > Integer.parseInt(taxPeriod)) {
                entity.setResult(TaxStatementReportResult.ERROR).setReason(new SimpleDateFormat("yyyy").format(periodFrom) + " " + (Object)((Object)TaxStatementReportOperator.NOTSMALLEREQUAL) + " " + taxPeriod);
            } else if (periodTo != null && periodFrom.after(periodTo)) {
                entity.setResult(TaxStatementReportResult.ERROR).setReason(new SimpleDateFormat("dd.MM.yyyy").format(periodFrom) + " " + (Object)((Object)TaxStatementReportOperator.NOTSMALLEREQUAL) + " " + new SimpleDateFormat("dd.MM.yyyy").format(periodTo));
            } else {
                entity.setResult(TaxStatementReportResult.ERROR).setReason(new SimpleDateFormat("dd.MM.yyyy").format(periodFrom));
            }
        } else {
            entity.setResult(TaxStatementReportResult.ERROR);
        }
        step.addEntity(entity);
        return step;
    }

    protected TaxStatementReportResultStep execute03(Document doc, Properties lang, TaxStatementReportFormula formula) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity();
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(3, this.getStepDescription(lang, 3), this.getStepCondition(lang, 3));
        String taxPeriod = TaxStatementReportSchemaData.getTaxPeriod(doc);
        Date periodFrom = TaxStatementReportSchemaData.getPeriodFrom(doc);
        Date periodTo = TaxStatementReportSchemaData.getPeriodTo(doc);
        if (periodTo != null) {
            int year = Integer.parseInt(new SimpleDateFormat("yyyy").format(periodTo));
            if (taxPeriod != null && year == Integer.parseInt(taxPeriod) && periodFrom != null && !periodTo.before(periodFrom)) {
                entity.setResult(TaxStatementReportResult.OK).setReason(new SimpleDateFormat("dd.MM.yyyy").format(periodTo));
            } else if (taxPeriod != null && year != Integer.parseInt(taxPeriod)) {
                entity.setResult(TaxStatementReportResult.ERROR).setReason(new SimpleDateFormat("yyyy").format(periodTo) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + taxPeriod);
            } else if (periodFrom != null && periodTo.before(periodFrom)) {
                entity.setResult(TaxStatementReportResult.ERROR).setReason(new SimpleDateFormat("dd.MM.yyyy").format(periodTo) + " " + (Object)((Object)TaxStatementReportOperator.NOTGREATEREQUAL) + " " + new SimpleDateFormat("dd.MM.yyyy").format(periodFrom));
            } else {
                entity.setResult(TaxStatementReportResult.ERROR).setReason(new SimpleDateFormat("dd.MM.yyyy").format(periodTo));
            }
        } else {
            entity.setResult(TaxStatementReportResult.ERROR);
        }
        step.addEntity(entity);
        return step;
    }

    @Override
    public TaxStatementReportResultCase execute(Document doc, byte[] xml, Properties lang, TaxStatementReportFormula formula) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultCase cs = new TaxStatementReportResultCase(this.getCaseGroup(), this.getCaseId(), this.getCaseGroup(lang), this.getCaseName(lang), this.getCaseDescription(lang));
        TaxStatementReportResult[][] ok = new TaxStatementReportResult[][]{new TaxStatementReportResult[0], {TaxStatementReportResult.OK}, {TaxStatementReportResult.OK}, {TaxStatementReportResult.OK}};
        cs.addStepResultMandatory(ok[1], this.execute01(doc, lang, formula));
        cs.addStepResultMandatory(ok[2], this.execute02(doc, lang, formula));
        cs.addStepResultMandatory(ok[3], this.execute03(doc, lang, formula));
        return cs;
    }

    public TaxStatementReportSchemaCase05() {
        super("SCHEMA_CASE", 5);
    }
}

