/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.report;

import ch.ewv.taxstatement.report.TaxStatementReportCase;
import ch.ewv.taxstatement.report.TaxStatementReportFormula;
import ch.ewv.taxstatement.report.TaxStatementReportResult;
import ch.ewv.taxstatement.report.TaxStatementReportResultCase;
import ch.ewv.taxstatement.report.TaxStatementReportResultEntity;
import ch.ewv.taxstatement.report.TaxStatementReportResultStep;
import ch.ewv.taxstatement.report.TaxStatementReportSchemaData;
import java.io.IOException;
import java.text.ParseException;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class TaxStatementReportSchemaCase03
extends TaxStatementReportCase {
    protected TaxStatementReportResultStep execute01(Document doc, Properties lang, TaxStatementReportFormula formula) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity();
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(1, this.getStepDescription(lang, 1), this.getStepCondition(lang, 1));
        String minor = TaxStatementReportSchemaData.getMinorVersion(doc);
        String version = TaxStatementReportSchemaData.getSchemaVersion(doc, "/eCH-0196/");
        if (version != null && version.equals("eCH-0196/2") && minor != null && minor.equals("21")) {
            entity.setResult(TaxStatementReportResult.OK).setReason(version);
        } else if (version != null && version.equals("eCH-0196/2") && minor != null && minor.equals("22")) {
            entity.setResult(TaxStatementReportResult.OK).setReason(version);
        } else {
            entity.setResult(TaxStatementReportResult.ERROR).setReason(version);
        }
        step.addEntity(entity);
        return step;
    }

    protected TaxStatementReportResultStep execute02(Document doc, Properties lang, TaxStatementReportFormula formula) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity();
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(2, this.getStepDescription(lang, 2), this.getStepCondition(lang, 2));
        String version = TaxStatementReportSchemaData.getSchemaVersion(doc, "/eCH-0097/");
        if (version != null && version.equals("eCH-0097/4")) {
            entity.setResult(TaxStatementReportResult.OK).setReason(version);
        } else if (version != null && version.indexOf("eCH-0097/") < 0) {
            entity.setResult(TaxStatementReportResult.IGNORE).setReason(version);
        } else {
            entity.setResult(TaxStatementReportResult.ERROR).setReason(version);
        }
        step.addEntity(entity);
        return step;
    }

    protected TaxStatementReportResultStep execute03(Document doc, Properties lang, TaxStatementReportFormula formula) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity();
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(3, this.getStepDescription(lang, 3), this.getStepCondition(lang, 3));
        String version = TaxStatementReportSchemaData.getSchemaVersion(doc, "/eCH-0007/");
        if (version != null && version.indexOf("eCH-0007/") < 0) {
            entity.setResult(TaxStatementReportResult.OK);
        } else {
            entity.setResult(TaxStatementReportResult.IGNORE).setReason(version);
        }
        step.addEntity(entity);
        return step;
    }

    protected TaxStatementReportResultStep execute04(Document doc, Properties lang, TaxStatementReportFormula formula) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity();
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(4, this.getStepDescription(lang, 4), this.getStepCondition(lang, 4));
        String version = TaxStatementReportSchemaData.getSchemaVersion(doc, "/eCH-0008/");
        if (version != null && version.indexOf("eCH-0008/") < 0) {
            entity.setResult(TaxStatementReportResult.OK);
        } else {
            entity.setResult(TaxStatementReportResult.IGNORE).setReason(version);
        }
        step.addEntity(entity);
        return step;
    }

    protected TaxStatementReportResultStep execute05(Document doc, Properties lang, TaxStatementReportFormula formula) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity();
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(5, this.getStepDescription(lang, 5), this.getStepCondition(lang, 5));
        String version = TaxStatementReportSchemaData.getSchemaVersion(doc, "/eCH-0010/");
        if (version != null && version.indexOf("eCH-0010/") < 0) {
            entity.setResult(TaxStatementReportResult.OK);
        } else {
            entity.setResult(TaxStatementReportResult.IGNORE).setReason(version);
        }
        step.addEntity(entity);
        return step;
    }

    @Override
    public TaxStatementReportResultCase execute(Document doc, byte[] xml, Properties lang, TaxStatementReportFormula formula) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultCase cs = new TaxStatementReportResultCase(this.getCaseGroup(), this.getCaseId(), this.getCaseGroup(lang), this.getCaseName(lang), this.getCaseDescription(lang));
        TaxStatementReportResult[][] ok = new TaxStatementReportResult[][]{new TaxStatementReportResult[0], {TaxStatementReportResult.OK}, {TaxStatementReportResult.OK}, {null}, {null}, {null}};
        cs.addStepResultMandatory(ok[1], this.execute01(doc, lang, formula));
        cs.addStepResultMandatory(ok[2], this.execute02(doc, lang, formula));
        cs.addStepResultOptional(ok[3], this.execute03(doc, lang, formula));
        cs.addStepResultOptional(ok[4], this.execute04(doc, lang, formula));
        cs.addStepResultOptional(ok[5], this.execute05(doc, lang, formula));
        return cs;
    }

    public TaxStatementReportSchemaCase03() {
        super("SCHEMA_CASE", 3);
    }
}

