/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.report;

import ch.ewv.taxstatement.TaxStatement;
import ch.ewv.taxstatement.report.TaxStatementReportCase;
import ch.ewv.taxstatement.report.TaxStatementReportFormula;
import ch.ewv.taxstatement.report.TaxStatementReportResult;
import ch.ewv.taxstatement.report.TaxStatementReportResultCase;
import ch.ewv.taxstatement.report.TaxStatementReportResultEntity;
import ch.ewv.taxstatement.report.TaxStatementReportResultStep;
import ch.ewv.taxstatement.report.TaxStatementReportUtil;
import java.io.IOException;
import java.text.ParseException;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class TaxStatementReportSchemaCase01
extends TaxStatementReportCase {
    public static final String SCHEMA_INVALID = "SCHEMA_INVALID";
    public static final String SCHEMA_VALID = "SCHEMA_VALID";

    protected TaxStatementReportResultStep execute01(Document doc, byte[] xml, Properties lang, TaxStatementReportFormula formula) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity();
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(1, this.getStepDescription(lang, 1), this.getStepCondition(lang, 1));
        if (TaxStatement.validateXML(xml)) {
            entity.setResult(TaxStatementReportResult.OK).setReason(TaxStatementReportUtil.getText(lang, SCHEMA_VALID));
        } else {
            entity.setResult(TaxStatementReportResult.FATAL).setReason(TaxStatement.validateXMLMessage(xml));
            System.out.println(TaxStatementReportUtil.getText(lang, SCHEMA_INVALID));
            System.out.println(TaxStatement.validateXMLMessage(xml));
            System.setProperty("EXIT", "1");
        }
        step.addEntity(entity);
        return step;
    }

    @Override
    public TaxStatementReportResultCase execute(Document doc, byte[] xml, Properties lang, TaxStatementReportFormula formula) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultCase cs = new TaxStatementReportResultCase(this.getCaseGroup(), this.getCaseId(), this.getCaseGroup(lang), this.getCaseName(lang), this.getCaseDescription(lang));
        TaxStatementReportResult[][] ok = new TaxStatementReportResult[][]{new TaxStatementReportResult[0], {TaxStatementReportResult.OK}};
        cs.addStepResultMandatory(ok[1], this.execute01(doc, xml, lang, formula));
        return cs;
    }

    public TaxStatementReportSchemaCase01() {
        super("SCHEMA_CASE", 1);
    }
}

