/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.report;

import ch.ewv.taxstatement.report.TaxStatementReportResult;
import ch.ewv.taxstatement.report.TaxStatementReportResultCase;
import ch.ewv.taxstatement.report.TaxStatementReportResultEntity;
import java.util.ArrayList;
import java.util.List;

public class TaxStatementReportResultStep {
    private int stepId;
    private String description;
    private String condition;
    private TaxStatementReportResult required;
    private List<TaxStatementReportResult> resultOK;
    private List<TaxStatementReportResultEntity> entities;

    public int getStepId() {
        return this.stepId;
    }

    public void setStepId(int stepId) {
        this.stepId = stepId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public TaxStatementReportResult getRequired() {
        return this.required;
    }

    public void setRequired(TaxStatementReportResult required) {
        this.required = required;
    }

    public TaxStatementReportResult getResult() {
        TaxStatementReportResult result = null;
        if (this.getEntities() != null) {
            for (TaxStatementReportResultEntity entity : this.getEntities()) {
                if (result == null) {
                    result = entity.getResult();
                    continue;
                }
                if (entity.getResult() == TaxStatementReportResult.FATAL) {
                    result = entity.getResult();
                    continue;
                }
                if (entity.getResult() == TaxStatementReportResult.ERROR && result != TaxStatementReportResult.FATAL) {
                    result = entity.getResult();
                    continue;
                }
                if (entity.getResult() == TaxStatementReportResult.WARNING && result != TaxStatementReportResult.FATAL && result != TaxStatementReportResult.ERROR) {
                    result = entity.getResult();
                    continue;
                }
                if (entity.getResult() == TaxStatementReportResult.OK && result != TaxStatementReportResult.FATAL && result != TaxStatementReportResult.ERROR && result != TaxStatementReportResult.WARNING) {
                    result = entity.getResult();
                    continue;
                }
                if (entity.getResult() != TaxStatementReportResult.IGNORE || result == TaxStatementReportResult.FATAL || result == TaxStatementReportResult.ERROR || result == TaxStatementReportResult.WARNING || result == TaxStatementReportResult.OK) continue;
                result = entity.getResult();
            }
        }
        return result;
    }

    public String getReason() {
        String reason = new String("");
        String reasonLast = null;
        if (this.getEntities() != null) {
            for (TaxStatementReportResultEntity entity : this.getEntities()) {
                if (entity.getReason() == null) continue;
                if (reasonLast == null || !reasonLast.equals(entity.getReason())) {
                    if (reason.length() > 0) {
                        reason = reason + "\r\n";
                    }
                    reason = reason + entity.getReason();
                }
                reasonLast = entity.getReason();
            }
        }
        return reason;
    }

    public String getReasonERROR() {
        String reason = new String("");
        String reasonLast = null;
        if (this.getEntities() != null) {
            for (TaxStatementReportResultEntity entity : this.getEntities()) {
                if (entity.getReason() == null || entity.getResult() != TaxStatementReportResult.ERROR && entity.getResult() != TaxStatementReportResult.FATAL && entity.getResult() != TaxStatementReportResult.WARNING) continue;
                if (reasonLast == null || !reasonLast.equals(entity.getReason())) {
                    if (reason.length() > 0) {
                        reason = reason + "\r\n";
                    }
                    reason = reason + entity.getReason();
                }
                reasonLast = entity.getReason();
            }
        }
        return reason;
    }

    public String getReasonRemark(TaxStatementReportResultCase cs) {
        String reason = new String("");
        String reasonLast = null;
        if (this.getEntities() != null) {
            for (TaxStatementReportResultEntity entity : this.getEntities()) {
                if (entity.getReason() != null) {
                    if (reasonLast == null || !reasonLast.equals(entity.getReason())) {
                        if (reason.length() > 0) {
                            reason = reason + "\r\n";
                        }
                        reason = reason + entity.getReason();
                    }
                    reasonLast = entity.getReason();
                    continue;
                }
                if (entity.getRemark() == null || cs.getResult(entity) != TaxStatementReportResult.ERROR && cs.getResult(entity) != TaxStatementReportResult.FATAL && cs.getResult(entity) != TaxStatementReportResult.WARNING) continue;
                if (reasonLast == null || !reasonLast.equals(entity.getRemark())) {
                    if (reason.length() > 0) {
                        reason = reason + "\r\n";
                    }
                    reason = reason + entity.getRemark();
                }
                reasonLast = entity.getRemark();
            }
        }
        return reason;
    }

    public List<TaxStatementReportResult> getResultOK() {
        return this.resultOK;
    }

    public TaxStatementReportResult getResultOK(int index) {
        return this.getResultOK() != null && index >= 0 && index < this.getResultOK().size() ? this.getResultOK().get(index) : null;
    }

    public void setResultOK(List<TaxStatementReportResult> resultOK) {
        this.resultOK = resultOK;
    }

    public boolean addResultOK(TaxStatementReportResult resultOK) {
        return this.getResultOK() != null && this.getResultOK().add(resultOK);
    }

    public List<TaxStatementReportResultEntity> getEntities() {
        return this.entities;
    }

    public TaxStatementReportResultEntity getEntity(int index) {
        return this.getEntities() != null && index >= 0 && index < this.getEntities().size() ? this.getEntities().get(index) : null;
    }

    public void setEntities(List<TaxStatementReportResultEntity> entities) {
        this.entities = entities;
    }

    public boolean addEntity(TaxStatementReportResultEntity entity) {
        return this.getEntities() != null && this.getEntities().add(entity);
    }

    public TaxStatementReportResultStep(int stepId, String description, String condition) {
        this.stepId = stepId;
        this.description = description;
        this.condition = condition;
        this.required = null;
        this.resultOK = new ArrayList<TaxStatementReportResult>();
        this.entities = new ArrayList<TaxStatementReportResultEntity>();
    }
}

