/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.report;

import ch.ewv.taxstatement.report.TaxStatementReportResult;
import ch.ewv.taxstatement.report.TaxStatementReportResultEntity;
import ch.ewv.taxstatement.report.TaxStatementReportResultStep;
import java.util.ArrayList;
import java.util.List;

public class TaxStatementReportResultCase {
    private String caseGroup;
    private int caseId;
    private String group;
    private String name;
    private String description;
    private TaxStatementReportResult result;
    private List<TaxStatementReportResultStep> steps;

    public String getCaseGroup() {
        return this.caseGroup;
    }

    public void setCaseGroup(String caseGroup) {
        this.caseGroup = caseGroup;
    }

    public int getCaseId() {
        return this.caseId;
    }

    public void setCaseId(int caseId) {
        this.caseId = caseId;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public TaxStatementReportResult getResult() {
        return this.result;
    }

    public TaxStatementReportResult getResult(int index) {
        TaxStatementReportResult result = TaxStatementReportResult.OK;
        for (TaxStatementReportResultStep step : this.getSteps()) {
            TaxStatementReportResultEntity entity = step.getEntity(index);
            if (entity == null) continue;
            if (result == null) {
                result = entity.getResult();
                continue;
            }
            if (entity.getResult() != TaxStatementReportResult.ERROR && entity.getResult() != TaxStatementReportResult.FATAL && entity.getResult() != TaxStatementReportResult.WARNING) {
                if (entity.getResult() != TaxStatementReportResult.SELECT) continue;
                continue;
            }
            result = entity.getResult();
        }
        return result;
    }

    public TaxStatementReportResult getResult(TaxStatementReportResultEntity entity) {
        TaxStatementReportResult result = TaxStatementReportResult.OK;
        for (TaxStatementReportResultStep step : this.getSteps()) {
            int index = step.getEntities().indexOf(entity);
            if (index < 0) continue;
            result = this.getResult(index);
        }
        return result;
    }

    public void setResult(TaxStatementReportResult result) {
        this.result = result;
    }

    public String getResults() {
        String results = new String("");
        for (TaxStatementReportResultStep step : this.getSteps()) {
            if (step.getResult() != TaxStatementReportResult.ERROR && step.getResult() != TaxStatementReportResult.FATAL && step.getResult() != TaxStatementReportResult.WARNING || step.getRequired() != TaxStatementReportResult.OK) continue;
            String reasonERROR = step.getReasonERROR();
            if (results.length() > 0) {
                results = results + "\r\n";
            }
            if (reasonERROR != null && reasonERROR.length() > 0) {
                results = results + reasonERROR;
                continue;
            }
            results = results + step.getDescription();
        }
        return results;
    }

    public List<TaxStatementReportResultStep> getSteps() {
        return this.steps;
    }

    public void setSteps(List<TaxStatementReportResultStep> steps) {
        this.steps = steps;
    }

    public List<String> getEntities() {
        ArrayList<String> entities = new ArrayList<String>();
        for (TaxStatementReportResultStep step : this.getSteps()) {
            if (entities.size() == 0) {
                for (TaxStatementReportResultEntity entity : step.getEntities()) {
                    if (entity.getId() == null || entity.getId().length() <= 0) continue;
                    entities.add(entity.getId());
                }
                continue;
            }
            if (step.getEntities() == null || entities.size() >= step.getEntities().size()) continue;
            entities = new ArrayList();
            for (TaxStatementReportResultEntity entity : step.getEntities()) {
                if (entity.getId() == null || entity.getId().length() <= 0) continue;
                entities.add(entity.getId());
            }
        }
        return entities;
    }

    public List<TaxStatementReportResultEntity> getEntityResults(int index) {
        ArrayList<TaxStatementReportResultEntity> results = new ArrayList<TaxStatementReportResultEntity>();
        for (TaxStatementReportResultStep step : this.getSteps()) {
            for (TaxStatementReportResultEntity entity : step.getEntities()) {
                if (step.getEntities().indexOf(entity) != index) continue;
                results.add(entity);
            }
        }
        return results;
    }

    public List<Integer> getIndexesERROR() {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        List<String> entities = this.getEntities();
        if (entities != null) {
            for (int i = 0; i < entities.size(); ++i) {
                boolean error = false;
                for (TaxStatementReportResultEntity entity : this.getEntityResults(i)) {
                    if (entity.getResult() != TaxStatementReportResult.ERROR && entity.getResult() != TaxStatementReportResult.FATAL && entity.getResult() != TaxStatementReportResult.WARNING) {
                        if (entity.getResult() != TaxStatementReportResult.SELECT) continue;
                        continue;
                    }
                    if (error) continue;
                    indexes.add(i);
                    error = true;
                }
            }
        }
        return indexes;
    }

    public boolean addStepResultMandatory(TaxStatementReportResult[] ok, TaxStatementReportResultStep step) {
        if (this.getResult() == null) {
            this.setResult(step.getResult());
        } else if (step.getResult() == TaxStatementReportResult.FATAL) {
            this.setResult(step.getResult());
        } else if (step.getResult() == TaxStatementReportResult.ERROR && this.getResult() != TaxStatementReportResult.FATAL) {
            this.setResult(step.getResult());
        } else if (step.getResult() == TaxStatementReportResult.WARNING && this.getResult() != TaxStatementReportResult.FATAL && this.getResult() != TaxStatementReportResult.ERROR) {
            this.setResult(step.getResult());
        } else if (step.getResult() == TaxStatementReportResult.OK && this.getResult() != TaxStatementReportResult.FATAL && this.getResult() != TaxStatementReportResult.ERROR && this.getResult() != TaxStatementReportResult.WARNING) {
            this.setResult(step.getResult());
        } else if (step.getResult() == TaxStatementReportResult.IGNORE && this.getResult() != TaxStatementReportResult.FATAL && this.getResult() != TaxStatementReportResult.ERROR && this.getResult() != TaxStatementReportResult.WARNING && this.getResult() != TaxStatementReportResult.OK) {
            this.setResult(step.getResult());
        } else if (step.getResult() == TaxStatementReportResult.SELECT) {
            // empty if block
        }
        step.setRequired(TaxStatementReportResult.OK);
        if (ok != null && ok.length > 0) {
            for (int i = 0; i < ok.length; ++i) {
                step.addResultOK(ok[i]);
            }
        }
        return this.getSteps().add(step);
    }

    public boolean addStepResultOptional(TaxStatementReportResult[] ok, TaxStatementReportResultStep step) {
        if (this.getResult() == null) {
            this.setResult(step.getResult());
        } else if (step.getResult() == TaxStatementReportResult.FATAL) {
            this.setResult(step.getResult());
        } else if (step.getResult() == TaxStatementReportResult.ERROR && this.getResult() != TaxStatementReportResult.FATAL) {
            this.setResult(step.getResult());
        } else if (step.getResult() == TaxStatementReportResult.WARNING && this.getResult() != TaxStatementReportResult.FATAL && this.getResult() != TaxStatementReportResult.ERROR) {
            this.setResult(step.getResult());
        } else if (step.getResult() == TaxStatementReportResult.OK && this.getResult() != TaxStatementReportResult.FATAL && this.getResult() != TaxStatementReportResult.ERROR && this.getResult() != TaxStatementReportResult.WARNING) {
            this.setResult(step.getResult());
        } else if (step.getResult() == TaxStatementReportResult.IGNORE && this.getResult() != TaxStatementReportResult.FATAL && this.getResult() != TaxStatementReportResult.ERROR && this.getResult() != TaxStatementReportResult.WARNING && this.getResult() != TaxStatementReportResult.OK) {
            this.setResult(step.getResult());
        } else if (step.getResult() == TaxStatementReportResult.SELECT) {
            // empty if block
        }
        step.setRequired(TaxStatementReportResult.ERROR);
        if (ok != null && ok.length > 0) {
            for (int i = 0; i < ok.length; ++i) {
                step.addResultOK(ok[i]);
            }
        }
        return this.getSteps().add(step);
    }

    public TaxStatementReportResultCase(String caseGroup, int caseId, String group, String name, String description) {
        this.caseGroup = caseGroup;
        this.caseId = caseId;
        this.group = group;
        this.name = name;
        this.description = description;
        this.result = null;
        this.steps = new ArrayList<TaxStatementReportResultStep>();
    }

    public TaxStatementReportResultCase(String caseGroup, int caseId, String group, String name, String description, TaxStatementReportResult result) {
        this.caseGroup = caseGroup;
        this.caseId = caseId;
        this.group = group;
        this.name = name;
        this.description = description;
        this.result = result;
        this.steps = new ArrayList<TaxStatementReportResultStep>();
    }
}

