/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.report;

import ch.ewv.taxstatement.report.TaxStatementReportUtil;
import java.text.ParseException;
import java.util.Date;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;

public class TaxStatementReportLiabilityAccountData {
    public static Double getTotalTaxValue(Document doc) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfLiabilities/@totalTaxValue");
    }

    public static Double getTotalTaxValue(Document doc, int account) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfLiabilities/liabilityAccount[" + account + "]/@totalTaxValue");
    }

    public static Double getTotalGrossRevenueB(Document doc) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfLiabilities/@totalGrossRevenueB");
    }

    public static Double getTotalGrossRevenueB(Document doc, int account) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfLiabilities/liabilityAccount[" + account + "]/@totalGrossRevenueB");
    }

    public static int getLiabilityAccountCount(Document doc) throws XPathExpressionException {
        return TaxStatementReportUtil.getCount(doc, "count(/taxStatement/listOfLiabilities/liabilityAccount)");
    }

    public static boolean getLiabilityAccountClosingDate(Document doc) throws ParseException, XPathExpressionException {
        boolean value = true;
        int accounts = TaxStatementReportLiabilityAccountData.getLiabilityAccountCount(doc);
        for (int i = 1; i <= accounts && value; ++i) {
            Date closingDate = TaxStatementReportLiabilityAccountData.getLiabilityAccountClosingDate(doc, i);
            if (closingDate != null) continue;
            value = false;
        }
        return value;
    }

    public static Date getLiabilityAccountClosingDate(Document doc, int account) throws ParseException, XPathExpressionException {
        return TaxStatementReportUtil.getValueDate(doc, "/taxStatement/listOfLiabilities/liabilityAccount[" + account + "]/@closingDate");
    }

    public static String getLiabilityAccountCountry(Document doc, int account) throws XPathExpressionException {
        return TaxStatementReportUtil.getValue(doc, "/taxStatement/listOfLiabilities/liabilityAccount[" + account + "]/@bankAccountCountry");
    }

    public static String getLiabilityAccountCurrency(Document doc, int account) throws XPathExpressionException {
        return TaxStatementReportUtil.getValue(doc, "/taxStatement/listOfLiabilities/liabilityAccount[" + account + "]/@bankAccountCurrency");
    }

    public static boolean getLiabilityAccountIBAN(Document doc) throws XPathExpressionException {
        boolean value = true;
        int accounts = TaxStatementReportLiabilityAccountData.getLiabilityAccountCount(doc);
        for (int i = 1; i <= accounts && value; ++i) {
            String iban = TaxStatementReportLiabilityAccountData.getLiabilityAccountIBAN(doc, i);
            if (iban != null && iban.length() != 0) continue;
            value = false;
        }
        return value;
    }

    public static String getLiabilityAccountIBAN(Document doc, int account) throws XPathExpressionException {
        return TaxStatementReportUtil.getValue(doc, "/taxStatement/listOfLiabilities/liabilityAccount[" + account + "]/@iban");
    }

    public static String getLiabilityAccountName(Document doc, int account) throws XPathExpressionException {
        return TaxStatementReportUtil.getValue(doc, "/taxStatement/listOfLiabilities/liabilityAccount[" + account + "]/@bankAccountName");
    }

    public static boolean getLiabilityAccountNumber(Document doc) throws XPathExpressionException {
        boolean value = true;
        int accounts = TaxStatementReportLiabilityAccountData.getLiabilityAccountCount(doc);
        for (int i = 1; i <= accounts && value; ++i) {
            String number = TaxStatementReportLiabilityAccountData.getLiabilityAccountNumber(doc, i);
            if (number != null && number.length() != 0) continue;
            value = false;
        }
        return value;
    }

    public static String getLiabilityAccountNumber(Document doc, int account) throws XPathExpressionException {
        return TaxStatementReportUtil.getValue(doc, "/taxStatement/listOfLiabilities/liabilityAccount[" + account + "]/@bankAccountNumber");
    }

    public static boolean getLiabilityAccountOpeningDate(Document doc) throws ParseException, XPathExpressionException {
        boolean value = true;
        int accounts = TaxStatementReportLiabilityAccountData.getLiabilityAccountCount(doc);
        for (int i = 1; i <= accounts && value; ++i) {
            Date openingDate = TaxStatementReportLiabilityAccountData.getLiabilityAccountOpeningDate(doc, i);
            if (openingDate != null) continue;
            value = false;
        }
        return value;
    }

    public static Date getLiabilityAccountOpeningDate(Document doc, int account) throws ParseException, XPathExpressionException {
        return TaxStatementReportUtil.getValueDate(doc, "/taxStatement/listOfLiabilities/liabilityAccount[" + account + "]/@openingDate");
    }

    public static int getTaxValueCount(Document doc) throws XPathExpressionException {
        int count = 0;
        int accounts = TaxStatementReportLiabilityAccountData.getLiabilityAccountCount(doc);
        for (int i = 1; i <= accounts; ++i) {
            count += TaxStatementReportLiabilityAccountData.getTaxValueCount(doc, i);
        }
        return count;
    }

    public static int getTaxValueCount(Document doc, int account) throws XPathExpressionException {
        return TaxStatementReportUtil.getCount(doc, "count(/taxStatement/listOfLiabilities/liabilityAccount[" + account + "]/taxValue)");
    }

    public static boolean getTaxValueBalance(Document doc) throws XPathExpressionException {
        boolean value = true;
        int accounts = TaxStatementReportLiabilityAccountData.getLiabilityAccountCount(doc);
        for (int i = 1; i <= accounts && value; ++i) {
            int taxValues = TaxStatementReportLiabilityAccountData.getTaxValueCount(doc, i);
            for (int j = 1; j <= taxValues && value; ++j) {
                Double balance = TaxStatementReportLiabilityAccountData.getTaxValueBalance(doc, i, j);
                if (balance != null) continue;
                value = false;
            }
        }
        return value;
    }

    public static Double getTaxValueBalance(Document doc, int account, int taxValue) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfLiabilities/liabilityAccount[" + account + "]/taxValue[" + taxValue + "]/@balance");
    }

    public static boolean getTaxValueBalanceCurrency(Document doc) throws XPathExpressionException {
        boolean value = true;
        int accounts = TaxStatementReportLiabilityAccountData.getLiabilityAccountCount(doc);
        for (int i = 1; i <= accounts && value; ++i) {
            int taxValues = TaxStatementReportLiabilityAccountData.getTaxValueCount(doc, i);
            for (int j = 1; j <= taxValues && value; ++j) {
                String currency = TaxStatementReportLiabilityAccountData.getTaxValueBalanceCurrency(doc, i, j);
                if (currency == null || !currency.equals("CHF")) continue;
                value = false;
            }
        }
        return value;
    }

    public static String getTaxValueBalanceCurrency(Document doc, int account, int taxValue) throws XPathExpressionException {
        return TaxStatementReportUtil.getValue(doc, "/taxStatement/listOfLiabilities/liabilityAccount[" + account + "]/taxValue[" + taxValue + "]/@balanceCurrency");
    }

    public static boolean getTaxValueExchangeRate(Document doc) throws XPathExpressionException {
        boolean value = true;
        int accounts = TaxStatementReportLiabilityAccountData.getLiabilityAccountCount(doc);
        for (int i = 1; i <= accounts && value; ++i) {
            int taxValues = TaxStatementReportLiabilityAccountData.getTaxValueCount(doc, i);
            for (int j = 1; j <= taxValues && value; ++j) {
                Double exchangeRate = TaxStatementReportLiabilityAccountData.getTaxValueExchangeRate(doc, i, j);
                if (exchangeRate != null) continue;
                value = false;
            }
        }
        return value;
    }

    public static Double getTaxValueExchangeRate(Document doc, int account, int taxValue) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfLiabilities/liabilityAccount[" + account + "]/taxValue[" + taxValue + "]/@exchangeRate");
    }

    public static boolean getTaxValueName(Document doc) throws XPathExpressionException {
        boolean value = true;
        int accounts = TaxStatementReportLiabilityAccountData.getLiabilityAccountCount(doc);
        for (int i = 1; i <= accounts && value; ++i) {
            int taxValues = TaxStatementReportLiabilityAccountData.getTaxValueCount(doc, i);
            for (int j = 1; j <= taxValues && value; ++j) {
                String name = TaxStatementReportLiabilityAccountData.getTaxValueName(doc, i, j);
                if (name != null && name.length() != 0) continue;
                value = false;
            }
        }
        return value;
    }

    public static String getTaxValueName(Document doc, int account, int taxValue) throws XPathExpressionException {
        return TaxStatementReportUtil.getValue(doc, "/taxStatement/listOfLiabilities/liabilityAccount[" + account + "]/taxValue[" + taxValue + "]/@name");
    }

    public static Date getTaxValueReferenceDate(Document doc, int account, int taxValue) throws ParseException, XPathExpressionException {
        return TaxStatementReportUtil.getValueDate(doc, "/taxStatement/listOfLiabilities/liabilityAccount[" + account + "]/taxValue[" + taxValue + "]/@referenceDate");
    }

    public static Double getTaxValueValue(Document doc, int account) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfLiabilities/liabilityAccount[" + account + "]/taxValue/@value");
    }

    public static Double getTaxValueValue(Document doc, int account, int taxValue) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfLiabilities/liabilityAccount[" + account + "]/taxValue[" + taxValue + "]/@value");
    }

    public static int getPaymentCount(Document doc) throws XPathExpressionException {
        int count = 0;
        int accounts = TaxStatementReportLiabilityAccountData.getLiabilityAccountCount(doc);
        for (int i = 1; i <= accounts; ++i) {
            count += TaxStatementReportLiabilityAccountData.getPaymentCount(doc, i);
        }
        return count;
    }

    public static int getPaymentCount(Document doc, int account) throws XPathExpressionException {
        return TaxStatementReportUtil.getCount(doc, "count(/taxStatement/listOfLiabilities/liabilityAccount[" + account + "]/payment)");
    }

    public static boolean getPaymentAmount(Document doc) throws XPathExpressionException {
        boolean value = true;
        int accounts = TaxStatementReportLiabilityAccountData.getLiabilityAccountCount(doc);
        for (int i = 1; i <= accounts && value; ++i) {
            int payments = TaxStatementReportLiabilityAccountData.getPaymentCount(doc, i);
            for (int j = 1; j <= payments && value; ++j) {
                Double amount = TaxStatementReportLiabilityAccountData.getPaymentAmount(doc, i, j);
                if (amount != null) continue;
                value = false;
            }
        }
        return value;
    }

    public static Double getPaymentAmount(Document doc, int account, int payment) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfLiabilities/liabilityAccount[" + account + "]/payment[" + payment + "]/@amount");
    }

    public static boolean getPaymentAmountCurrency(Document doc) throws XPathExpressionException {
        boolean value = true;
        int accounts = TaxStatementReportLiabilityAccountData.getLiabilityAccountCount(doc);
        for (int i = 1; i <= accounts && value; ++i) {
            int payments = TaxStatementReportLiabilityAccountData.getPaymentCount(doc, i);
            for (int j = 1; j <= payments && value; ++j) {
                String currency = TaxStatementReportLiabilityAccountData.getPaymentAmountCurrency(doc, i, j);
                if (currency == null || !currency.equals("CHF")) continue;
                value = false;
            }
        }
        return value;
    }

    public static String getPaymentAmountCurrency(Document doc, int account, int payment) throws XPathExpressionException {
        return TaxStatementReportUtil.getValue(doc, "/taxStatement/listOfLiabilities/liabilityAccount[" + account + "]/payment[" + payment + "]/@amountCurrency");
    }

    public static boolean getPaymentExchangeRate(Document doc) throws XPathExpressionException {
        boolean value = true;
        int accounts = TaxStatementReportLiabilityAccountData.getLiabilityAccountCount(doc);
        for (int i = 1; i <= accounts && value; ++i) {
            int payments = TaxStatementReportLiabilityAccountData.getPaymentCount(doc, i);
            for (int j = 1; j <= payments && value; ++j) {
                Double exchangeRate = TaxStatementReportLiabilityAccountData.getPaymentExchangeRate(doc, i, j);
                if (exchangeRate != null) continue;
                value = false;
            }
        }
        return value;
    }

    public static Double getPaymentExchangeRate(Document doc, int account, int payment) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfLiabilities/liabilityAccount[" + account + "]/payment[" + payment + "]/@exchangeRate");
    }

    public static Double getPaymentGrossRevenueB(Document doc, int account, int payment) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfLiabilities/liabilityAccount[" + account + "]/payment[" + payment + "]/@grossRevenueB");
    }

    public static boolean getPaymentName(Document doc) throws XPathExpressionException {
        boolean value = true;
        int accounts = TaxStatementReportLiabilityAccountData.getLiabilityAccountCount(doc);
        for (int i = 1; i <= accounts && value; ++i) {
            int payments = TaxStatementReportLiabilityAccountData.getPaymentCount(doc, i);
            for (int j = 1; j <= payments && value; ++j) {
                String name = TaxStatementReportLiabilityAccountData.getPaymentName(doc, i, j);
                if (name != null && name.length() != 0) continue;
                value = false;
            }
        }
        return value;
    }

    public static String getPaymentName(Document doc, int account, int payment) throws XPathExpressionException {
        return TaxStatementReportUtil.getValue(doc, "/taxStatement/listOfLiabilities/liabilityAccount[" + account + "]/payment[" + payment + "]/@name");
    }

    public static Date getPaymentPaymentDate(Document doc, int account, int payment) throws ParseException, XPathExpressionException {
        return TaxStatementReportUtil.getValueDate(doc, "/taxStatement/listOfLiabilities/liabilityAccount[" + account + "]/payment[" + payment + "]/@paymentDate");
    }
}

