/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.report;

import ch.ewv.taxstatement.report.TaxStatementReportCase;
import ch.ewv.taxstatement.report.TaxStatementReportFormula;
import ch.ewv.taxstatement.report.TaxStatementReportInstitutionData;
import ch.ewv.taxstatement.report.TaxStatementReportOperator;
import ch.ewv.taxstatement.report.TaxStatementReportResult;
import ch.ewv.taxstatement.report.TaxStatementReportResultCase;
import ch.ewv.taxstatement.report.TaxStatementReportResultEntity;
import ch.ewv.taxstatement.report.TaxStatementReportResultStep;
import java.io.IOException;
import java.text.ParseException;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class TaxStatementReportInstitutionCase01
extends TaxStatementReportCase {
    protected TaxStatementReportResultStep execute01(Document doc, Properties lang, TaxStatementReportFormula formula) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        return this.executeCountOne(1, this.getStepDescription(lang, 1), this.getStepCondition(lang, 1), true, TaxStatementReportInstitutionData.getInstitutionCount(doc));
    }

    protected TaxStatementReportResultStep execute02(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity();
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(2, this.getStepDescription(lang, 2), this.getStepCondition(lang, 2));
        String lei = TaxStatementReportInstitutionData.getInstitutionLEI(doc);
        if (lei != null) {
            if (lei.length() == 20) {
                entity.setResult(TaxStatementReportResult.OK).setRemark(lei);
            } else {
                entity.setResult(TaxStatementReportResult.ERROR).setReason(lei);
            }
        } else {
            entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
        }
        step.addEntity(entity);
        return step;
    }

    protected TaxStatementReportResultStep execute03(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity();
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(3, this.getStepDescription(lang, 3), this.getStepCondition(lang, 3));
        String name = TaxStatementReportInstitutionData.getInstitutionName(doc);
        if (name != null) {
            if (name.length() >= 0 && name.length() <= 60) {
                entity.setResult(TaxStatementReportResult.OK).setRemark(name);
            } else if (name.length() > 60) {
                entity.setResult(TaxStatementReportResult.ERROR).setReason(name.length() + " " + (Object)((Object)TaxStatementReportOperator.GREATER) + " 60");
            } else {
                entity.setResult(TaxStatementReportResult.ERROR).setReason(name);
            }
        } else {
            entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
        }
        step.addEntity(entity);
        return step;
    }

    protected TaxStatementReportResultStep execute04(Document doc, Properties lang, TaxStatementReportFormula formula, boolean filter) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity();
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(4, this.getStepDescription(lang, 4), this.getStepCondition(lang, 4));
        String uid = TaxStatementReportInstitutionData.getInstitutionUID(doc);
        if (uid != null) {
            if (uid.length() == 12) {
                entity.setResult(TaxStatementReportResult.OK).setRemark(uid);
            } else {
                entity.setResult(TaxStatementReportResult.ERROR).setReason(uid);
            }
        } else {
            entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
        }
        step.addEntity(entity);
        return step;
    }

    @Override
    public TaxStatementReportResultCase execute(Document doc, byte[] xml, Properties lang, TaxStatementReportFormula formula) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException {
        TaxStatementReportResultCase cs = new TaxStatementReportResultCase(this.getCaseGroup(), this.getCaseId(), this.getCaseGroup(lang), this.getCaseName(lang), this.getCaseDescription(lang));
        TaxStatementReportResult[][] ok = new TaxStatementReportResult[][]{new TaxStatementReportResult[0], {TaxStatementReportResult.OK}, {TaxStatementReportResult.OK}, {TaxStatementReportResult.OK}, {TaxStatementReportResult.OK}};
        cs.addStepResultMandatory(ok[1], this.execute01(doc, lang, formula));
        cs.addStepResultOptional(ok[2], this.execute02(doc, lang, formula, TaxStatementReportInstitutionData.getInstitutionCount(doc) > 0 && TaxStatementReportInstitutionData.getInstitutionLEI(doc) != null));
        cs.addStepResultMandatory(ok[3], this.execute03(doc, lang, formula, TaxStatementReportInstitutionData.getInstitutionCount(doc) > 0));
        cs.addStepResultOptional(ok[4], this.execute04(doc, lang, formula, TaxStatementReportInstitutionData.getInstitutionCount(doc) > 0 && TaxStatementReportInstitutionData.getInstitutionUID(doc) != null));
        return cs;
    }

    public TaxStatementReportInstitutionCase01() {
        super("INSTITUTION_CASE", 1);
    }
}

