/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.report;

import ch.ewv.taxstatement.report.TaxStatementReportUtil;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;

public class TaxStatementReportClientData {
    public static int getClientCount(Document doc) throws XPathExpressionException {
        return TaxStatementReportUtil.getCount(doc, "count(/taxStatement/client)");
    }

    public static String getClientFirstName(Document doc, int client) throws XPathExpressionException {
        return TaxStatementReportUtil.getValue(doc, "/taxStatement/client[" + client + "]/@firstName", true);
    }

    public static String getClientLastName(Document doc, int client) throws XPathExpressionException {
        return TaxStatementReportUtil.getValue(doc, "/taxStatement/client[" + client + "]/@lastName", true);
    }

    public static String getClientNumber(Document doc, int client) throws XPathExpressionException {
        return TaxStatementReportUtil.getValue(doc, "/taxStatement/client[" + client + "]/@clientNumber");
    }

    public static boolean getClientSalutation(Document doc) throws XPathExpressionException {
        boolean value = true;
        int clients = TaxStatementReportClientData.getClientCount(doc);
        for (int i = 1; i <= clients && value; ++i) {
            String salutation = TaxStatementReportClientData.getClientSalutation(doc, i);
            if (salutation != null && salutation.length() != 0) continue;
            value = false;
        }
        return value;
    }

    public static String getClientSalutation(Document doc, int client) throws XPathExpressionException {
        return TaxStatementReportUtil.getValue(doc, "/taxStatement/client[" + client + "]/@salutation");
    }

    public static boolean getClientTIN(Document doc) throws XPathExpressionException {
        boolean value = true;
        int clients = TaxStatementReportClientData.getClientCount(doc);
        for (int i = 1; i <= clients && value; ++i) {
            String tin = TaxStatementReportClientData.getClientTIN(doc, i);
            if (tin != null && tin.length() != 0) continue;
            value = false;
        }
        return value;
    }

    public static String getClientTIN(Document doc, int client) throws XPathExpressionException {
        return TaxStatementReportUtil.getValue(doc, "/taxStatement/client[" + client + "]/@tin");
    }
}

