/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.report;

import ch.ewv.taxstatement.report.TaxStatementReportFormula;
import ch.ewv.taxstatement.report.TaxStatementReportOperator;
import ch.ewv.taxstatement.report.TaxStatementReportResult;
import ch.ewv.taxstatement.report.TaxStatementReportResultCase;
import ch.ewv.taxstatement.report.TaxStatementReportResultEntity;
import ch.ewv.taxstatement.report.TaxStatementReportResultStep;
import ch.ewv.taxstatement.report.TaxStatementReportUtil;
import java.io.IOException;
import java.text.ParseException;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public abstract class TaxStatementReportCase {
    private String caseGroup;
    private int caseId;

    protected String getCaseGroup() {
        return this.caseGroup;
    }

    protected String getCaseGroup(Properties lang) {
        return TaxStatementReportUtil.getText(lang, "SHEET_" + this.getCaseGroup().replace("_CASE", ""));
    }

    protected void setCaseGroup(String caseGroup) {
        this.caseGroup = caseGroup;
    }

    protected int getCaseId() {
        return this.caseId;
    }

    protected void setCaseId(int caseId) {
        this.caseId = caseId;
    }

    protected String getCaseName(Properties lang) {
        return TaxStatementReportUtil.getText(lang, this.getCaseGroup()) + "-" + String.format("%02d", this.getCaseId());
    }

    protected String getCaseDescription(Properties lang) {
        return TaxStatementReportUtil.getText(lang, this.getCaseGroup() + String.format("%02d", this.getCaseId()) + "_DESCRIPTION");
    }

    protected String getStepCondition(Properties lang, int step) {
        return TaxStatementReportUtil.getText(lang, this.getCaseGroup() + String.format("%02d", this.getCaseId()) + "_STEP" + String.format("%02d", step) + "_COND");
    }

    protected String getStepDescription(Properties lang, int step) {
        return TaxStatementReportUtil.getText(lang, this.getCaseGroup() + String.format("%02d", this.getCaseId()) + "_STEP" + String.format("%02d", step) + "_DESC");
    }

    protected TaxStatementReportResultStep executeCount(int stepId, String description, String condition, boolean filter, int elements) {
        TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity();
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(stepId, description, condition);
        if (elements > 0) {
            entity.setResult(TaxStatementReportResult.OK).setRemark("" + elements);
        } else {
            entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
        }
        step.addEntity(entity);
        return step;
    }

    protected TaxStatementReportResultStep executeCountOne(int stepId, String description, String condition, boolean filter, int elements) {
        TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity();
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(stepId, description, condition);
        if (elements == 1) {
            entity.setResult(TaxStatementReportResult.OK).setRemark("" + elements);
        } else {
            entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE).setReason("" + elements);
        }
        step.addEntity(entity);
        return step;
    }

    protected TaxStatementReportResultStep executeEqual(int stepId, String description, String condition, boolean filter, Double total, Double calc) {
        return this.executeEqual(stepId, description, condition, filter, total, calc, (Double)null);
    }

    protected TaxStatementReportResultStep executeEqual(int stepId, String description, String condition, boolean filter, Double total, Double calc, Double limit) {
        TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity();
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(stepId, description, condition);
        if (total != null || calc != null && calc > 0.0 && filter) {
            if (String.format("%1$,.3f", TaxStatementReportUtil.nvl(total, 0.0)).equals(String.format("%1$,.3f", TaxStatementReportUtil.nvl(calc, 0.0)))) {
                entity.setResult(TaxStatementReportResult.OK).setReason(String.format("%1$,.2f", TaxStatementReportUtil.nvl(calc, 0.0)));
            } else if (TaxStatementReportUtil.approximately(total, calc, 0.01, limit != null).booleanValue()) {
                entity.setResult(TaxStatementReportResult.OK).setReason(String.format("%1$,.2f", TaxStatementReportUtil.nvl(total, 0.0)) + " " + (Object)((Object)TaxStatementReportOperator.APPROXIMATELY) + " " + String.format("%1$,.2f", TaxStatementReportUtil.nvl(calc, 0.0)));
            } else if (limit != null && TaxStatementReportUtil.approximately(total, calc, limit, true).booleanValue()) {
                entity.setResult(TaxStatementReportResult.WARNING).setReason(String.format("%1$,.2f", TaxStatementReportUtil.nvl(total, 0.0)) + " " + (Object)((Object)TaxStatementReportOperator.APPROXIMATELY) + " " + String.format("%1$,.2f", TaxStatementReportUtil.nvl(calc, 0.0)));
            } else {
                entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE).setReason(String.format("%1$,.2f", TaxStatementReportUtil.nvl(total, 0.0)) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", TaxStatementReportUtil.nvl(calc, 0.0)));
            }
        } else {
            entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
        }
        step.addEntity(entity);
        return step;
    }

    protected TaxStatementReportResultStep executeEqual(int stepId, String description, String condition, boolean filter, Double total, Double calc, TaxStatementReportFormula formula) throws ParseException, XPathExpressionException {
        return this.executeEqual(stepId, description, condition, filter, total, calc, formula, null);
    }

    protected TaxStatementReportResultStep executeEqual(int stepId, String description, String condition, boolean filter, Double total, Double calc, TaxStatementReportFormula formula, Double limit) throws ParseException, XPathExpressionException {
        TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity();
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(stepId, description, condition);
        if (total != null || calc != null && calc > 0.0 && filter) {
            if (String.format("%1$,.3f", TaxStatementReportUtil.nvl(total, 0.0)).equals(String.format("%1$,.3f", TaxStatementReportUtil.nvl(calc, 0.0)))) {
                entity.setResult(TaxStatementReportResult.OK).setReason(String.format("%1$,.2f", TaxStatementReportUtil.nvl(calc, 0.0)));
            } else if (TaxStatementReportUtil.approximately(total, calc, 0.01, limit != null).booleanValue()) {
                entity.setResult(TaxStatementReportResult.OK).setReason(String.format("%1$,.2f", TaxStatementReportUtil.nvl(total, 0.0)) + " " + (Object)((Object)TaxStatementReportOperator.APPROXIMATELY) + " " + String.format("%1$,.2f", TaxStatementReportUtil.nvl(calc, 0.0)));
            } else if (formula.approximately(total, calc).booleanValue()) {
                entity.setResult(TaxStatementReportResult.OK).setReason(String.format("%1$,.2f", TaxStatementReportUtil.nvl(total, 0.0)) + " " + (Object)((Object)TaxStatementReportOperator.APPROXIMATELY) + " " + String.format("%1$,.2f", TaxStatementReportUtil.nvl(calc, 0.0)));
            } else if (limit != null && TaxStatementReportUtil.approximately(total, calc, limit, true).booleanValue()) {
                entity.setResult(TaxStatementReportResult.WARNING).setReason(String.format("%1$,.2f", TaxStatementReportUtil.nvl(total, 0.0)) + " " + (Object)((Object)TaxStatementReportOperator.APPROXIMATELY) + " " + String.format("%1$,.2f", TaxStatementReportUtil.nvl(calc, 0.0)));
            } else {
                entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE).setReason(String.format("%1$,.2f", TaxStatementReportUtil.nvl(total, 0.0)) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", TaxStatementReportUtil.nvl(calc, 0.0)));
            }
        } else {
            entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
        }
        step.addEntity(entity);
        return step;
    }

    protected TaxStatementReportResultStep executeEqualGreater(int stepId, String description, String condition, boolean filter, Double total, Double calc) {
        TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity();
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(stepId, description, condition);
        if (total != null || calc != null && calc > 0.0 && filter) {
            if (String.format("%1$,.3f", TaxStatementReportUtil.nvl(total, 0.0)).equals(String.format("%1$,.3f", TaxStatementReportUtil.nvl(calc, 0.0)))) {
                entity.setResult(TaxStatementReportResult.OK).setReason(String.format("%1$,.2f", TaxStatementReportUtil.nvl(calc, 0.0)));
            } else if (TaxStatementReportUtil.approximately(total, calc, 0.01).booleanValue()) {
                entity.setResult(TaxStatementReportResult.OK).setReason(String.format("%1$,.2f", TaxStatementReportUtil.nvl(total, 0.0)) + " " + (Object)((Object)TaxStatementReportOperator.APPROXIMATELY) + " " + String.format("%1$,.2f", TaxStatementReportUtil.nvl(calc, 0.0)));
            } else if (total > calc) {
                entity.setResult(TaxStatementReportResult.IGNORE).setReason(String.format("%1$,.2f", TaxStatementReportUtil.nvl(total, 0.0)) + " " + (Object)((Object)TaxStatementReportOperator.GREATER) + " " + String.format("%1$,.2f", TaxStatementReportUtil.nvl(calc, 0.0)));
            } else {
                entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE).setReason(String.format("%1$,.2f", TaxStatementReportUtil.nvl(total, 0.0)) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", TaxStatementReportUtil.nvl(calc, 0.0)));
            }
        } else {
            entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
        }
        step.addEntity(entity);
        return step;
    }

    protected TaxStatementReportResultStep executeEqualSmaller(int stepId, String description, String condition, boolean filter, Double total, Double calc) {
        TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity();
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(stepId, description, condition);
        if (total != null || calc != null && calc > 0.0 && filter) {
            if (String.format("%1$,.3f", TaxStatementReportUtil.nvl(total, 0.0)).equals(String.format("%1$,.3f", TaxStatementReportUtil.nvl(calc, 0.0)))) {
                entity.setResult(TaxStatementReportResult.OK).setReason(String.format("%1$,.2f", TaxStatementReportUtil.nvl(calc, 0.0)));
            } else if (TaxStatementReportUtil.approximately(total, calc, 0.01).booleanValue()) {
                entity.setResult(TaxStatementReportResult.OK).setReason(String.format("%1$,.2f", TaxStatementReportUtil.nvl(total, 0.0)) + " " + (Object)((Object)TaxStatementReportOperator.APPROXIMATELY) + " " + String.format("%1$,.2f", TaxStatementReportUtil.nvl(calc, 0.0)));
            } else if (total < calc) {
                entity.setResult(TaxStatementReportResult.IGNORE).setReason(String.format("%1$,.2f", TaxStatementReportUtil.nvl(total, 0.0)) + " " + (Object)((Object)TaxStatementReportOperator.SMALLER) + " " + String.format("%1$,.2f", TaxStatementReportUtil.nvl(calc, 0.0)));
            } else {
                entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE).setReason(String.format("%1$,.2f", TaxStatementReportUtil.nvl(total, 0.0)) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", TaxStatementReportUtil.nvl(calc, 0.0)));
            }
        } else {
            entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
        }
        step.addEntity(entity);
        return step;
    }

    protected TaxStatementReportResultStep executeExist(int stepId, String description, String condition, boolean filter, Double total) {
        TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity();
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(stepId, description, condition);
        if (total != null && total >= 0.0) {
            entity.setResult(TaxStatementReportResult.OK).setRemark(String.format("%1$,.2f", TaxStatementReportUtil.nvl(total, 0.0)));
        } else {
            entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
        }
        step.addEntity(entity);
        return step;
    }

    protected TaxStatementReportResultStep executeRound(int stepId, String description, String condition, boolean filter, Double total) {
        TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity();
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(stepId, description, condition);
        if (total != null) {
            if (String.format("%1$,.3f", total).equals(String.format("%1$,.3f", TaxStatementReportUtil.round(total)))) {
                entity.setResult(TaxStatementReportResult.OK).setReason(String.format("%1$,.2f", total));
            } else if (String.format("%1$,.2f", total).equals(String.format("%1$,.2f", TaxStatementReportUtil.round(total)))) {
                entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE).setReason(String.format("%1$,.3f", total) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", TaxStatementReportUtil.round(total)));
            } else {
                entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE).setReason(String.format("%1$,.2f", total) + " " + (Object)((Object)TaxStatementReportOperator.NOTEQUAL) + " " + String.format("%1$,.2f", TaxStatementReportUtil.round(total)));
            }
        } else {
            entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
        }
        step.addEntity(entity);
        return step;
    }

    protected TaxStatementReportResultStep executeTotal(int stepId, String description, String condition, boolean filter, Double total) {
        TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity();
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(stepId, description, condition);
        if (total != null) {
            entity.setResult(filter ? TaxStatementReportResult.OK : TaxStatementReportResult.IGNORE).setReason(String.format("%1$,.2f", total));
        } else {
            entity.setResult(filter ? TaxStatementReportResult.ERROR : TaxStatementReportResult.IGNORE);
        }
        step.addEntity(entity);
        return step;
    }

    protected TaxStatementReportResultStep executeTotalNull(int stepId, String description, String condition, boolean filter, Double total) {
        TaxStatementReportResultEntity entity = new TaxStatementReportResultEntity();
        TaxStatementReportResultStep step = new TaxStatementReportResultStep(stepId, description, condition);
        if (total == null) {
            entity.setResult(filter ? TaxStatementReportResult.OK : TaxStatementReportResult.IGNORE);
        } else {
            entity.setResult(TaxStatementReportResult.ERROR).setReason(String.format("%1$,.2f", total));
        }
        step.addEntity(entity);
        return step;
    }

    public abstract TaxStatementReportResultCase execute(Document var1, byte[] var2, Properties var3, TaxStatementReportFormula var4) throws IOException, ParseException, ParserConfigurationException, SAXException, XPathExpressionException;

    protected TaxStatementReportCase(String caseGroup, int caseId) {
        this.caseGroup = caseGroup;
        this.caseId = caseId;
    }
}

