/*
 * Decompiled with CFR 0.152.
 */
package ch.ewv.taxstatement.report;

import ch.ewv.taxstatement.report.TaxStatementReportUtil;
import java.text.ParseException;
import java.util.Date;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;

public class TaxStatementReportBankAccountData {
    public static Double getTotalTaxValue(Document doc) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfBankAccounts/@totalTaxValue");
    }

    public static Double getTotalTaxValue(Document doc, int account) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/@totalTaxValue");
    }

    public static Double getTotalGrossRevenueA(Document doc) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfBankAccounts/@totalGrossRevenueA");
    }

    public static Double getTotalGrossRevenueA(Document doc, int account) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/@totalGrossRevenueA");
    }

    public static Double getTotalGrossRevenueB(Document doc) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfBankAccounts/@totalGrossRevenueB");
    }

    public static Double getTotalGrossRevenueB(Document doc, int account) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/@totalGrossRevenueB");
    }

    public static Double getTotalWithHoldingTaxClaim(Document doc) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfBankAccounts/@totalWithHoldingTaxClaim");
    }

    public static Double getTotalWithHoldingTaxClaim(Document doc, int account) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/@totalWithHoldingTaxClaim");
    }

    public static int getBankAccountCount(Document doc) throws XPathExpressionException {
        return TaxStatementReportUtil.getCount(doc, "count(/taxStatement/listOfBankAccounts/bankAccount)");
    }

    public static boolean getBankAccountClosingDate(Document doc) throws ParseException, XPathExpressionException {
        boolean value = true;
        int accounts = TaxStatementReportBankAccountData.getBankAccountCount(doc);
        for (int i = 1; i <= accounts && value; ++i) {
            Date closingDate = TaxStatementReportBankAccountData.getBankAccountClosingDate(doc, i);
            if (closingDate != null) continue;
            value = false;
        }
        return value;
    }

    public static Date getBankAccountClosingDate(Document doc, int account) throws ParseException, XPathExpressionException {
        return TaxStatementReportUtil.getValueDate(doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/@closingDate");
    }

    public static String getBankAccountCountry(Document doc, int account) throws XPathExpressionException {
        return TaxStatementReportUtil.getValue(doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/@bankAccountCountry");
    }

    public static String getBankAccountCurrency(Document doc, int account) throws XPathExpressionException {
        return TaxStatementReportUtil.getValue(doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/@bankAccountCurrency");
    }

    public static String getBankAccountIBAN(Document doc, int account) throws XPathExpressionException {
        return TaxStatementReportUtil.getValue(doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/@iban");
    }

    public static String getBankAccountName(Document doc, int account) throws XPathExpressionException {
        return TaxStatementReportUtil.getValue(doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/@bankAccountName");
    }

    public static boolean getBankAccountNumber(Document doc) throws XPathExpressionException {
        boolean value = true;
        int accounts = TaxStatementReportBankAccountData.getBankAccountCount(doc);
        for (int i = 1; i <= accounts && value; ++i) {
            String number = TaxStatementReportBankAccountData.getBankAccountNumber(doc, i);
            if (number != null && number.length() != 0) continue;
            value = false;
        }
        return value;
    }

    public static String getBankAccountNumber(Document doc, int account) throws XPathExpressionException {
        return TaxStatementReportUtil.getValue(doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/@bankAccountNumber");
    }

    public static boolean getBankAccountOpeningDate(Document doc) throws ParseException, XPathExpressionException {
        boolean value = true;
        int accounts = TaxStatementReportBankAccountData.getBankAccountCount(doc);
        for (int i = 1; i <= accounts && value; ++i) {
            Date openingDate = TaxStatementReportBankAccountData.getBankAccountOpeningDate(doc, i);
            if (openingDate != null) continue;
            value = false;
        }
        return value;
    }

    public static Date getBankAccountOpeningDate(Document doc, int account) throws ParseException, XPathExpressionException {
        return TaxStatementReportUtil.getValueDate(doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/@openingDate");
    }

    public static int getTaxValueCount(Document doc) throws XPathExpressionException {
        int count = 0;
        int accounts = TaxStatementReportBankAccountData.getBankAccountCount(doc);
        for (int i = 1; i <= accounts; ++i) {
            count += TaxStatementReportBankAccountData.getTaxValueCount(doc, i);
        }
        return count;
    }

    public static int getTaxValueCount(Document doc, int account) throws XPathExpressionException {
        return TaxStatementReportUtil.getCount(doc, "count(/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/taxValue)");
    }

    public static boolean getTaxValueBalance(Document doc) throws XPathExpressionException {
        boolean value = true;
        int accounts = TaxStatementReportBankAccountData.getBankAccountCount(doc);
        for (int i = 1; i <= accounts; ++i) {
            int taxValues = TaxStatementReportBankAccountData.getTaxValueCount(doc, i);
            for (int j = 1; j <= taxValues && value; ++j) {
                Double balance = TaxStatementReportBankAccountData.getTaxValueBalance(doc, i, j);
                if (balance != null) continue;
                value = false;
            }
        }
        return value;
    }

    public static Double getTaxValueBalance(Document doc, int account, int taxValue) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/taxValue[" + taxValue + "]/@balance");
    }

    public static boolean getTaxValueBalanceCurrency(Document doc) throws XPathExpressionException {
        boolean value = true;
        int accounts = TaxStatementReportBankAccountData.getBankAccountCount(doc);
        for (int i = 1; i <= accounts; ++i) {
            int taxValues = TaxStatementReportBankAccountData.getTaxValueCount(doc, i);
            for (int j = 1; j <= taxValues && value; ++j) {
                String currency = TaxStatementReportBankAccountData.getTaxValueBalanceCurrency(doc, i, j);
                if (currency == null || !currency.equals("CHF")) continue;
                value = false;
            }
        }
        return value;
    }

    public static String getTaxValueBalanceCurrency(Document doc, int account, int taxValue) throws XPathExpressionException {
        return TaxStatementReportUtil.getValue(doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/taxValue[" + taxValue + "]/@balanceCurrency");
    }

    public static boolean getTaxValueExchangeRate(Document doc) throws XPathExpressionException {
        boolean value = true;
        int accounts = TaxStatementReportBankAccountData.getBankAccountCount(doc);
        for (int i = 1; i <= accounts; ++i) {
            int taxValues = TaxStatementReportBankAccountData.getTaxValueCount(doc, i);
            for (int j = 1; j <= taxValues && value; ++j) {
                Double exchangeRate = TaxStatementReportBankAccountData.getTaxValueExchangeRate(doc, i, j);
                if (exchangeRate != null) continue;
                value = false;
            }
        }
        return value;
    }

    public static Double getTaxValueExchangeRate(Document doc, int account, int taxValue) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/taxValue[" + taxValue + "]/@exchangeRate");
    }

    public static boolean getTaxValueName(Document doc) throws XPathExpressionException {
        boolean value = true;
        int accounts = TaxStatementReportBankAccountData.getBankAccountCount(doc);
        for (int i = 1; i <= accounts; ++i) {
            int taxValues = TaxStatementReportBankAccountData.getTaxValueCount(doc, i);
            for (int j = 1; j <= taxValues && value; ++j) {
                String name = TaxStatementReportBankAccountData.getTaxValueName(doc, i, j);
                if (name != null && name.length() != 0) continue;
                value = false;
            }
        }
        return value;
    }

    public static String getTaxValueName(Document doc, int account, int taxValue) throws XPathExpressionException {
        return TaxStatementReportUtil.getValue(doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/taxValue[" + taxValue + "]/@name");
    }

    public static Date getTaxValueReferenceDate(Document doc, int account, int taxValue) throws ParseException, XPathExpressionException {
        return TaxStatementReportUtil.getValueDate(doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/taxValue[" + taxValue + "]/@referenceDate");
    }

    public static Double getTaxValueValue(Document doc, int account) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/taxValue/@value");
    }

    public static Double getTaxValueValue(Document doc, int account, int taxValue) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/taxValue[" + taxValue + "]/@value");
    }

    public static int getPaymentCount(Document doc) throws XPathExpressionException {
        int count = 0;
        int accounts = TaxStatementReportBankAccountData.getBankAccountCount(doc);
        for (int i = 1; i <= accounts; ++i) {
            count += TaxStatementReportBankAccountData.getPaymentCount(doc, i);
        }
        return count;
    }

    public static int getPaymentCount(Document doc, int account) throws XPathExpressionException {
        return TaxStatementReportUtil.getCount(doc, "count(/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/payment)");
    }

    public static boolean getPaymentAmount(Document doc) throws XPathExpressionException {
        boolean value = true;
        int accounts = TaxStatementReportBankAccountData.getBankAccountCount(doc);
        for (int i = 1; i <= accounts; ++i) {
            int payments = TaxStatementReportBankAccountData.getPaymentCount(doc, i);
            for (int j = 1; j <= payments && value; ++j) {
                Double amount = TaxStatementReportBankAccountData.getPaymentAmount(doc, i, j);
                if (amount != null) continue;
                value = false;
            }
        }
        return value;
    }

    public static Double getPaymentAmount(Document doc, int account, int payment) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/payment[" + payment + "]/@amount");
    }

    public static boolean getPaymentAmountCurrency(Document doc) throws XPathExpressionException {
        boolean value = true;
        int accounts = TaxStatementReportBankAccountData.getBankAccountCount(doc);
        for (int i = 1; i <= accounts; ++i) {
            int payments = TaxStatementReportBankAccountData.getPaymentCount(doc, i);
            for (int j = 1; j <= payments && value; ++j) {
                String currency = TaxStatementReportBankAccountData.getPaymentAmountCurrency(doc, i, j);
                if (currency == null || !currency.equals("CHF")) continue;
                value = false;
            }
        }
        return value;
    }

    public static String getPaymentAmountCurrency(Document doc, int account, int payment) throws XPathExpressionException {
        return TaxStatementReportUtil.getValue(doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/payment[" + payment + "]/@amountCurrency");
    }

    public static boolean getPaymentExchangeRate(Document doc) throws XPathExpressionException {
        boolean value = true;
        int accounts = TaxStatementReportBankAccountData.getBankAccountCount(doc);
        for (int i = 1; i <= accounts; ++i) {
            int payments = TaxStatementReportBankAccountData.getPaymentCount(doc, i);
            for (int j = 1; j <= payments && value; ++j) {
                Double exchangeRate = TaxStatementReportBankAccountData.getPaymentExchangeRate(doc, i, j);
                if (exchangeRate != null) continue;
                value = false;
            }
        }
        return value;
    }

    public static Double getPaymentExchangeRate(Document doc, int account, int payment) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/payment[" + payment + "]/@exchangeRate");
    }

    public static Double getPaymentGrossRevenueA(Document doc, int account, int payment) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/payment[" + payment + "]/@grossRevenueA");
    }

    public static Double getPaymentGrossRevenueB(Document doc, int account, int payment) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/payment[" + payment + "]/@grossRevenueB");
    }

    public static boolean getPaymentName(Document doc) throws XPathExpressionException {
        boolean value = true;
        int accounts = TaxStatementReportBankAccountData.getBankAccountCount(doc);
        for (int i = 1; i <= accounts; ++i) {
            int payments = TaxStatementReportBankAccountData.getPaymentCount(doc, i);
            for (int j = 1; j <= payments && value; ++j) {
                String name = TaxStatementReportBankAccountData.getPaymentName(doc, i, j);
                if (name != null && name.length() != 0) continue;
                value = false;
            }
        }
        return value;
    }

    public static String getPaymentName(Document doc, int account, int payment) throws XPathExpressionException {
        return TaxStatementReportUtil.getValue(doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/payment[" + payment + "]/@name");
    }

    public static Date getPaymentPaymentDate(Document doc, int account, int payment) throws ParseException, XPathExpressionException {
        return TaxStatementReportUtil.getValueDate(doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/payment[" + payment + "]/@paymentDate");
    }

    public static Double getPaymentWithHoldingTaxClaim(Document doc, int account, int payment) throws XPathExpressionException {
        return TaxStatementReportUtil.getValueNumber(doc, "/taxStatement/listOfBankAccounts/bankAccount[" + account + "]/payment[" + payment + "]/@withHoldingTaxClaim");
    }

    public static Double getPaymentWithHoldingTaxClaimCalc(Document doc, int account, int payment) throws XPathExpressionException {
        Double grossRevenueA = TaxStatementReportBankAccountData.getPaymentGrossRevenueA(doc, account, payment);
        Double withHoldingTaxClaim = null;
        if (grossRevenueA != null) {
            withHoldingTaxClaim = grossRevenueA * 0.35;
        }
        return withHoldingTaxClaim;
    }
}

